/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.hyperlink.helper;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.infra.core.editorsfactory.IPageIconsRegistry;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageManager;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.hyperlink.Activator;
import org.eclipse.papyrus.infra.hyperlink.commands.CreateHyperLinkPageCommand;
import org.eclipse.papyrus.infra.hyperlink.helper.AbstractHyperLinkHelper;
import org.eclipse.papyrus.infra.hyperlink.helper.IHyperlinkHelperExtension;
import org.eclipse.papyrus.infra.hyperlink.messages.Messages;
import org.eclipse.papyrus.infra.hyperlink.object.HyperLinkEditor;
import org.eclipse.papyrus.infra.hyperlink.object.HyperLinkObject;
import org.eclipse.papyrus.infra.hyperlink.ui.EditorHyperLinkEditorShell;
import org.eclipse.papyrus.infra.hyperlink.util.HyperLinkConstants;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorHyperLinkHelper
extends AbstractHyperLinkHelper
implements IHyperlinkHelperExtension {
    @Override
    public String getNameofManagedHyperLink() {
        return Messages.EditorHyperLinkHelper_Editor;
    }

    @Override
    public void executeNewMousePressed(List<HyperLinkObject> list, EObject aModel) {
        IPageIconsRegistry editorRegistry;
        try {
            editorRegistry = (IPageIconsRegistry)ServiceUtilsForEObject.getInstance().getService(IPageIconsRegistry.class, (Object)aModel);
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
            return;
        }
        EditorHyperLinkEditorShell editor = new EditorHyperLinkEditorShell(editorRegistry, aModel);
        editor.open();
        if (editor.getHyperLinkEditor() != null) {
            list.add(editor.getHyperLinkEditor());
        }
    }

    @Override
    public List<HyperLinkObject> getFilteredObject(List<HyperLinkObject> hyperLinkObjects) {
        ArrayList<HyperLinkObject> result = new ArrayList<HyperLinkObject>();
        for (HyperLinkObject current : hyperLinkObjects) {
            if (!(current instanceof HyperLinkEditor)) continue;
            result.add(current);
        }
        return result;
    }

    @Override
    public HyperLinkObject getHyperLinkObject(EAnnotation eAnnotation) {
        return this.getHyperLinkObjectFor(eAnnotation);
    }

    @Override
    public RecordingCommand getAddHyperLinkCommand(TransactionalEditingDomain domain, EModelElement object, HyperLinkObject hyperLinkObject) {
        if (hyperLinkObject instanceof HyperLinkEditor) {
            HyperLinkEditor hyperLinkEditor = (HyperLinkEditor)hyperLinkObject;
            return new CreateHyperLinkPageCommand(domain, object, hyperLinkEditor.getTooltipText(), "PapyrusHyperLink_Page", (EObject)hyperLinkEditor.getObject(), hyperLinkObject.getIsDefault());
        }
        return null;
    }

    public HyperLinkEditor getHyperLinkObjectFor(Object editor) {
        HyperLinkEditor hyperLinkEditor = new HyperLinkEditor();
        hyperLinkEditor.setObject(editor);
        return hyperLinkEditor;
    }

    public HyperLinkEditor getHyperLinkObjectFor(EAnnotation eAnnotation) {
        String[] stringArray = HyperLinkConstants.validHyperLinkPageSources;
        int n = HyperLinkConstants.validHyperLinkPageSources.length;
        int n2 = 0;
        while (n2 < n) {
            String source = stringArray[n2];
            if (source.equals(eAnnotation.getSource()) && !eAnnotation.getReferences().isEmpty()) {
                HyperLinkEditor editor = new HyperLinkEditor();
                editor.setObject(eAnnotation.getReferences().get(0));
                editor.setIsDefault(Boolean.parseBoolean((String)eAnnotation.getDetails().get((Object)"is_default_navigation")));
                editor.setTooltipText((String)eAnnotation.getDetails().get((Object)"tooltip_text"));
                return editor;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public Command getCreateHyperlinkCommand(TransactionalEditingDomain domain, EModelElement linkOwner, Object linkTarget) {
        CreateHyperLinkPageCommand result = null;
        try {
            ServicesRegistry registry = ServiceUtilsForEObject.getInstance().getServiceRegistry((EObject)linkOwner);
            IPageManager pageManager = ServiceUtils.getInstance().getIPageManager((Object)registry);
            if (linkTarget instanceof EObject && pageManager.allPages().contains(linkTarget)) {
                ILabelProvider labelProvider = ((LabelProviderService)registry.getService(LabelProviderService.class)).getLabelProvider();
                String text = labelProvider.getText(linkTarget);
                result = new CreateHyperLinkPageCommand(domain, linkOwner, text, text, (EObject)linkTarget, true);
            }
        }
        catch (ServiceException ex) {
            Activator.log.error((Throwable)ex);
        }
        return result;
    }
}

