/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.utils;

import net.sf.jautodoc.utils.TextEditHelper;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class LineDelimiterConverter {
    public static String convert(String text, String newDelimiter) throws BadLocationException {
        return LineDelimiterConverter.convert((IDocument)new Document(text), newDelimiter).get();
    }

    public static IDocument convert(IDocument document, String newDelimiter) throws BadLocationException {
        MultiTextEdit textEdit = new MultiTextEdit();
        int lineCount = document.getNumberOfLines();
        int i = 0;
        while (i < lineCount) {
            String delimiter = document.getLineDelimiter(i);
            if (delimiter != null && delimiter.length() != 0 && !delimiter.equals(newDelimiter)) {
                IRegion region = document.getLineInformation(i);
                textEdit.addChild((TextEdit)new ReplaceEdit(region.getOffset() + region.getLength(), delimiter.length(), newDelimiter));
            }
            ++i;
        }
        if (textEdit.hasChildren()) {
            new TextEditHelper(document, (TextEdit)textEdit).apply(0);
        }
        return document;
    }
}

