/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.templates.velocity.contentassist;

import net.sf.jautodoc.templates.velocity.contentassist.DirectiveManager;
import net.sf.jautodoc.templates.velocity.rules.DirectiveDetector;
import net.sf.jautodoc.utils.Utils;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;

public class AutoIndentStrategy
implements IAutoEditStrategy {
    private DirectiveDetector directiveDetector = new DirectiveDetector();

    public void customizeDocumentCommand(IDocument d, DocumentCommand c) {
        if (d.getLength() == 0 || c.offset == -1 || c.length > 0 || c.text == null) {
            return;
        }
        String[] lineDelimiters = d.getLegalLineDelimiters();
        int index = TextUtilities.endsWith((String[])lineDelimiters, (String)c.text);
        if (index > -1 && lineDelimiters[index].equals(c.text)) {
            this.indentAfterNewLine(d, c);
        }
    }

    private void indentAfterNewLine(IDocument d, DocumentCommand c) {
        try {
            String partition = Utils.getPartition(d, c.offset);
            IRegion info = d.getLineInformation(d.getLineOfOffset(c.offset));
            int lineOffset = info.getOffset();
            int lineLength = info.getLength();
            String line = d.get(lineOffset, lineLength).trim();
            if (line.length() == 0 || line.endsWith("*/")) {
                return;
            }
            int eow = this.findEndOfWhiteSpace(d, lineOffset, c.offset);
            String indention = "";
            StringBuffer buf = new StringBuffer(c.text);
            if (eow > lineOffset) {
                indention = d.get(lineOffset, eow - lineOffset);
                buf.append(indention);
            }
            if (this.isInsideBrackets(d, lineOffset, c.offset)) {
                return;
            }
            if (partition.equals("__multiline_comment")) {
                this.handleMultiLineCommentPartition(d, eow, buf);
            } else if (partition.equals("__singleline_comment")) {
                this.handleSingleLineCommentPartition(d, indention, buf);
            } else {
                this.handleDefaultPartition(d, c, info, eow, indention, buf);
            }
            c.text = buf.toString();
        }
        catch (BadLocationException badLocationException) {}
    }

    private void handleMultiLineCommentPartition(IDocument d, int eow, StringBuffer buf) throws BadLocationException {
        if (d.getChar(eow) == '#') {
            buf.append(" * ");
        } else {
            buf.append("* ");
        }
    }

    private void handleSingleLineCommentPartition(IDocument d, String indention, StringBuffer buf) throws BadLocationException {
        if (indention.length() == 0) {
            buf.append(" * ");
        } else {
            buf.append("* ");
        }
    }

    private void handleDefaultPartition(IDocument d, DocumentCommand c, IRegion lineInfo, int eow, String indention, StringBuffer buf) throws BadLocationException {
        char ch = d.getChar(eow);
        if (ch == '/' && eow + 1 < d.getLength() && (d.getChar(eow + 1) == '*' || d.getChar(eow + 1) == '/')) {
            if (d.getChar(eow + 1) == '*') {
                buf.append(" * ");
                c.caretOffset = c.offset + buf.length();
                c.shiftsCaret = false;
                buf.append(String.valueOf(d.getLegalLineDelimiters()[0]) + indention + " */");
            } else {
                buf.append("// ");
            }
        } else if (ch == '#' && eow + 1 < d.getLength() && d.getChar(eow + 1) == '*') {
            buf.append(" * ");
            c.caretOffset = c.offset + buf.length();
            c.shiftsCaret = false;
            buf.append(String.valueOf(d.getLegalLineDelimiters()[0]) + indention + " *#");
        } else if (this.directiveDetector.isWordStart(ch)) {
            int directiveEnd = eow + 1;
            while (directiveEnd < lineInfo.getOffset() + lineInfo.getLength() && this.directiveDetector.isWordPart(d.getChar(directiveEnd))) {
                ++directiveEnd;
            }
            String directive = d.get(eow, directiveEnd - eow);
            if (DirectiveManager.isMultiLineDirective(directive)) {
                buf.append(" * ");
                c.caretOffset = c.offset + buf.length();
                c.shiftsCaret = false;
                buf.append(String.valueOf(d.getLegalLineDelimiters()[0]) + indention + "#end");
            } else {
                buf.append(" * ");
            }
        } else if (ch != '\r' && ch != '\n' && ch != '<' && !Character.isLetterOrDigit(ch)) {
            buf.append(ch).append(" ");
        }
    }

    private int findEndOfWhiteSpace(IDocument document, int offset, int end) throws BadLocationException {
        while (offset < end) {
            char c = document.getChar(offset);
            if (c != ' ' && c != '\t') {
                return offset;
            }
            ++offset;
        }
        return end;
    }

    private boolean isInsideBrackets(IDocument d, int start, int end) throws BadLocationException {
        int cntLeftParenthesis = 0;
        int cntRightParenthesis = 0;
        int cntLeftBrace = 0;
        int cntRightBrace = 0;
        int cntLeftBracket = 0;
        int cntRightBracket = 0;
        int cntSingleQuote = 0;
        int cntDoubleQuote = 0;
        int i = start;
        while (i < end) {
            char ch = d.getChar(i);
            if (ch == '(') {
                ++cntLeftParenthesis;
            } else if (ch == '{') {
                ++cntLeftBrace;
            } else if (ch == '[') {
                ++cntLeftBracket;
            } else if (ch == ')') {
                ++cntRightParenthesis;
            } else if (ch == '}') {
                ++cntRightBrace;
            } else if (ch == ']') {
                ++cntRightBracket;
            } else if (ch == '\"') {
                ++cntDoubleQuote;
            } else if (ch == '\'') {
                ++cntSingleQuote;
            }
            ++i;
        }
        return cntLeftParenthesis > cntRightParenthesis || cntLeftBrace > cntRightBrace || cntLeftBracket > cntRightBracket || cntDoubleQuote % 2 == 1 || cntSingleQuote % 2 == 1;
    }
}

