/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.templates.velocity;

import java.util.ArrayList;
import java.util.Map;
import net.sf.jautodoc.IApplicationContext;
import net.sf.jautodoc.JAutodocPlugin;
import net.sf.jautodoc.templates.ITemplateManager;
import net.sf.jautodoc.templates.NullTemplateManager;
import net.sf.jautodoc.templates.contentassist.AutoCloseStrategy;
import net.sf.jautodoc.templates.contentassist.ITemplateContentAssistant;
import net.sf.jautodoc.templates.contentassist.TagContentAssistant;
import net.sf.jautodoc.templates.replacements.ITemplateReplacementsProvider;
import net.sf.jautodoc.templates.rules.GeneralRulesStrategie;
import net.sf.jautodoc.templates.rules.IRulesStrategy;
import net.sf.jautodoc.templates.rules.TemplateReplacementsRulesStrategy;
import net.sf.jautodoc.templates.velocity.VelocityTemplateManager;
import net.sf.jautodoc.templates.velocity.contentassist.AutoIndentStrategy;
import net.sf.jautodoc.templates.velocity.contentassist.DirectiveAndCommentStartStrategy;
import net.sf.jautodoc.templates.velocity.contentassist.DirectiveContentAssistant;
import net.sf.jautodoc.templates.velocity.contentassist.ReferenceContentAssistant;
import net.sf.jautodoc.templates.velocity.contentassist.ReferenceTextHover;
import net.sf.jautodoc.templates.velocity.rules.DirectiveRulesStrategie;
import net.sf.jautodoc.templates.velocity.rules.EmptyCommentRule;
import net.sf.jautodoc.templates.velocity.rules.ReferenceRulesStrategie;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.Token;

public class VelocityApplicationContext
implements IApplicationContext {
    private ITemplateManager templateManager;

    @Override
    public ITemplateManager getTemplateManager() {
        if (this.templateManager != null) {
            return this.templateManager;
        }
        this.templateManager = new VelocityTemplateManager();
        try {
            this.templateManager.initialize();
        }
        catch (Exception e) {
            JAutodocPlugin.getDefault().handleException(e);
            this.templateManager = new NullTemplateManager();
        }
        return this.templateManager;
    }

    @Override
    public IRulesStrategy[] getTemplateRuleStrategies() {
        IRulesStrategy[] ruleStrategies = new IRulesStrategy[]{new ReferenceRulesStrategie(), new DirectiveRulesStrategie(), new GeneralRulesStrategie()};
        return ruleStrategies;
    }

    @Override
    public IRulesStrategy[] getTemplatePreviewRuleStrategies(ITemplateReplacementsProvider replacementsProvider) {
        IRulesStrategy[] ruleStrategies = new IRulesStrategy[]{new TemplateReplacementsRulesStrategy(replacementsProvider), new ReferenceRulesStrategie(), new DirectiveRulesStrategie(), new GeneralRulesStrategie()};
        return ruleStrategies;
    }

    @Override
    public ITextHover getTemplateTextHover(Map<String, String> properties) {
        return new ReferenceTextHover(properties);
    }

    @Override
    public ITemplateContentAssistant[] getTemplateContentAssistants(Map<String, String> properties) {
        ITemplateContentAssistant[] assistants = new ITemplateContentAssistant[]{new ReferenceContentAssistant(properties, false), new DirectiveContentAssistant(), new TagContentAssistant()};
        return assistants;
    }

    @Override
    public ITemplateContentAssistant[] getHeaderTemplateContentAssistants(Map<String, String> properties) {
        ITemplateContentAssistant[] assistants = new ITemplateContentAssistant[]{new ReferenceContentAssistant(properties, true), new DirectiveContentAssistant()};
        return assistants;
    }

    @Override
    public ITemplateContentAssistant[] getPackageDocTemplateContentAssistants(Map<String, String> properties) {
        ITemplateContentAssistant[] assistants = new ITemplateContentAssistant[]{new ReferenceContentAssistant(properties, true), new DirectiveContentAssistant(), new TagContentAssistant()};
        return assistants;
    }

    @Override
    public IAutoEditStrategy[] getTemplateAutoEditStrategies() {
        IAutoEditStrategy[] autoEditStrategies = new IAutoEditStrategy[]{new AutoIndentStrategy(), new DirectiveAndCommentStartStrategy(), new AutoCloseStrategy()};
        return autoEditStrategies;
    }

    @Override
    public IPredicateRule[] getTemplatePartitioningRules() {
        Token multiLineComment = new Token((Object)"__multiline_comment");
        Token singleLineComment = new Token((Object)"__singleline_comment");
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new EndOfLineRule("##", (IToken)singleLineComment));
        rules.add((Object)new EmptyCommentRule((IToken)multiLineComment));
        rules.add(new MultiLineRule("#*", "*#", (IToken)multiLineComment));
        return rules.toArray(new IPredicateRule[rules.size()]);
    }
}

