/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.templates.contentassist;

import java.util.List;
import net.sf.jautodoc.templates.contentassist.ITemplateContentAssistant;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

public abstract class AbstractTemplateContentAssistant
implements ITemplateContentAssistant {
    private String[] startSequences;
    private char[] activationCharacters;

    public AbstractTemplateContentAssistant(String[] startSequences, char[] activationCharacters) {
        this.startSequences = startSequences;
        this.activationCharacters = activationCharacters;
    }

    @Override
    public abstract List<ICompletionProposal> getCompletionProposals(IDocument var1, int var2, int var3);

    @Override
    public char[] getActivationCharacters() {
        return this.activationCharacters;
    }

    @Override
    public int getStartPosition(IDocument document, IRegion region, int offset) throws BadLocationException {
        if (offset <= region.getOffset() || offset > region.getOffset() + region.getLength()) {
            return -1;
        }
        int startIndex = -1;
        int endIndex = -1;
        String line = document.get(region.getOffset(), offset - region.getOffset());
        int i = 0;
        while (i < this.startSequences.length) {
            int index = line.lastIndexOf(this.startSequences[i]);
            if (index >= 0) {
                if (startIndex < 0) {
                    startIndex = index;
                    endIndex = startIndex + this.startSequences[i].length();
                } else {
                    int currentEndIndex = index + this.startSequences[i].length();
                    if (currentEndIndex == endIndex && index < startIndex || currentEndIndex > endIndex) {
                        startIndex = index;
                        endIndex = startIndex + this.startSequences[i].length();
                    }
                }
            }
            ++i;
        }
        return startIndex >= 0 ? region.getOffset() + startIndex : -1;
    }
}

