/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.templates;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import net.sf.jautodoc.templates.TemplateEntry;

@XmlType(propOrder={"typeTemplates", "fieldTemplates", "methodTemplates", "parameterTemplates", "exceptionTemplates"})
public class TemplateSet {
    private List<TemplateEntry> typeTemplates = new ArrayList<TemplateEntry>();
    private List<TemplateEntry> methodTemplates = new ArrayList<TemplateEntry>();
    private List<TemplateEntry> fieldTemplates = new ArrayList<TemplateEntry>();
    private List<TemplateEntry> parameterTemplates = new ArrayList<TemplateEntry>();
    private List<TemplateEntry> exceptionTemplates = new ArrayList<TemplateEntry>();

    @XmlElement(name="typeTemplate")
    public List<TemplateEntry> getTypeTemplates() {
        return this.typeTemplates;
    }

    @XmlElement(name="fieldTemplate")
    public List<TemplateEntry> getFieldTemplates() {
        return this.fieldTemplates;
    }

    @XmlElement(name="methodTemplate")
    public List<TemplateEntry> getMethodTemplates() {
        return this.methodTemplates;
    }

    @XmlElement(name="parameterTemplate")
    public List<TemplateEntry> getParameterTemplates() {
        return this.parameterTemplates;
    }

    @XmlElement(name="exceptionTemplate")
    public List<TemplateEntry> getExceptionTemplates() {
        return this.exceptionTemplates;
    }

    public void setFieldTemplates(List<TemplateEntry> fieldTemplates) {
        this.fieldTemplates = fieldTemplates;
    }

    public void setMethodTemplates(List<TemplateEntry> methodTemplates) {
        this.methodTemplates = methodTemplates;
    }

    public void setTypeTemplates(List<TemplateEntry> typeTemplates) {
        this.typeTemplates = typeTemplates;
    }

    public void setParameterTemplates(List<TemplateEntry> parameterTemplates) {
        this.parameterTemplates = parameterTemplates;
    }

    public void setExceptionTemplates(List<TemplateEntry> exceptionTemplates) {
        this.exceptionTemplates = exceptionTemplates;
    }

    public void addTemplate(TemplateEntry entry) {
        List<TemplateEntry> templates = null;
        if (entry.isType()) {
            templates = this.getTypeTemplates();
        } else if (entry.isField()) {
            templates = this.getFieldTemplates();
        } else if (entry.isMethod()) {
            templates = this.getMethodTemplates();
        } else if (entry.isParameter()) {
            templates = this.getParameterTemplates();
        } else if (entry.isException()) {
            templates = this.getExceptionTemplates();
        }
        templates.add(entry);
    }

    public boolean isEmpty() {
        return this.typeTemplates.isEmpty() && this.fieldTemplates.isEmpty() && this.methodTemplates.isEmpty() && this.parameterTemplates.isEmpty() && this.exceptionTemplates.isEmpty();
    }

    public void afterUnmarshal(Unmarshaller unmarshaller, Object parent) {
        if (parent instanceof TemplateEntry) {
            this.initParent(this.typeTemplates, (TemplateEntry)parent);
            this.initParent(this.fieldTemplates, (TemplateEntry)parent);
            this.initParent(this.methodTemplates, (TemplateEntry)parent);
            this.initParent(this.parameterTemplates, (TemplateEntry)parent);
            this.initParent(this.exceptionTemplates, (TemplateEntry)parent);
        }
    }

    private void initParent(List<TemplateEntry> templates, TemplateEntry parent) {
        for (TemplateEntry template : templates) {
            template.setParent(parent);
        }
    }

    public String toString() {
        StringBuffer tmp = new StringBuffer();
        tmp.append("\n------------------------------------------------------------\n");
        int i = 0;
        while (i < this.typeTemplates.size()) {
            tmp.append(this.typeTemplates.get(i));
            tmp.append("\n------------------------------------------------------------\n");
            ++i;
        }
        tmp.append("\n************************************************************\n");
        i = 0;
        while (i < this.fieldTemplates.size()) {
            tmp.append(this.fieldTemplates.get(i));
            tmp.append("\n************************************************************\n");
            ++i;
        }
        tmp.append("\n############################################################\n");
        i = 0;
        while (i < this.methodTemplates.size()) {
            tmp.append(this.methodTemplates.get(i));
            tmp.append("\n############################################################\n");
            ++i;
        }
        tmp.append("\n............................................................\n");
        i = 0;
        while (i < this.parameterTemplates.size()) {
            tmp.append(this.parameterTemplates.get(i));
            tmp.append("\n............................................................\n");
            ++i;
        }
        tmp.append("\n$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$\n");
        i = 0;
        while (i < this.exceptionTemplates.size()) {
            tmp.append(this.exceptionTemplates.get(i));
            tmp.append("\n$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$\n");
            ++i;
        }
        return tmp.toString();
    }
}

