/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.templates;

import java.util.HashSet;
import java.util.Set;
import net.sf.jautodoc.JAutodocPlugin;
import net.sf.jautodoc.templates.LogEntry;
import net.sf.jautodoc.templates.LogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public abstract class TemplateEngineLogger {
    private static Set<LogListener> logListener = new HashSet<LogListener>();

    public static void addLogListener(LogListener listener) {
        logListener.add(listener);
    }

    public static void removeLogListener(LogListener listener) {
        logListener.remove(listener);
    }

    protected void logMessage(LogEntry logEntry) {
        if (logListener.isEmpty()) {
            this.writeErrorLog(logEntry);
            return;
        }
        this.notifyLogListener(logEntry);
    }

    private void notifyLogListener(LogEntry logEntry) {
        if (logEntry.getSeverity() < 1) {
            return;
        }
        for (LogListener listener : logListener) {
            listener.messageLogged(logEntry);
        }
    }

    private void writeErrorLog(LogEntry logEntry) {
        if (logEntry.getSeverity() < 2) {
            return;
        }
        Status status = new Status(logEntry.getSeverity(), "net.sf.jautodoc", 0, "Template: " + logEntry.getMessage(), logEntry.getThrowable());
        JAutodocPlugin.getDefault().getLog().log((IStatus)status);
    }
}

