/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.source;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.sf.jautodoc.JAutodocPlugin;
import net.sf.jautodoc.preferences.Configuration;
import net.sf.jautodoc.preferences.Constants;
import net.sf.jautodoc.source.CommentManager;
import net.sf.jautodoc.source.JavadocInfo;
import net.sf.jautodoc.source.JavadocTag;
import net.sf.jautodoc.utils.SourceUtils;
import net.sf.jautodoc.utils.StringUtils;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jface.text.IDocument;

public class JavadocCreator {
    private static final String[] EMPTY_ARR = new String[0];
    private final Configuration config;

    public JavadocCreator(Configuration config) {
        this.config = config;
    }

    public String createJavadoc(IType type, String indent, String lineSeparator, JavadocInfo jdi) throws JavaModelException {
        List<String> text = jdi.getComment();
        if (text.isEmpty()) {
            if (this.config.isCreateDummyComment()) {
                if (type.isClass()) {
                    text.add(String.valueOf(Constants.JDOC_CLASS) + " " + type.getElementName() + Constants.DOT);
                } else if (type.isInterface()) {
                    text.add(String.valueOf(Constants.JDOC_INTERFACE) + " " + type.getElementName() + Constants.DOT);
                } else if (type.isEnum()) {
                    text.add(String.valueOf(Constants.JDOC_ENUM) + " " + type.getElementName() + Constants.DOT);
                } else {
                    text.add(String.valueOf(Constants.JDOC_THE_UPPER) + " " + type.getElementName() + Constants.DOT);
                }
            } else {
                text.add("");
            }
        } else {
            this.checkForDot(text);
        }
        this.createJavadocForTypeParams(jdi.getParamDoc(), type.getTypeParameters(), (IMember)type);
        return this.createJavadocString(indent, lineSeparator, jdi, SourceUtils.getParameterNames(type));
    }

    public String createJavadoc(IField field, String indent, String lineSeparator, JavadocInfo jdi) throws JavaModelException {
        List<String> text = jdi.getComment();
        if (text.isEmpty()) {
            if (this.config.isCreateDummyComment()) {
                int flags = field.getFlags();
                if (Flags.isStatic((int)flags) && Flags.isFinal((int)flags)) {
                    text.add(String.valueOf(Constants.JDOC_CONSTANT) + " " + field.getElementName() + Constants.DOT);
                } else {
                    String comment = CommentManager.createComment(this.config, field.getElementName(), 2, true, true);
                    comment = !comment.startsWith(Constants.JDOC_THE_UPPER) && !comment.startsWith(Constants.JDOC_THE_LOWER) ? String.valueOf(Constants.JDOC_THE_UPPER) + " " + comment : StringUtils.firstToUpper(comment);
                    text.add(String.valueOf(comment) + Constants.DOT);
                }
            } else {
                text.add("");
            }
        } else {
            this.checkForDot(text);
        }
        return this.createFieldJavadocString(indent, lineSeparator, jdi);
    }

    public String createJavadocFromField(IMethod method, String indent, String lineSeparator, JavadocInfo methodJdi, JavadocInfo fieldJdi) throws JavaModelException {
        String fieldComment;
        if (fieldJdi.getComment().isEmpty()) {
            return "";
        }
        StringBuilder text = new StringBuilder(fieldJdi.getComment().get(0).trim());
        int i = 1;
        while (i < fieldJdi.getComment().size()) {
            text.append(" " + fieldJdi.getComment().get(i).trim());
            ++i;
        }
        int dotIdx = text.indexOf(Constants.DOT);
        String firstSentence = text.substring(0, dotIdx >= 0 ? dotIdx : text.length());
        String string = fieldComment = this.config.isGetterSetterFromFieldFirst() ? firstSentence : text.toString();
        if (fieldComment.length() == 0) {
            return "";
        }
        String methodName = method.getElementName();
        String prefix = StringUtils.getPrefix(methodName);
        if (!("get".equals(prefix) || "set".equals(prefix) || "is".equals(prefix))) {
            return "";
        }
        String[] commentStart = this.config.getReplacementManager().doReplacements(new String[]{prefix}, 1);
        String comment = StringUtils.firstToLower(fieldComment);
        if (methodJdi.getComment().isEmpty()) {
            String methodComment = String.valueOf(StringUtils.firstToUpper(commentStart[0])) + " " + comment + Constants.DOT;
            methodJdi.getComment().add(methodComment.replaceAll("the the", "the").replaceAll("\\.\\.", "."));
        } else {
            this.checkForDot(methodJdi.getComment());
        }
        if ("set".equals(prefix) && method.getParameterNames().length > 0) {
            List<String> paramComment;
            String paramName = method.getParameterNames()[0];
            JavadocTag paramTag = methodJdi.getParamDoc().get(paramName);
            if (paramTag == null) {
                paramTag = new JavadocTag("@param", paramName);
                methodJdi.getParamDoc().put(paramName, paramTag);
            }
            if ((paramComment = paramTag.getComments()).isEmpty()) {
                paramComment.add("the new " + StringUtils.firstToLower(firstSentence).replaceFirst("^the ", ""));
            }
        } else if (methodJdi.getReturnDoc().isEmpty()) {
            methodJdi.getReturnDoc().add("the " + StringUtils.firstToLower(firstSentence).replaceFirst("^the ", ""));
        }
        return this.createJavadocString(indent, lineSeparator, methodJdi, SourceUtils.getParameterNames(method));
    }

    public String createMethodJavadocFromField(IMethod method, String indent, String lineSeparator, JavadocInfo methodJdi, IDocument document, IScanner scanner) throws Exception {
        IField field = SourceUtils.getFieldOfGetterSetter(method);
        if (field == null || !field.exists()) {
            return "";
        }
        JavadocInfo fieldJdi = new JavadocInfo();
        ISourceRange docRange = SourceUtils.findJavadocSourceRange((IMember)field, scanner);
        fieldJdi.parseJavadoc(document.get(docRange.getOffset(), docRange.getLength()));
        if (fieldJdi.getComment().isEmpty()) {
            return "";
        }
        return this.createJavadocFromField(method, indent, lineSeparator, methodJdi, fieldJdi);
    }

    public String createJavadoc(IMethod method, String indent, String lineSeparator, JavadocInfo jdi) throws JavaModelException {
        List<String> text = jdi.getComment();
        if (text.isEmpty()) {
            if (this.config.isCreateDummyComment()) {
                if (method.isConstructor()) {
                    text.add(Constants.JDOC_CONSTRUCTOR);
                } else if (method.isMainMethod()) {
                    text.add(Constants.JDOC_MAIN);
                } else {
                    String comment = CommentManager.createComment(this.config, method.getElementName(), 3, true, true, 2);
                    text.add(String.valueOf(comment) + Constants.DOT);
                }
            } else {
                text.add("");
            }
        } else {
            this.checkForDot(text);
        }
        this.createJavadocForTypeParams(jdi.getParamDoc(), method.getTypeParameters(), (IMember)method);
        this.createJavadocForParameters(jdi.getParamDoc(), method);
        this.createJavadocForReturn(jdi.getReturnDoc(), method);
        this.createJavadocForExceptions(jdi.getThrowsDoc(), method);
        return this.createJavadocString(indent, lineSeparator, jdi, SourceUtils.getParameterNames(method), SourceUtils.getExceptionTypes(method));
    }

    public JavadocInfo applyTemplate(IMember member, JavadocInfo jdi) throws Exception {
        JavadocInfo templateJdi = new JavadocInfo();
        String text = JAutodocPlugin.getContext().getTemplateManager().applyTemplate(member, this.config.getProperties());
        if (text != null && text.length() > 0) {
            templateJdi.parseJavadoc(text);
        }
        return jdi.isEmpty() ? templateJdi : jdi.merge(templateJdi);
    }

    private void createJavadocForTypeParams(Map<String, JavadocTag> paramDoc, ITypeParameter[] typeParameters, IMember member) throws JavaModelException {
        String[] parameterNames = new String[typeParameters.length];
        SourceUtils.getTypeParameterNames(typeParameters, parameterNames);
        String[] stringArray = parameterNames;
        int n = parameterNames.length;
        int n2 = 0;
        while (n2 < n) {
            List<String> comments;
            String paramName = stringArray[n2];
            JavadocTag paramTag = paramDoc.get(paramName);
            if (paramTag == null) {
                paramTag = new JavadocTag("@param", paramName);
                paramDoc.put(paramName, paramTag);
            }
            if ((comments = paramTag.getComments()).isEmpty()) {
                if (!this.config.isCreateDummyComment()) {
                    comments.add("");
                } else {
                    this.applyParameterTemplate(member, "GenericType", paramName, comments);
                    if (comments.isEmpty()) {
                        String comment = "the generic type";
                        if ("<E>".equals(paramName)) {
                            comment = "the element type";
                        } else if ("<K>".equals(paramName)) {
                            comment = "the key type";
                        } else if ("<N>".equals(paramName)) {
                            comment = "the number type";
                        } else if ("<V>".equals(paramName)) {
                            comment = "the value type";
                        }
                        comments.add(comment);
                    }
                }
            }
            ++n2;
        }
    }

    private void createJavadocForParameters(Map<String, JavadocTag> paramDoc, IMethod method) throws JavaModelException {
        String[] parameterNames = method.getParameterNames();
        String[] parameterTypes = method.getParameterTypes();
        int i = 0;
        while (i < parameterNames.length) {
            List<String> comments;
            JavadocTag paramTag = paramDoc.get(parameterNames[i]);
            if (paramTag == null) {
                paramTag = new JavadocTag("@param", parameterNames[i]);
                paramDoc.put(parameterNames[i], paramTag);
            }
            if ((comments = paramTag.getComments()).isEmpty()) {
                if (!this.config.isCreateDummyComment()) {
                    comments.add("");
                } else {
                    this.applyParameterTemplate((IMember)method, parameterTypes[i], parameterNames[i], comments);
                    if (comments.isEmpty()) {
                        String comment = "";
                        String methodName = method.getElementName();
                        if (parameterNames.length == 1 && methodName.startsWith("set") && methodName.length() > "set".length()) {
                            comment = CommentManager.createComment(this.config, methodName.substring("set".length()), 3, true, true);
                            if (comment.length() > 1 && !Character.isUpperCase(comment.charAt(1))) {
                                comment = StringUtils.firstToLower(comment);
                            }
                        } else {
                            comment = CommentManager.createComment(this.config, parameterNames[i], 4, true, true);
                        }
                        if (!comment.startsWith(Constants.JDOC_THE_UPPER) && !comment.startsWith(Constants.JDOC_THE_LOWER)) {
                            comment = String.valueOf(Constants.JDOC_THE_LOWER) + " " + comment;
                        }
                        comments.add(comment);
                    }
                }
            }
            ++i;
        }
    }

    private void applyParameterTemplate(IMember member, String type, String name, List<String> comments) {
        try {
            String text = JAutodocPlugin.getContext().getTemplateManager().applyParameterTemplate(member, type, name, this.config.getProperties());
            if (text != null && text.length() > 0) {
                JavadocInfo jdi = new JavadocInfo();
                jdi.parseJavadoc(text);
                JavadocTag paramTag = jdi.getParamDoc().get(name);
                if (paramTag != null) {
                    comments.addAll(paramTag.getComments());
                }
            }
        }
        catch (Exception e) {
            JAutodocPlugin.getDefault().handleException(e);
        }
    }

    private void createJavadocForReturn(List<String> returnDoc, IMethod method) throws JavaModelException {
        if (!returnDoc.isEmpty()) {
            return;
        }
        String returnType = Signature.getSignatureSimpleName((String)method.getReturnType());
        if ("void".equals(returnType)) {
            return;
        }
        if (this.config.isCreateDummyComment()) {
            String prefix = Constants.JDOC_THE_LOWER;
            String elementName = returnType;
            String methodName = method.getElementName();
            if (methodName.startsWith("get") && methodName.length() > "get".length()) {
                elementName = methodName.substring("get".length());
            } else if (returnType.equalsIgnoreCase("boolean")) {
                prefix = Constants.JDOC_TRUE_IF;
                elementName = methodName;
            }
            String comment = CommentManager.createComment(this.config, elementName, 5, true, true);
            if (comment.length() > 1 && !Character.isUpperCase(comment.charAt(1))) {
                comment = StringUtils.firstToLower(comment);
            }
            returnDoc.add(String.valueOf(prefix) + " " + comment);
        } else {
            returnDoc.add("");
        }
    }

    private void createJavadocForExceptions(Map<String, JavadocTag> throwsDoc, IMethod method) throws JavaModelException {
        String[] exceptionTypes;
        String[] stringArray = exceptionTypes = SourceUtils.getExceptionTypes(method);
        int n = exceptionTypes.length;
        int n2 = 0;
        while (n2 < n) {
            List<String> comments;
            String exceptionType = stringArray[n2];
            JavadocTag throwsTag = throwsDoc.get(exceptionType);
            if (throwsTag == null) {
                throwsTag = new JavadocTag("@throws", exceptionType);
                throwsDoc.put(exceptionType, throwsTag);
            }
            if ((comments = throwsTag.getComments()).isEmpty()) {
                if (!this.config.isCreateDummyComment()) {
                    comments.add("");
                } else {
                    this.applyExceptionTemplate(method, exceptionType, comments);
                    if (comments.isEmpty()) {
                        String comment = CommentManager.createComment(this.config, exceptionType, 6, true, false);
                        if (comment.length() > 1 && !Character.isUpperCase(comment.charAt(1))) {
                            comment = StringUtils.firstToLower(comment);
                        }
                        comments.add(String.valueOf(Constants.JDOC_THE_LOWER) + " " + comment);
                    }
                }
            }
            ++n2;
        }
    }

    private void applyExceptionTemplate(IMethod method, String name, List<String> comments) {
        try {
            String text = JAutodocPlugin.getContext().getTemplateManager().applyExceptionTemplate(method, name, this.config.getProperties());
            if (text != null && text.length() > 0) {
                JavadocInfo jdi = new JavadocInfo();
                jdi.parseJavadoc(text);
                JavadocTag throwsTag = jdi.getThrowsDoc().get(name);
                if (throwsTag != null) {
                    comments.addAll(throwsTag.getComments());
                }
            }
        }
        catch (Exception e) {
            JAutodocPlugin.getDefault().handleException(e);
        }
    }

    private void checkForDot(List<String> comment) {
        String last;
        if (comment == null || comment.isEmpty()) {
            return;
        }
        boolean found = false;
        int i = 0;
        while (i < comment.size()) {
            if (comment.get(i).indexOf(Constants.DOT) >= 0) {
                found = true;
                break;
            }
            ++i;
        }
        if (!found && !(last = comment.get(comment.size() - 1)).trim().equals("")) {
            comment.remove(comment.size() - 1);
            comment.add(String.valueOf(last) + Constants.DOT);
        }
    }

    private String createFieldJavadocString(String indent, String lineSeparator, JavadocInfo jdi) throws JavaModelException {
        StringBuilder javadoc = new StringBuilder("/**" + this.getFieldJavadocSeparator(lineSeparator, jdi.hasTags()));
        for (String text : jdi.getComment()) {
            if (!this.config.isSingleLineComment() || jdi.hasTags()) {
                this.startNewLine(javadoc, indent);
            }
            javadoc.append(text);
            javadoc.append(this.getFieldJavadocSeparator(lineSeparator, jdi.hasTags()));
        }
        if (jdi.hasTags()) {
            this.addEmptyLine(javadoc, indent, lineSeparator);
        }
        List<JavadocTag> tagComments = jdi.getAllTagComments(EMPTY_ARR, EMPTY_ARR);
        Collections.sort(tagComments, new JavadocTag.TagComparator(this.config.getTagOrder(), Collections.EMPTY_LIST, Collections.EMPTY_LIST));
        for (JavadocTag javadocTag : tagComments) {
            javadocTag.addToJavadocString(javadoc, indent, this.getFieldJavadocSeparator(lineSeparator, jdi.hasTags()));
        }
        if (!this.config.isSingleLineComment() || jdi.hasTags()) {
            this.closeJavadoc(javadoc, indent);
        } else {
            javadoc.append("*/");
        }
        return javadoc.toString();
    }

    private String getFieldJavadocSeparator(String lineSeparator, boolean hasTags) {
        return this.config.isSingleLineComment() && !hasTags ? " " : lineSeparator;
    }

    private String createJavadocString(String indent, String lineSeparator, JavadocInfo jdi, String[] parameterNames) throws JavaModelException {
        return this.createJavadocString(indent, lineSeparator, jdi, parameterNames, EMPTY_ARR);
    }

    private String createJavadocString(String indent, String lineSeparator, JavadocInfo jdi, String[] parameterNames, String[] exceptionTypes) throws JavaModelException {
        StringBuilder javadoc = this.startJavadoc(lineSeparator);
        for (String text : jdi.getComment()) {
            this.startNewLine(javadoc, indent);
            javadoc.append(text);
            javadoc.append(lineSeparator);
        }
        List<JavadocTag> tagComments = jdi.getAllTagComments(parameterNames, exceptionTypes);
        Collections.sort(tagComments, new JavadocTag.TagComparator(this.config.getTagOrder(), Arrays.asList(parameterNames), Arrays.asList(exceptionTypes)));
        if (!tagComments.isEmpty()) {
            this.addEmptyLine(javadoc, indent, lineSeparator);
        }
        for (JavadocTag javadocTag : tagComments) {
            javadocTag.addToJavadocString(javadoc, indent, lineSeparator);
        }
        this.closeJavadoc(javadoc, indent);
        return javadoc.toString();
    }

    private StringBuilder startJavadoc(String lineSeparator) {
        StringBuilder javadoc = new StringBuilder("/**" + lineSeparator);
        return javadoc;
    }

    private void closeJavadoc(StringBuilder javadoc, String indent) {
        javadoc.append(indent);
        javadoc.append(" */");
    }

    private void startNewLine(StringBuilder javadoc, String indent) {
        javadoc.append(indent);
        javadoc.append(" * ");
    }

    private void addEmptyLine(StringBuilder javadoc, String indent, String lineSeparator) {
        javadoc.append(indent);
        javadoc.append(" *");
        javadoc.append(lineSeparator);
    }
}

