/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.search;

import net.sf.jautodoc.search.TaskSearchLabelProvider;
import net.sf.jautodoc.search.TaskSearchResultPage;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.viewers.StyledString;

public class TaskSearchSortingLabelProvider
extends TaskSearchLabelProvider {
    public static final int SHOW_ELEMENT_CONTAINER = 1;
    public static final int SHOW_CONTAINER_ELEMENT = 2;
    public static final int SHOW_PATH = 3;
    private static final long FLAGS_QUALIFIED = 36065220642538633L;
    private int currentOrder = 1;

    public TaskSearchSortingLabelProvider(TaskSearchResultPage resultPage) {
        super(resultPage);
    }

    public final String getText(Object element) {
        String text;
        if (element instanceof IImportDeclaration) {
            element = ((IImportDeclaration)element).getParent().getParent();
        }
        if ((text = super.getText(element)).length() > 0) {
            String labelWithCount = this.getLabelWithCounts(element, text);
            if (this.currentOrder == 1) {
                labelWithCount = String.valueOf(labelWithCount) + this.getPostQualification(element);
            }
            return labelWithCount;
        }
        return text;
    }

    public StyledString getStyledText(Object element) {
        StyledString text;
        if (element instanceof IImportDeclaration) {
            element = ((IImportDeclaration)element).getParent().getParent();
        }
        if ((text = super.getStyledText(element)).length() > 0) {
            StyledString countLabel = this.getColoredLabelWithCounts(element, text);
            if (this.currentOrder == 1) {
                countLabel.append(this.getPostQualification(element), StyledString.QUALIFIER_STYLER);
            }
            return countLabel;
        }
        return text;
    }

    public void setOrder(int orderFlag) {
        long flags = 0L;
        if (orderFlag == 1) {
            flags = 36421324767241L;
        } else if (orderFlag == 2) {
            flags = 36065220642538633L;
        } else if (orderFlag == 3) {
            flags = 36082812828583049L;
        }
        this.setTextFlags(flags);
        this.currentOrder = orderFlag;
    }

    private String getPostQualification(Object element) {
        String textLabel = JavaElementLabels.getTextLabel((Object)element, (long)JavaElementLabels.ALL_POST_QUALIFIED);
        int indexOf = textLabel.indexOf(JavaElementLabels.CONCAT_STRING);
        if (indexOf != -1) {
            return textLabel.substring(indexOf);
        }
        return new String();
    }
}

