/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.search;

import java.util.HashSet;
import net.sf.jautodoc.JAutodocPlugin;
import net.sf.jautodoc.preferences.Constants;
import net.sf.jautodoc.search.TaskSearchHelper;
import net.sf.jautodoc.search.TaskSearchPattern;
import net.sf.jautodoc.search.TaskSearchQuery;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkingSet;

public class TaskSearchPage
extends DialogPage
implements ISearchPage {
    private TaskSearchPattern searchPattern;
    private ISearchPageContainer container;
    private IDialogSettings dialogSettings;
    private Button missingJavadocButton;
    private Button missingParamTagButton;
    private Button missingReturnTagButton;
    private Button missingThrowsTagButton;
    private Button missingPeriodsButton;
    private Button generatedJavadocButton;
    private Button todoForGeneratedButton;
    private Button missingHeader;
    private Button outdatedHeader;
    private Button publicButton;
    private Button protectedButton;
    private Button packageButton;
    private Button privateButton;
    private Button filterTypesButton;
    private Button filterFieldsButton;
    private Button filterMethodsButton;
    private Button filterGetSetOnlyButton;
    private Button filterExcludeGetSetButton;
    private Button missingTagsButton;
    private Text missingTagsText;

    public void setContainer(ISearchPageContainer container) {
        this.container = container;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        this.createSearchForGroup(composite);
        this.createVisibilityAndFilterGroups(composite);
        this.createHeaderGroup(composite);
        this.createMissingTagGroup(composite);
        this.updateControlStates();
        this.updateEnablements();
        this.initListener();
        this.setControl((Control)composite);
    }

    public boolean performAction() {
        TaskSearchQuery query = new TaskSearchQuery(this.getCompilationUnits(), this.getUpdatedSearchPattern());
        NewSearchUI.runQueryInBackground((ISearchQuery)query);
        return true;
    }

    public void setVisible(boolean visible) {
        this.updateOKStatus();
        super.setVisible(visible);
    }

    public void dispose() {
        this.getSearchPattern().store(this.getDialogSettings());
        super.dispose();
    }

    private void updateOKStatus() {
        this.container.setPerformActionEnabled(this.isValidSearchPattern());
    }

    private boolean isValidSearchPattern() {
        return this.missingJavadocButton.getSelection() || this.missingParamTagButton.getSelection() || this.missingReturnTagButton.getSelection() || this.missingThrowsTagButton.getSelection() || this.missingPeriodsButton.getSelection() || this.generatedJavadocButton.getSelection() || this.todoForGeneratedButton.getSelection() || this.missingHeader.getSelection() || this.outdatedHeader.getSelection() || this.missingTagsButton.getSelection() && this.missingTagsText.getText().trim().length() > 0;
    }

    private void initListener() {
        UpdateOKListener listener = new UpdateOKListener();
        this.missingJavadocButton.addSelectionListener((SelectionListener)listener);
        this.missingParamTagButton.addSelectionListener((SelectionListener)listener);
        this.missingReturnTagButton.addSelectionListener((SelectionListener)listener);
        this.missingThrowsTagButton.addSelectionListener((SelectionListener)listener);
        this.missingPeriodsButton.addSelectionListener((SelectionListener)listener);
        this.generatedJavadocButton.addSelectionListener((SelectionListener)listener);
        this.todoForGeneratedButton.addSelectionListener((SelectionListener)listener);
        this.missingHeader.addSelectionListener((SelectionListener)listener);
        this.outdatedHeader.addSelectionListener((SelectionListener)listener);
        this.missingTagsButton.addSelectionListener((SelectionListener)listener);
        this.missingTagsText.addModifyListener((ModifyListener)listener);
    }

    private void createVisibilityAndFilterGroups(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 2));
        this.createVisibilityGroup(composite);
        this.createFilterGroup(composite);
    }

    private void createSearchForGroup(Composite parent) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        group.setText("Javadoc");
        this.missingJavadocButton = new Button((Composite)group, 32);
        this.missingJavadocButton.setText("Missing Javadoc");
        this.missingParamTagButton = new Button((Composite)group, 32);
        this.missingParamTagButton.setText("Missing / Invalid @param tag");
        this.missingReturnTagButton = new Button((Composite)group, 32);
        this.missingReturnTagButton.setText("Missing / Invalid @return tag");
        this.missingThrowsTagButton = new Button((Composite)group, 32);
        this.missingThrowsTagButton.setText("Missing / Invalid @throws tag");
        this.generatedJavadocButton = new Button((Composite)group, 32);
        this.generatedJavadocButton.setText("Generated Javadoc");
        this.todoForGeneratedButton = new Button((Composite)group, 32);
        this.todoForGeneratedButton.setText("ToDo for generated Javadoc");
        this.missingPeriodsButton = new Button((Composite)group, 32);
        this.missingPeriodsButton.setText("Missing period on first sentence");
    }

    private void createHeaderGroup(Composite parent) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(1808));
        group.setText("File Header");
        this.missingHeader = new Button((Composite)group, 32);
        this.missingHeader.setText("Missing file header");
        this.outdatedHeader = new Button((Composite)group, 32);
        this.outdatedHeader.setText("Outdated file header");
    }

    private void createVisibilityGroup(Composite parent) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(1808));
        group.setText(Constants.LABEL_VISIBILITY);
        this.publicButton = new Button((Composite)group, 32);
        this.publicButton.setText(Constants.LABEL_VISIBILITY_PUBLIC);
        this.protectedButton = new Button((Composite)group, 32);
        this.protectedButton.setText(Constants.LABEL_VISIBILITY_PROTECTED);
        this.packageButton = new Button((Composite)group, 32);
        this.packageButton.setText(Constants.LABEL_VISIBILITY_PACKAGE);
        this.privateButton = new Button((Composite)group, 32);
        this.privateButton.setText(Constants.LABEL_VISIBILITY_PRIVATE);
    }

    private void createFilterGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Constants.LABEL_FILTER);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(1808));
        this.filterTypesButton = new Button((Composite)group, 32);
        this.filterTypesButton.setText("Types");
        this.filterFieldsButton = new Button((Composite)group, 32);
        this.filterFieldsButton.setText("Fields");
        this.filterMethodsButton = new Button((Composite)group, 32);
        this.filterMethodsButton.setText("Methods");
        this.filterMethodsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TaskSearchPage.this.updateEnablements();
            }
        });
        this.filterGetSetOnlyButton = new Button((Composite)group, 32);
        this.filterGetSetOnlyButton.setText(Constants.LABEL_FILTER_GETSET);
        GridData getterOnlyGridData = new GridData();
        getterOnlyGridData.horizontalIndent = 18;
        this.filterGetSetOnlyButton.setLayoutData((Object)getterOnlyGridData);
        this.filterGetSetOnlyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (TaskSearchPage.this.filterGetSetOnlyButton.getSelection()) {
                    TaskSearchPage.this.filterExcludeGetSetButton.setSelection(false);
                }
            }
        });
        this.filterExcludeGetSetButton = new Button((Composite)group, 32);
        this.filterExcludeGetSetButton.setText("Exclude [G,S]etter");
        GridData excludeGetterGridData = new GridData();
        excludeGetterGridData.horizontalIndent = 18;
        this.filterExcludeGetSetButton.setLayoutData((Object)excludeGetterGridData);
        this.filterExcludeGetSetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (TaskSearchPage.this.filterExcludeGetSetButton.getSelection()) {
                    TaskSearchPage.this.filterGetSetOnlyButton.setSelection(false);
                }
            }
        });
    }

    private void createMissingTagGroup(Composite parent) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        group.setText("Search For Missing Tags");
        this.missingTagsButton = new Button((Composite)group, 32);
        this.missingTagsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TaskSearchPage.this.updateEnablements();
            }
        });
        this.missingTagsText = new Text((Composite)group, 2048);
        this.missingTagsText.setLayoutData((Object)new GridData(4, 4, true, true));
        Label description = new Label((Composite)group, 0);
        description.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        description.setText("Comma separated (tag = missing and empty, tag- = only missing, tag+ = only empty)");
    }

    private void updateEnablements() {
        this.filterGetSetOnlyButton.setEnabled(this.filterMethodsButton.getSelection());
        this.filterExcludeGetSetButton.setEnabled(this.filterMethodsButton.getSelection());
        this.missingTagsText.setEnabled(this.missingTagsButton.getSelection());
    }

    private void updateControlStates() {
        TaskSearchPattern pattern = this.getSearchPattern();
        this.missingJavadocButton.setSelection(pattern.isMissingJavadoc());
        this.missingParamTagButton.setSelection(pattern.isMissingParamTag());
        this.missingReturnTagButton.setSelection(pattern.isMissingReturnTag());
        this.missingThrowsTagButton.setSelection(pattern.isMissingThrowsTag());
        this.missingPeriodsButton.setSelection(pattern.isMissingPeriods());
        this.generatedJavadocButton.setSelection(pattern.isGeneratedJavadoc());
        this.todoForGeneratedButton.setSelection(pattern.isTodoForGenerated());
        this.missingHeader.setSelection(pattern.isMissingHeader());
        this.outdatedHeader.setSelection(pattern.isOutdatedHeader());
        this.publicButton.setSelection(pattern.isIncludePublic());
        this.protectedButton.setSelection(pattern.isIncludeProtected());
        this.packageButton.setSelection(pattern.isIncludePackage());
        this.privateButton.setSelection(pattern.isIncludePrivate());
        this.filterTypesButton.setSelection(pattern.isIncludeTypes());
        this.filterFieldsButton.setSelection(pattern.isIncludeFields());
        this.filterMethodsButton.setSelection(pattern.isIncludeMethods());
        this.filterGetSetOnlyButton.setSelection(pattern.isGetterSetterOnly());
        this.filterExcludeGetSetButton.setSelection(pattern.isExcludeGetterSetter());
        this.missingTagsButton.setSelection(pattern.isSearchMissingTags());
        this.missingTagsText.setText(pattern.getMissingTagString());
    }

    private TaskSearchPattern getUpdatedSearchPattern() {
        TaskSearchPattern pattern = this.getSearchPattern();
        pattern.setMissingJavadoc(this.missingJavadocButton.getSelection());
        pattern.setMissingParamTag(this.missingParamTagButton.getSelection());
        pattern.setMissingReturnTag(this.missingReturnTagButton.getSelection());
        pattern.setMissingThrowsTag(this.missingThrowsTagButton.getSelection());
        pattern.setMissingPeriods(this.missingPeriodsButton.getSelection());
        pattern.setGeneratedJavadoc(this.generatedJavadocButton.getSelection());
        pattern.setTodoForGenerated(this.todoForGeneratedButton.getSelection());
        pattern.setMissingHeader(this.missingHeader.getSelection());
        pattern.setOutdatedHeader(this.outdatedHeader.getSelection());
        pattern.setVisibilityPublic(this.publicButton.getSelection());
        pattern.setVisibilityProtected(this.protectedButton.getSelection());
        pattern.setVisibilityPackage(this.packageButton.getSelection());
        pattern.setVisibilityPrivate(this.privateButton.getSelection());
        pattern.setFilterTypes(this.filterTypesButton.getSelection());
        pattern.setFilterFields(this.filterFieldsButton.getSelection());
        pattern.setFilterMethods(this.filterMethodsButton.getSelection());
        pattern.setFilterGetSetOnly(this.filterGetSetOnlyButton.getSelection());
        pattern.setFilterExcludeGetSet(this.filterExcludeGetSetButton.getSelection());
        pattern.setSearchMissingTags(this.missingTagsButton.getSelection());
        pattern.setMissingTagString(this.missingTagsText.getText().trim());
        return pattern;
    }

    private TaskSearchPattern getSearchPattern() {
        if (this.searchPattern == null) {
            this.searchPattern = TaskSearchPattern.create(this.getDialogSettings());
        }
        return this.searchPattern;
    }

    private IDialogSettings getDialogSettings() {
        if (this.dialogSettings == null) {
            this.dialogSettings = JAutodocPlugin.getDefault().getDialogSettingsSection("TaskSearchPage");
        }
        return this.dialogSettings;
    }

    private ICompilationUnit[] getCompilationUnits() {
        HashSet<ICompilationUnit> cus = new HashSet<ICompilationUnit>();
        try {
            switch (this.container.getSelectedScope()) {
                case 0: {
                    TaskSearchHelper.collectCompilationUnitsOnWorkspace(cus);
                    break;
                }
                case 1: {
                    IStructuredSelection selection = (IStructuredSelection)this.container.getSelection();
                    TaskSearchHelper.collectCompilationUnitsOnSelection(selection, cus);
                    break;
                }
                case 3: {
                    String[] projectNames = this.container.getSelectedProjectNames();
                    TaskSearchHelper.collectCompilationUnitsOnSelectedProjects(projectNames, cus);
                    break;
                }
                case 2: {
                    IWorkingSet[] workingSets = this.container.getSelectedWorkingSets();
                    TaskSearchHelper.collectCompilationUnitsOnWorkingSets(workingSets, cus);
                }
            }
        }
        catch (JavaModelException e) {
            JAutodocPlugin.getDefault().handleException(this.getShell(), (Throwable)e);
        }
        return cus.toArray(new ICompilationUnit[cus.size()]);
    }

    private class UpdateOKListener
    extends SelectionAdapter
    implements ModifyListener {
        private UpdateOKListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            TaskSearchPage.this.updateOKStatus();
        }

        public void modifyText(ModifyEvent e) {
            TaskSearchPage.this.updateOKStatus();
        }
    }
}

