/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.search;

import java.util.HashSet;
import java.util.StringTokenizer;
import net.sf.jautodoc.JAutodocPlugin;
import net.sf.jautodoc.search.TaskSearchMatch;
import org.eclipse.search.ui.text.Match;
import org.eclipse.search.ui.text.MatchFilter;

public class TaskSearchMatchFilter
extends MatchFilter {
    public static MatchFilter[] NO_FILTERS = new TaskSearchMatchFilter[0];
    private static final String SETTINGS_LAST_USED_FILTERS = "filters_last_used";
    private static final TaskSearchMatchFilter[] ALL_FILTERS = new TaskSearchMatchFilter[]{new TaskSearchMatchFilter(TaskSearchMatch.FindingId.MISSING_JAVADOC), new TaskSearchMatchFilter(TaskSearchMatch.FindingId.MISSING_PARAM), new TaskSearchMatchFilter(TaskSearchMatch.FindingId.INVALID_PARAM), new TaskSearchMatchFilter(TaskSearchMatch.FindingId.MISSING_RETURN), new TaskSearchMatchFilter(TaskSearchMatch.FindingId.MISSING_THROWS), new TaskSearchMatchFilter(TaskSearchMatch.FindingId.INVALID_THROWS), new TaskSearchMatchFilter(TaskSearchMatch.FindingId.MISSING_PERIOD), new TaskSearchMatchFilter(TaskSearchMatch.FindingId.TODO_FOR_AUTODOC), new TaskSearchMatchFilter(TaskSearchMatch.FindingId.GENERATED_JAVADOC), new TaskSearchMatchFilter(TaskSearchMatch.FindingId.MISSING_HEADER), new TaskSearchMatchFilter(TaskSearchMatch.FindingId.OUTDATED_HEADER), new TaskSearchMatchFilter(TaskSearchMatch.FindingId.MISSING_TAG)};
    private final TaskSearchMatch.FindingId findingId;

    public TaskSearchMatchFilter(TaskSearchMatch.FindingId findingId) {
        this.findingId = findingId;
    }

    public static TaskSearchMatchFilter[] getAllFilters() {
        return ALL_FILTERS;
    }

    public static MatchFilter[] getLastUsedFilters() {
        String string = JAutodocPlugin.getDefault().getDialogSettings().get(SETTINGS_LAST_USED_FILTERS);
        if (string != null && string.length() > 0) {
            return TaskSearchMatchFilter.decodeFilters(string);
        }
        return NO_FILTERS;
    }

    public static void setLastUsedFilters(MatchFilter[] filters) {
        String encoded = TaskSearchMatchFilter.encodeFilters(filters);
        JAutodocPlugin.getDefault().getDialogSettings().put(SETTINGS_LAST_USED_FILTERS, encoded);
    }

    public boolean filters(Match match) {
        TaskSearchMatch taskSearchMatch = (TaskSearchMatch)match;
        return taskSearchMatch.isFiltered();
    }

    public boolean filters(TaskSearchMatch.Finding finding) {
        return finding.getId() == this.findingId;
    }

    public String getID() {
        return this.findingId.name();
    }

    public String getName() {
        return this.findingId.getLabel();
    }

    public String getActionLabel() {
        return this.findingId.getLabel();
    }

    public String getDescription() {
        return this.findingId.getLabel();
    }

    private static String encodeFilters(MatchFilter[] enabledFilters) {
        StringBuffer buf = new StringBuffer();
        MatchFilter[] matchFilterArray = enabledFilters;
        int n = enabledFilters.length;
        int n2 = 0;
        while (n2 < n) {
            MatchFilter matchFilter = matchFilterArray[n2];
            buf.append(matchFilter.getID());
            buf.append(';');
            ++n2;
        }
        return buf.toString();
    }

    private static TaskSearchMatchFilter[] decodeFilters(String encodedString) {
        HashSet<TaskSearchMatchFilter> result = new HashSet<TaskSearchMatchFilter>();
        StringTokenizer tokenizer = new StringTokenizer(encodedString, String.valueOf(';'));
        while (tokenizer.hasMoreTokens()) {
            TaskSearchMatchFilter curr = TaskSearchMatchFilter.findMatchFilter(tokenizer.nextToken());
            if (curr == null) continue;
            result.add(curr);
        }
        return result.toArray(new TaskSearchMatchFilter[result.size()]);
    }

    private static TaskSearchMatchFilter findMatchFilter(String id) {
        int i = 0;
        while (i < ALL_FILTERS.length) {
            TaskSearchMatchFilter matchFilter = ALL_FILTERS[i];
            if (matchFilter.getID().equals(id)) {
                return matchFilter;
            }
            ++i;
        }
        return null;
    }
}

