/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.search;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.search.ui.text.Match;

public class TaskSearchMatch
extends Match {
    private final List<Finding> findings = new ArrayList<Finding>();

    public TaskSearchMatch(IJavaElement element, int offset, int length, FindingId id, String message) {
        super((Object)element, offset, length);
        this.findings.add(new Finding(this, id, message));
    }

    public void addFinding(FindingId id, String message) {
        this.findings.add(new Finding(this, id, message));
    }

    public Finding[] getFindings() {
        return this.findings.toArray(new Finding[this.findings.size()]);
    }

    public Finding[] getFilteredFindings() {
        ArrayList<Finding> filteredFindings = new ArrayList<Finding>();
        for (Finding finding : this.findings) {
            if (finding.isFiltered()) continue;
            filteredFindings.add(finding);
        }
        return filteredFindings.toArray(new Finding[filteredFindings.size()]);
    }

    public int getFindingCount() {
        return this.findings.size();
    }

    public boolean isFiltered() {
        for (Finding finding : this.findings) {
            if (finding.isFiltered()) continue;
            return false;
        }
        return true;
    }

    public void setFiltered(boolean value) {
    }

    public static class Finding {
        private final Match match;
        private final FindingId id;
        private final String message;
        private boolean filtered;

        public Finding(Match match, FindingId id, String message) {
            this.id = id;
            this.match = match;
            this.message = message;
        }

        public FindingId getId() {
            return this.id;
        }

        public Match getMatch() {
            return this.match;
        }

        public String getMessage() {
            return this.message;
        }

        public boolean isFiltered() {
            return this.filtered;
        }

        public void setFiltered(boolean filtered) {
            this.filtered = filtered;
        }

        public String toString() {
            return String.valueOf(this.id.name()) + ": " + this.message;
        }
    }

    public static enum FindingId {
        MISSING_JAVADOC("Missing Javadoc"),
        MISSING_PARAM("Missing param tag"),
        INVALID_PARAM("Invalid param tag"),
        MISSING_RETURN("Missing return tag"),
        MISSING_THROWS("Missing throws tag"),
        INVALID_THROWS("Invalid throws tag"),
        MISSING_PERIOD("Missing period"),
        TODO_FOR_AUTODOC("ToDo for generated Javadoc"),
        GENERATED_JAVADOC("Generated Javadoc"),
        MISSING_HEADER("Missing file header"),
        OUTDATED_HEADER("Outdated file header"),
        MISSING_TAG("Missing or empty tag");

        private final String label;

        private FindingId(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

