/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.search;

import java.io.IOException;
import java.io.Reader;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.internal.text.InformationControlReplacer;
import org.eclipse.jface.text.AbstractHoverInformationControlManager;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.widgets.Shell;

public class HoverInformationControlManager
extends AbstractHoverInformationControlManager {
    private final ColumnViewer viewer;

    public HoverInformationControlManager(ColumnViewer viewer) {
        super((IInformationControlCreator)new DefaultInformationControlCreator());
        this.setAnchor(ANCHOR_TOP);
        this.viewer = viewer;
        this.install(viewer.getControl());
    }

    protected void computeInformation() {
        ViewerCell cell = this.viewer.getCell(this.getHoverEventLocation());
        if (cell == null) {
            this.setInformation(null, null);
            return;
        }
        Object element = cell.getElement();
        if (!(element instanceof IMember)) {
            this.setInformation(null, null);
            return;
        }
        IMember member = (IMember)element;
        String rawJavadoc = this.getJavadocSource(member);
        if (rawJavadoc == null) {
            this.setInformation(null, null);
            return;
        }
        rawJavadoc = rawJavadoc.replaceAll("\r\n", "<br/>");
        this.setInformation(rawJavadoc, cell.getBounds());
    }

    private static String getString(Reader reader) {
        StringBuffer buf = new StringBuffer();
        char[] buffer = new char[1024];
        try {
            int count;
            while ((count = reader.read(buffer)) != -1) {
                buf.append(buffer, 0, count);
            }
        }
        catch (IOException iOException) {
            return null;
        }
        return buf.toString();
    }

    public void installInformationControlReplacer(InformationControlReplacer replacer) {
        this.getInternalAccessor().setInformationControlReplacer(replacer);
    }

    private String getJavadocSource(IMember member) {
        try {
            ISourceRange javadocRange;
            IBuffer buf = member.getOpenable().getBuffer();
            if (buf != null && (javadocRange = member.getJavadocRange()) != null) {
                String rawJavadoc = buf.getText(javadocRange.getOffset(), javadocRange.getLength());
                return rawJavadoc;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static class DefaultInformationControlCreator
    extends AbstractReusableInformationControlCreator {
        private DefaultInformationControlCreator() {
        }

        public IInformationControl doCreateInformationControl(Shell shell) {
            return new DefaultInformationControl(shell, "Do Something");
        }
    }
}

