/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.preferences.templates;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jautodoc.JAutodocPlugin;
import net.sf.jautodoc.preferences.ConfigurationManager;
import net.sf.jautodoc.preferences.Constants;
import net.sf.jautodoc.preferences.PreferenceStore;
import net.sf.jautodoc.preferences.templates.EditPropertiesDialog;
import net.sf.jautodoc.preferences.templates.EditTemplateDialog;
import net.sf.jautodoc.preferences.templates.TemplateTreePanel;
import net.sf.jautodoc.templates.ITemplateManager;
import net.sf.jautodoc.templates.TemplateEntry;
import net.sf.jautodoc.templates.rules.IRulesStrategy;
import net.sf.jautodoc.templates.rules.TemplateCodeScanner;
import net.sf.jautodoc.templates.viewer.TemplateViewerConfiguration;
import net.sf.jautodoc.utils.StringUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class TemplatePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String PATH = "org.eclipse.jdt.ui.preferences.JavaBasePreferencePage/net.sf.jautodoc.preferences.MainPreferencePage/net.sf.jautodoc.preferences.templates.TemplatePreferencePage";
    private Map<String, String> properties = new HashMap<String, String>(((PreferenceStore)this.getPreferenceStore()).getProperties());
    private TemplateTreePanel view;
    private ITemplateManager templateManager = JAutodocPlugin.getContext().getTemplateManager();
    private TreeItem typeRoot;
    private TreeItem fieldRoot;
    private TreeItem methodRoot;
    private TreeItem parameterRoot;
    private TreeItem exceptionRoot;

    public void refresh() {
        if (this.view != null && this.view.templateTree != null) {
            this.view.templateTree.removeAll();
            this.initializeTemplateTree();
        }
    }

    public void setProperties(Map<String, String> properties) {
        this.properties.clear();
        this.properties.putAll(properties);
    }

    public void init(IWorkbench workbench) {
        this.setDescription(Constants.TEMPLATES_PAGE_DESCRIPTION);
        this.setPreferenceStore((IPreferenceStore)ConfigurationManager.getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        this.view = new TemplateTreePanel(parent, 0);
        this.configureTemplateViewer();
        this.view.templateTree.addListener(35, new Listener(){

            public void handleEvent(Event event) {
                TemplatePreferencePage.this.showPopupMenu(event.x, event.y);
            }
        });
        this.view.buttonAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Rectangle bounds = ((TemplatePreferencePage)TemplatePreferencePage.this).view.buttonAdd.getBounds();
                Point point = ((TemplatePreferencePage)TemplatePreferencePage.this).view.buttonAdd.getParent().toDisplay(bounds.x, bounds.y);
                point.y += bounds.height;
                TemplatePreferencePage.this.showPopupMenu(point.x, point.y);
            }
        });
        this.view.buttonEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem item = ((TemplatePreferencePage)TemplatePreferencePage.this).view.templateTree.getSelection()[0];
                TemplateEntry entry = (TemplateEntry)item.getData();
                if (TemplatePreferencePage.this.showEditTemplateDialog(entry) == 0) {
                    item.setText(StringUtils.getLastElement(entry.getName(), '.'));
                    TemplatePreferencePage.this.showItemData(item);
                }
                ((TemplatePreferencePage)TemplatePreferencePage.this).view.templateTree.setFocus();
            }
        });
        this.view.buttonRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MessageDialog.openConfirm((Shell)TemplatePreferencePage.this.view.getShell(), (String)"Remove Template", (String)"Do you really want to remove this Template?")) {
                    TreeItem selectedItem = ((TemplatePreferencePage)TemplatePreferencePage.this).view.templateTree.getSelection()[0];
                    TreeItem parentItem = selectedItem.getParentItem();
                    int index = parentItem.indexOf(selectedItem);
                    ((List)parentItem.getData()).remove(index);
                    selectedItem.dispose();
                    if (parentItem.getItemCount() == 0 && parentItem.getParentItem() != null) {
                        parentItem.dispose();
                    }
                }
                ((TemplatePreferencePage)TemplatePreferencePage.this).view.templateTree.setFocus();
            }
        });
        this.view.buttonImport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TemplatePreferencePage.this.importTemplates();
            }
        });
        this.view.buttonExport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TemplatePreferencePage.this.exportTemplates();
            }
        });
        this.view.buttonProperties.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TemplatePreferencePage.this.showPropertiesDialog();
            }
        });
        this.view.buttonUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TemplatePreferencePage.this.moveItem(((TemplatePreferencePage)TemplatePreferencePage.this).view.templateTree.getSelection()[0], true);
            }
        });
        this.view.buttonDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TemplatePreferencePage.this.moveItem(((TemplatePreferencePage)TemplatePreferencePage.this).view.templateTree.getSelection()[0], false);
            }
        });
        this.view.templateTree.addListener(17, (Listener)new ExpandListener());
        this.view.templateTree.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TreeItem[] selection = ((TemplatePreferencePage)TemplatePreferencePage.this).view.templateTree.getSelection();
                TreeItem selectedItem = selection.length > 0 ? selection[0] : null;
                TemplatePreferencePage.this.showItemData(selectedItem);
                TemplatePreferencePage.this.updateButtons(selectedItem);
            }
        });
        this.initializeTemplateTree();
        return this.view;
    }

    private void configureTemplateViewer() {
        ITextHover textHover = JAutodocPlugin.getContext().getTemplateTextHover(this.properties);
        IRulesStrategy[] ruleStrategies = JAutodocPlugin.getContext().getTemplateRuleStrategies();
        TemplateViewerConfiguration configuration = new TemplateViewerConfiguration((ITokenScanner)new TemplateCodeScanner(ruleStrategies), textHover);
        this.view.templateViewer.configure(configuration);
    }

    private void showPopupMenu(int x, int y) {
        Menu menu = this.createPopupMenu();
        menu.setLocation(x, y);
        menu.setVisible(true);
        while (!menu.isDisposed() && menu.isVisible()) {
            if (this.view.getDisplay().readAndDispatch()) continue;
            this.view.getDisplay().sleep();
        }
        menu.dispose();
    }

    private Menu createPopupMenu() {
        Menu menu = null;
        if (this.view.templateTree.getSelectionCount() > 0) {
            TreeItem selectedItem = this.view.templateTree.getSelection()[0];
            if (selectedItem.getParentItem() == null) {
                menu = this.createRootItemsMenu();
            } else {
                TemplateEntry entry;
                boolean showNestedOnly = false;
                Object data = selectedItem.getData();
                if (!(data instanceof TemplateEntry)) {
                    showNestedOnly = true;
                    selectedItem = selectedItem.getParentItem();
                    data = selectedItem.getData();
                }
                if ((entry = (TemplateEntry)data).getKind() == 1) {
                    menu = this.createTypeMenu(selectedItem, showNestedOnly);
                } else if (entry.getKind() == 2) {
                    menu = this.createFieldMenu(selectedItem);
                } else if (entry.getKind() == 3) {
                    menu = this.createMethodMenu(selectedItem, showNestedOnly);
                } else if (entry.getKind() == 4) {
                    menu = this.createParameterMenu(selectedItem);
                } else if (entry.getKind() == 5) {
                    menu = this.createExceptionMenu(selectedItem);
                }
            }
        }
        return menu != null ? menu : this.createRootItemsMenu();
    }

    private Menu createRootItemsMenu() {
        Menu menu = new Menu((Decorations)this.view.getShell(), 8);
        MenuItem item = new MenuItem(menu, 8);
        item.setText(Constants.TEMPLATES_MENU_LABEL_TYPES);
        item.addListener(13, (Listener)new NewTemplateListener(this.typeRoot, 1));
        item = new MenuItem(menu, 8);
        item.setText(Constants.TEMPLATES_MENU_LABEL_FIELDS);
        item.addListener(13, (Listener)new NewTemplateListener(this.fieldRoot, 2));
        item = new MenuItem(menu, 8);
        item.setText(Constants.TEMPLATES_MENU_LABEL_METHODS);
        item.addListener(13, (Listener)new NewTemplateListener(this.methodRoot, 3));
        item = new MenuItem(menu, 8);
        item.setText(Constants.TEMPLATES_MENU_LABEL_PARAMETERS);
        item.addListener(13, (Listener)new NewTemplateListener(this.parameterRoot, 4));
        item = new MenuItem(menu, 8);
        item.setText(Constants.TEMPLATES_MENU_LABEL_EXCEPTIONS);
        item.addListener(13, (Listener)new NewTemplateListener(this.exceptionRoot, 5));
        return menu;
    }

    private Menu createTypeMenu(TreeItem selectedItem, boolean showNestedOnly) {
        Menu menu = new Menu((Decorations)this.view.getShell(), 8);
        MenuItem item = null;
        if (!showNestedOnly) {
            item = new MenuItem(menu, 8);
            item.setText(Constants.TEMPLATES_MENU_LABEL_TYPES);
            item.addListener(13, (Listener)new NewTemplateListener(selectedItem.getParentItem(), 1));
        }
        String nestedLabel = showNestedOnly ? "" : String.valueOf(Constants.TEMPLATES_MENU_LABEL_NESTED) + " ";
        item = new MenuItem(menu, 8);
        item.setText(String.valueOf(nestedLabel) + Constants.TEMPLATES_MENU_LABEL_TYPES);
        item.addListener(13, (Listener)new NewTemplateListener(selectedItem, 1));
        item = new MenuItem(menu, 8);
        item.setText(String.valueOf(nestedLabel) + Constants.TEMPLATES_MENU_LABEL_FIELDS);
        item.addListener(13, (Listener)new NewTemplateListener(selectedItem, 2));
        item = new MenuItem(menu, 8);
        item.setText(String.valueOf(nestedLabel) + Constants.TEMPLATES_MENU_LABEL_METHODS);
        item.addListener(13, (Listener)new NewTemplateListener(selectedItem, 3));
        return menu;
    }

    private Menu createFieldMenu(TreeItem selectedItem) {
        Menu menu = new Menu((Decorations)this.view.getShell(), 8);
        MenuItem item = new MenuItem(menu, 8);
        item.setText(Constants.TEMPLATES_MENU_LABEL_FIELDS);
        item.addListener(13, (Listener)new NewTemplateListener(selectedItem.getParentItem(), 2));
        return menu;
    }

    private Menu createMethodMenu(TreeItem selectedItem, boolean showNestedOnly) {
        Menu menu = new Menu((Decorations)this.view.getShell(), 8);
        MenuItem item = null;
        if (!showNestedOnly) {
            item = new MenuItem(menu, 8);
            item.setText(Constants.TEMPLATES_MENU_LABEL_METHODS);
            item.addListener(13, (Listener)new NewTemplateListener(selectedItem.getParentItem(), 3));
        }
        String nestedLabel = showNestedOnly ? "" : String.valueOf(Constants.TEMPLATES_MENU_LABEL_NESTED) + " ";
        item = new MenuItem(menu, 8);
        item.setText(String.valueOf(nestedLabel) + Constants.TEMPLATES_MENU_LABEL_PARAMETERS);
        item.addListener(13, (Listener)new NewTemplateListener(selectedItem, 4));
        item = new MenuItem(menu, 8);
        item.setText(String.valueOf(nestedLabel) + Constants.TEMPLATES_MENU_LABEL_EXCEPTIONS);
        item.addListener(13, (Listener)new NewTemplateListener(selectedItem, 5));
        return menu;
    }

    private Menu createParameterMenu(TreeItem selectedItem) {
        Menu menu = new Menu((Decorations)this.view.getShell(), 8);
        MenuItem item = new MenuItem(menu, 8);
        item.setText(Constants.TEMPLATES_MENU_LABEL_PARAMETERS);
        item.addListener(13, (Listener)new NewTemplateListener(selectedItem.getParentItem(), 4));
        return menu;
    }

    private Menu createExceptionMenu(TreeItem selectedItem) {
        Menu menu = new Menu((Decorations)this.view.getShell(), 8);
        MenuItem item = new MenuItem(menu, 8);
        item.setText(Constants.TEMPLATES_MENU_LABEL_EXCEPTIONS);
        item.addListener(13, (Listener)new NewTemplateListener(selectedItem.getParentItem(), 5));
        return menu;
    }

    private int showEditTemplateDialog(TemplateEntry entry) {
        EditTemplateDialog templateDialog = new EditTemplateDialog(this.view.getShell(), entry, this.properties);
        return templateDialog.open();
    }

    private void initializeTemplateTree() {
        try {
            this.typeRoot = TemplatePreferencePage.addRootItem(this.view.templateTree, Constants.TEMPLATES_LABEL_TYPES, this.templateManager.getTypeTemplates());
            this.fieldRoot = TemplatePreferencePage.addRootItem(this.view.templateTree, Constants.TEMPLATES_LABEL_FIELDS, this.templateManager.getFieldTemplates());
            this.methodRoot = TemplatePreferencePage.addRootItem(this.view.templateTree, Constants.TEMPLATES_LABEL_METHODS, this.templateManager.getMethodTemplates());
            this.parameterRoot = TemplatePreferencePage.addRootItem(this.view.templateTree, Constants.TEMPLATES_LABEL_PARAMETERS, this.templateManager.getParameterTemplates());
            this.exceptionRoot = TemplatePreferencePage.addRootItem(this.view.templateTree, Constants.TEMPLATES_LABEL_EXCEPTIONS, this.templateManager.getExceptionTemplates());
        }
        catch (Exception e) {
            JAutodocPlugin.getDefault().handleException(this.view.getShell(), (Throwable)e);
        }
        this.showItemData(null);
        this.updateButtons(null);
    }

    private void showItemData(TreeItem item) {
        Object data;
        Object object = data = item == null ? null : item.getData();
        if (data == null || !(data instanceof TemplateEntry)) {
            this.view.textPattern.setText("");
            this.view.textExample.setText("");
            this.view.templateViewer.setDocument((IDocument)new Document());
        } else {
            TemplateEntry entry = (TemplateEntry)data;
            this.view.textPattern.setText(entry.getRegex());
            this.view.textExample.setText(entry.getExample());
            this.view.templateViewer.setDocument((IDocument)new Document(entry.getText()));
        }
    }

    private void updateButtons(TreeItem item) {
        if (item == null || !(item.getData() instanceof TemplateEntry)) {
            this.view.buttonUp.setEnabled(false);
            this.view.buttonDown.setEnabled(false);
            this.view.buttonEdit.setEnabled(false);
            this.view.buttonRemove.setEnabled(false);
            return;
        }
        TemplateEntry entry = (TemplateEntry)item.getData();
        if (entry.isDefaultTemplate()) {
            this.view.buttonUp.setEnabled(false);
            this.view.buttonDown.setEnabled(false);
            this.view.buttonEdit.setEnabled(true);
            this.view.buttonRemove.setEnabled(false);
            return;
        }
        TreeItem parent = item.getParentItem();
        int index = parent.indexOf(item);
        this.view.buttonUp.setEnabled(index > 0);
        this.view.buttonDown.setEnabled(index < parent.getItemCount() - 1 && !this.getEntryFromItem(parent, index + 1).isDefaultTemplate());
        this.view.buttonEdit.setEnabled(true);
        this.view.buttonRemove.setEnabled(true);
    }

    private TemplateEntry getEntryFromItem(TreeItem parent, int index) {
        TreeItem item = parent.getItem(index);
        return (TemplateEntry)item.getData();
    }

    private void moveItem(TreeItem item, boolean up) {
        this.view.templateTree.setRedraw(false);
        String itemText = item.getText();
        TemplateEntry entry = (TemplateEntry)item.getData();
        TreeItem parent = item.getParentItem();
        int oldIndex = parent.indexOf(item);
        int newIndex = up ? parent.indexOf(item) - 1 : parent.indexOf(item) + 1;
        item.dispose();
        TreeItem newItem = new TreeItem(parent, 0, newIndex);
        newItem.setText(itemText);
        newItem.setData((Object)entry);
        if (!entry.getChildTemplates().isEmpty()) {
            new TreeItem(newItem, 0);
        }
        List<TemplateEntry> list = TemplatePreferencePage.asTemplateList(parent.getData());
        list.remove(oldIndex);
        list.add(newIndex, entry);
        this.view.templateTree.setRedraw(true);
        this.view.templateTree.setSelection(new TreeItem[]{newItem});
        this.view.templateTree.showSelection();
        this.view.templateTree.setFocus();
    }

    private static void addItem(TreeItem parent, String name, List<TemplateEntry> templateList) {
        if (!templateList.isEmpty()) {
            TreeItem item = new TreeItem(parent, 0);
            item.setText(name);
            item.setData(templateList);
            new TreeItem(item, 0);
        }
    }

    private static TreeItem addRootItem(Tree tree, String name, List<TemplateEntry> templateList) {
        TreeItem item = new TreeItem(tree, 0);
        item.setText(name);
        item.setData(templateList);
        if (!templateList.isEmpty()) {
            new TreeItem(item, 0);
        }
        return item;
    }

    private static void ensureChildItems(TreeItem parent) {
        Object data;
        TreeItem[] items = parent.getItems();
        if (items.length > 0) {
            if (items[0].getData() != null) {
                return;
            }
            items[0].dispose();
        }
        if ((data = parent.getData()) instanceof TemplateEntry) {
            TemplateEntry entry = (TemplateEntry)data;
            TemplatePreferencePage.addItem(parent, Constants.TEMPLATES_LABEL_TYPES, entry.getChildTemplates().getTypeTemplates());
            TemplatePreferencePage.addItem(parent, Constants.TEMPLATES_LABEL_FIELDS, entry.getChildTemplates().getFieldTemplates());
            TemplatePreferencePage.addItem(parent, Constants.TEMPLATES_LABEL_METHODS, entry.getChildTemplates().getMethodTemplates());
            TemplatePreferencePage.addItem(parent, Constants.TEMPLATES_LABEL_PARAMETERS, entry.getChildTemplates().getParameterTemplates());
            TemplatePreferencePage.addItem(parent, Constants.TEMPLATES_LABEL_EXCEPTIONS, entry.getChildTemplates().getExceptionTemplates());
        } else if (data instanceof List) {
            List<TemplateEntry> templates = TemplatePreferencePage.asTemplateList(data);
            int i = 0;
            while (i < templates.size()) {
                TreeItem item = new TreeItem(parent, 0);
                TemplateEntry entry = templates.get(i);
                item.setText(StringUtils.getLastElement(entry.getName(), '.'));
                item.setData((Object)entry);
                if (!entry.getChildTemplates().isEmpty()) {
                    new TreeItem(item, 0);
                }
                ++i;
            }
        }
    }

    private static String getLabel(int templateKind) {
        String label = "";
        switch (templateKind) {
            case 1: {
                label = Constants.TEMPLATES_LABEL_TYPES;
                break;
            }
            case 2: {
                label = Constants.TEMPLATES_LABEL_FIELDS;
                break;
            }
            case 3: {
                label = Constants.TEMPLATES_LABEL_METHODS;
                break;
            }
            case 4: {
                label = Constants.TEMPLATES_LABEL_PARAMETERS;
                break;
            }
            case 5: {
                label = Constants.TEMPLATES_LABEL_EXCEPTIONS;
            }
        }
        return label;
    }

    private static TreeItem findChildItem(TreeItem parent, String label) {
        TreeItem childItem = null;
        TreeItem[] childs = parent.getItems();
        int i = 0;
        while (i < childs.length && childItem == null) {
            if (label.equals(childs[i].getText())) {
                childItem = childs[i];
            }
            ++i;
        }
        return childItem;
    }

    private void importTemplates() {
        FileDialog fileDialog = new FileDialog(this.getShell(), 4096);
        fileDialog.setText("Import templates");
        fileDialog.setFilterExtensions(new String[]{"*.xml", "*.*"});
        String selectedFile = fileDialog.open();
        if (selectedFile == null) {
            return;
        }
        try {
            this.templateManager.loadTemplates(new File(selectedFile));
            this.view.templateTree.removeAll();
            this.initializeTemplateTree();
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)("Could not read file: " + e.getMessage()));
        }
    }

    private void exportTemplates() {
        FileDialog fileDialog = new FileDialog(this.getShell(), 8192);
        fileDialog.setText("Export templates");
        fileDialog.setFileName("jautodoc_templates.xml");
        fileDialog.setFilterExtensions(new String[]{"*.xml", "*.*"});
        String selectedFile = fileDialog.open();
        if (selectedFile == null) {
            return;
        }
        File file = new File(selectedFile);
        if (file.exists() && !MessageDialog.openQuestion((Shell)this.getShell(), (String)"File exists", (String)("File '" + file.getName() + "' already exists. Replace?"))) {
            return;
        }
        try {
            this.templateManager.storeTemplates(file);
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)("Could not write file: " + e.getMessage()));
        }
    }

    private void showPropertiesDialog() {
        HashMap<String, String> props = new HashMap<String, String>(this.properties);
        EditPropertiesDialog dialog = new EditPropertiesDialog(this.getShell(), props);
        if (dialog.open() == 0) {
            this.properties.clear();
            this.properties.putAll(props);
        }
    }

    public boolean performCancel() {
        try {
            this.templateManager.loadTemplates();
            if (this.view != null) {
                this.view.templateTree.removeAll();
                this.initializeTemplateTree();
            }
            return true;
        }
        catch (Exception e) {
            JAutodocPlugin.getDefault().handleException(this.view.getShell(), (Throwable)e);
            return false;
        }
    }

    protected void performDefaults() {
        try {
            this.templateManager.loadDefaultTemplates();
            if (this.view != null) {
                this.view.templateTree.removeAll();
                this.initializeTemplateTree();
            }
        }
        catch (Exception e) {
            JAutodocPlugin.getDefault().handleException(this.view.getShell(), (Throwable)e);
        }
    }

    public boolean performOk() {
        try {
            this.templateManager.storeTemplates();
            ((PreferenceStore)this.getPreferenceStore()).setProperties(this.properties);
            return true;
        }
        catch (Exception e) {
            JAutodocPlugin.getDefault().handleException(this.view.getShell(), (Throwable)e);
            return false;
        }
    }

    public IPreferenceStore getPreferenceStore() {
        return ConfigurationManager.getPreferenceStore();
    }

    private static List<TemplateEntry> asTemplateList(Object data) {
        return (List)data;
    }

    private static class ExpandListener
    implements Listener {
        private ExpandListener() {
        }

        public void handleEvent(Event event) {
            TreeItem root = (TreeItem)event.item;
            TemplatePreferencePage.ensureChildItems(root);
        }
    }

    private class NewTemplateListener
    implements Listener {
        private TreeItem parentItem;
        private int templateKind = 0;

        public NewTemplateListener(TreeItem parentItem, int templateKind) {
            this.parentItem = parentItem;
            this.templateKind = templateKind;
        }

        public void handleEvent(Event event) {
            TemplatePreferencePage.ensureChildItems(this.parentItem);
            TemplateEntry parentEntry = null;
            Object data = this.parentItem.getData();
            if (data instanceof TemplateEntry) {
                parentEntry = (TemplateEntry)data;
            } else {
                TreeItem parentParentItem = this.parentItem.getParentItem();
                if (parentParentItem != null) {
                    parentEntry = (TemplateEntry)parentParentItem.getData();
                }
            }
            TemplateEntry entry = new TemplateEntry(parentEntry, this.templateKind);
            if (TemplatePreferencePage.this.showEditTemplateDialog(entry) != 0) {
                return;
            }
            if (data instanceof TemplateEntry) {
                String label = TemplatePreferencePage.getLabel(this.templateKind);
                TreeItem newParentItem = TemplatePreferencePage.findChildItem(this.parentItem, label);
                if (newParentItem == null) {
                    newParentItem = new TreeItem(this.parentItem, 0);
                    newParentItem.setText(label);
                    newParentItem.setData(parentEntry.getChildTemplates(this.templateKind));
                } else {
                    TemplatePreferencePage.ensureChildItems(newParentItem);
                }
                this.parentItem = newParentItem;
            }
            int index = 0;
            if (((TemplatePreferencePage)TemplatePreferencePage.this).view.templateTree.getSelectionCount() > 0 && ((TemplatePreferencePage)TemplatePreferencePage.this).view.templateTree.getSelection()[0] != this.parentItem) {
                index = this.parentItem.indexOf(((TemplatePreferencePage)TemplatePreferencePage.this).view.templateTree.getSelection()[0]);
                index = index < 0 ? 0 : index;
            }
            TemplatePreferencePage.asTemplateList(this.parentItem.getData()).add(index, entry);
            TreeItem item = new TreeItem(this.parentItem, 0, index);
            item.setText(StringUtils.getLastElement(entry.getName(), '.'));
            item.setData((Object)entry);
            ((TemplatePreferencePage)TemplatePreferencePage.this).view.templateTree.setSelection(new TreeItem[]{item});
            ((TemplatePreferencePage)TemplatePreferencePage.this).view.templateTree.setFocus();
            TemplatePreferencePage.this.showItemData(item);
            TemplatePreferencePage.this.updateButtons(item);
        }
    }
}

