/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.preferences.templates;

import java.util.Map;
import net.sf.jautodoc.JAutodocPlugin;
import net.sf.jautodoc.preferences.Constants;
import net.sf.jautodoc.preferences.templates.AbstractEditTextDialog;
import net.sf.jautodoc.templates.contentassist.ITemplateContentAssistant;
import net.sf.jautodoc.utils.Utils;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.swt.widgets.Shell;

public class EditHeaderDialog
extends AbstractEditTextDialog
implements Constants {
    public EditHeaderDialog(Shell parentShell, String headerText, Map<String, String> properties) {
        super(parentShell, headerText, properties);
    }

    @Override
    protected boolean validateEvaluatedText(String evaluatedText) {
        IScanner commentScanner = ToolFactory.createScanner((boolean)true, (boolean)false, (boolean)false, (boolean)false);
        commentScanner.setSource(evaluatedText.toCharArray());
        try {
            int token = commentScanner.getNextToken();
            while (Utils.isComment(token)) {
                token = commentScanner.getNextToken();
            }
            if (token == 158) {
                return true;
            }
        }
        catch (InvalidInputException invalidInputException) {}
        this.setError(HEADER_ERROR_MSG);
        return false;
    }

    @Override
    protected ITemplateContentAssistant[] getTemplateContentAssistants() {
        return JAutodocPlugin.getContext().getHeaderTemplateContentAssistants(this.properties);
    }

    @Override
    protected String getTitle() {
        return HEADER_TITLE;
    }

    @Override
    protected String getHint() {
        return HEADER_HINT;
    }

    @Override
    protected String getExportFileName() {
        return "jautodoc_header.txt";
    }

    @Override
    protected String[] getFilterExtensions() {
        return new String[]{"*.txt", "*.*"};
    }

    @Override
    protected int getLineOffset() {
        return 1;
    }
}

