/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.preferences.replacements;

import com.megginson.sax.DataWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.SAXParserFactory;
import net.sf.jautodoc.JAutodocPlugin;
import net.sf.jautodoc.preferences.replacements.Replacement;
import net.sf.jautodoc.utils.Utils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class ReplacementSerializer {
    private static final String ROOT = "replacements";
    private static final String ENTRY = "replacement";
    private static final String KEY = "key";
    private static final String SCOPE = "scope";
    private static final String MODE = "mode";
    private static boolean format = false;

    public static void serialize(Replacement[] replacements, File file) throws Exception {
        FileWriter fw = new FileWriter(file);
        format = true;
        try {
            ReplacementSerializer.serialize(replacements, fw);
        }
        finally {
            Utils.close(fw);
        }
    }

    public static String serialize(Replacement[] replacements) {
        StringWriter sw = new StringWriter();
        format = false;
        try {
            ReplacementSerializer.serialize(replacements, sw);
        }
        catch (Exception e) {
            JAutodocPlugin.getDefault().handleException(e);
        }
        return sw.toString();
    }

    private static void serialize(Replacement[] replacements, Writer w) throws Exception {
        DataWriter writer = new DataWriter(w);
        writer.startDocument();
        writer.startElement(ROOT);
        ReplacementSerializer.writeReplacements(writer, replacements);
        writer.endElement(ROOT);
        writer.endDocument();
    }

    private static void writeReplacements(DataWriter writer, Replacement[] replacements) throws Exception {
        int i = 0;
        while (i < replacements.length) {
            ReplacementSerializer.writeReplacement(writer, replacements[i]);
            ++i;
        }
    }

    private static void writeReplacement(DataWriter writer, Replacement entry) throws Exception {
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute("", KEY, "", "", entry.getShortcut());
        attributes.addAttribute("", SCOPE, "", "", Integer.toString(entry.getScope()));
        attributes.addAttribute("", MODE, "", "", Integer.toString(entry.getMode()));
        if (format) {
            writer.setIndentStep(writer.getIndentStep() + 2);
        }
        writer.startElement("", ENTRY, "", (Attributes)attributes);
        writer.characters(entry.getReplacement());
        writer.endElement(ENTRY);
        if (format) {
            writer.setIndentStep(writer.getIndentStep() - 2);
        }
    }

    public static Replacement[] deserialize(File file) throws Exception {
        FileInputStream fis = new FileInputStream(file);
        try {
            Replacement[] replacementArray = ReplacementSerializer.deserialize(fis);
            return replacementArray;
        }
        finally {
            Utils.close(fis);
        }
    }

    public static Replacement[] deserialize(String s) {
        Replacement[] r = null;
        try {
            r = ReplacementSerializer.deserialize(new ByteArrayInputStream(s.getBytes()));
        }
        catch (Exception e) {
            JAutodocPlugin.getDefault().handleException(e);
        }
        return r != null ? r : new Replacement[]{};
    }

    private static Replacement[] deserialize(InputStream is) throws Exception {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(false);
        XMLReader parser = factory.newSAXParser().getXMLReader();
        ContentHandler handler = new ContentHandler();
        parser.setContentHandler(handler);
        parser.setErrorHandler(handler);
        parser.parse(new InputSource(is));
        return handler.getReplacements();
    }

    private static class ContentHandler
    extends DefaultHandler {
        private StringBuffer buffer;
        private List<Replacement> replacements;
        private Replacement currentEntry;

        private ContentHandler() {
        }

        public Replacement[] getReplacements() {
            return this.replacements.toArray(new Replacement[this.replacements.size()]);
        }

        @Override
        public void startDocument() throws SAXException {
            this.replacements = new ArrayList<Replacement>();
            this.currentEntry = null;
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (ReplacementSerializer.ENTRY.equals(qName)) {
                this.currentEntry = new Replacement();
                this.currentEntry.setShortcut(attributes.getValue(ReplacementSerializer.KEY));
                this.currentEntry.setScope(Integer.parseInt(attributes.getValue(ReplacementSerializer.SCOPE)));
                this.currentEntry.setMode(Integer.parseInt(attributes.getValue(ReplacementSerializer.MODE)));
            }
            this.buffer = new StringBuffer();
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.buffer != null) {
                this.buffer.append(ch, start, length);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (ReplacementSerializer.ENTRY.equals(qName)) {
                this.currentEntry.setReplacement(this.buffer.toString());
                this.replacements.add(this.currentEntry);
            }
            this.buffer = null;
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            JAutodocPlugin.getDefault().handleException(e);
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            JAutodocPlugin.getDefault().handleException(e);
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            JAutodocPlugin.getDefault().handleException(e);
        }
    }
}

