/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.preferences.replacements;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlValue;
import net.sf.jautodoc.preferences.Constants;
import net.sf.jautodoc.preferences.ITableEntry;

public class Replacement
implements ITableEntry,
Comparable<Replacement> {
    public static final int SCOPE_METHOD = 1;
    public static final int SCOPE_FIELD = 2;
    public static final int SCOPE_BOTH = 3;
    public static final int MODE_PREFIX = 0;
    public static final int MODE_ALL = 1;
    private String shortcut;
    private String replacement;
    private int scope;
    private int mode;

    public Replacement() {
        this("", "", 1, 0);
    }

    public Replacement(String shortcut, String replacement) {
        this(shortcut, replacement, 1, 0);
    }

    public Replacement(String shortcut, String replacement, int scope) {
        this(shortcut, replacement, scope, 0);
    }

    public Replacement(String shortcut, String replacement, int scope, int mode) {
        this.shortcut = shortcut;
        this.replacement = replacement;
        this.scope = scope;
        this.mode = mode;
    }

    @XmlAttribute
    public String getShortcut() {
        return this.shortcut;
    }

    public void setShortcut(String prefix) {
        this.shortcut = prefix;
    }

    @XmlValue
    public String getReplacement() {
        return this.replacement;
    }

    public void setReplacement(String replacement) {
        this.replacement = replacement;
    }

    @XmlAttribute
    public int getScope() {
        return this.scope;
    }

    public void setScope(int scope) {
        this.scope = scope;
    }

    @XmlAttribute
    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public boolean isFieldReplacement() {
        return (this.scope & 2) != 0;
    }

    public boolean isMethodReplacement() {
        return (this.scope & 1) != 0;
    }

    public String getScopeLabel() {
        if (this.isFieldReplacement() && this.isMethodReplacement()) {
            return Constants.COLUMN_SCOPE_BOTH;
        }
        return this.isFieldReplacement() ? Constants.COLUMN_SCOPE_FIELD : Constants.COLUMN_SCOPE_METHOD;
    }

    public String getModeLabel() {
        return this.mode == 1 ? Constants.COLUMN_MODE_ALL : Constants.COLUMN_MODE_PREFIX;
    }

    @Override
    public String getColumnText(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.getShortcut();
            }
            case 1: {
                return this.getReplacement();
            }
            case 2: {
                return this.getScopeLabel();
            }
            case 3: {
                return this.getModeLabel();
            }
        }
        return null;
    }

    @Override
    public int compareTo(Replacement other) {
        int result = this.getShortcut().compareTo(other.getShortcut());
        if (result == 0) {
            result = this.getScope() - other.getScope();
        }
        return result;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Replacement)) {
            return false;
        }
        Replacement other = (Replacement)o;
        return this.getScope() == other.getScope() && this.getShortcut().equalsIgnoreCase(other.getShortcut());
    }

    public int hashCode() {
        return this.getShortcut().hashCode();
    }

    public String toString() {
        return String.valueOf(this.getShortcut()) + " -> " + this.getReplacement() + " (" + this.getScopeLabel() + ", " + this.getModeLabel() + ")";
    }
}

