/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.preferences;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class TagOrderDialog
extends Dialog {
    private final List<String> tagOrder;
    private Button addButton;
    private Button removeButton;
    private Button upButton;
    private Button downButton;
    private ListViewer listViewer;

    public TagOrderDialog(Shell parentShell, List<String> tagOrder) {
        super(parentShell);
        this.tagOrder = tagOrder;
    }

    public List<String> getTagOrder() {
        return this.tagOrder;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Edit Tag Order");
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(340, 220));
        composite.setLayout((Layout)new GridLayout(2, false));
        this.createListViewerPanel(composite);
        this.createButtonPanel(composite);
        this.updateEnablement();
        this.addSelectionListener();
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1024, "Restore Defaults", false);
        super.createButtonsForButtonBar(parent);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1024) {
            this.tagOrder.clear();
            this.tagOrder.addAll(Arrays.asList("@author,@version,@param,@return,@throws,@see,@since,@serial,@serialField,@serialData,@deprecated".split(",")));
            this.listViewer.setInput(this.tagOrder);
        } else {
            super.buttonPressed(buttonId);
        }
    }

    private void createListViewerPanel(Composite parent) {
        this.listViewer = new ListViewer(parent, 2560);
        this.listViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.listViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.listViewer.setInput(this.tagOrder);
    }

    private void createButtonPanel(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1040));
        this.upButton = new Button(composite, 0);
        this.upButton.setText("Up");
        this.upButton.setLayoutData((Object)new GridData(768));
        this.downButton = new Button(composite, 0);
        this.downButton.setText("Down");
        this.downButton.setLayoutData((Object)new GridData(768));
        this.addButton = new Button(composite, 0);
        this.addButton.setText("Add...");
        GridData addGridData = new GridData(768);
        addGridData.verticalIndent = 20;
        this.addButton.setLayoutData((Object)addGridData);
        this.removeButton = new Button(composite, 0);
        this.removeButton.setText("Remove");
        this.removeButton.setLayoutData((Object)new GridData(768));
    }

    private void addSelectionListener() {
        this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TagOrderDialog.this.moveUp();
            }
        });
        this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TagOrderDialog.this.moveDown();
            }
        });
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TagOrderDialog.this.addElement();
            }
        });
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TagOrderDialog.this.removeElement();
            }
        });
        this.listViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TagOrderDialog.this.updateEnablement();
            }
        });
    }

    private void moveUp() {
        int selectedIndex = this.getSelectedIndex();
        String element = this.tagOrder.remove(selectedIndex);
        this.tagOrder.add(selectedIndex - 1, element);
        this.listViewer.setInput(this.tagOrder);
        this.setSelectedIndex(selectedIndex - 1);
    }

    private void moveDown() {
        int selectedIndex = this.getSelectedIndex();
        String element = this.tagOrder.remove(selectedIndex);
        this.tagOrder.add(selectedIndex + 1, element);
        this.listViewer.setInput(this.tagOrder);
        this.setSelectedIndex(selectedIndex + 1);
    }

    private void addElement() {
        InputDialog inputDialog = new InputDialog(this.getShell(), "Add Tag", "Enter Tag name:", "", new IInputValidator(){

            public String isValid(String newText) {
                String newTag = TagOrderDialog.this.prepareTag(newText);
                return newTag.length() == 1 ? "" : (TagOrderDialog.this.tagOrder.contains(newTag) ? "Tag already exists." : null);
            }
        });
        if (inputDialog.open() == 0) {
            int selectedIndex = this.getSelectedIndex();
            this.tagOrder.add(selectedIndex + 1, this.prepareTag(inputDialog.getValue()));
            this.listViewer.setInput(this.tagOrder);
            this.setSelectedIndex(selectedIndex + 1);
        }
    }

    private void removeElement() {
        int selectedIndex = this.getSelectedIndex();
        this.tagOrder.remove(selectedIndex);
        this.listViewer.setInput(this.tagOrder);
        this.setSelectedIndex(selectedIndex < this.tagOrder.size() ? selectedIndex : selectedIndex - 1);
    }

    private String prepareTag(String newText) {
        return newText.trim().startsWith("@") ? newText.trim() : "@" + newText.trim();
    }

    private void updateEnablement() {
        int selectedIndex = this.getSelectedIndex();
        this.upButton.setEnabled(selectedIndex > 0);
        this.downButton.setEnabled(selectedIndex >= 0 && selectedIndex < this.tagOrder.size() - 1);
        this.removeButton.setEnabled(selectedIndex >= 0);
    }

    private String getSelection() {
        return this.listViewer.getSelection() == null ? null : (String)((IStructuredSelection)this.listViewer.getSelection()).getFirstElement();
    }

    private int getSelectedIndex() {
        String selection = this.getSelection();
        return selection == null ? -1 : this.tagOrder.indexOf(selection);
    }

    private void setSelection(String element) {
        this.listViewer.setSelection((ISelection)(element == null ? null : new StructuredSelection((Object)element)));
    }

    private void setSelectedIndex(int selectedIndex) {
        this.setSelection(selectedIndex >= 0 && selectedIndex < this.tagOrder.size() ? this.tagOrder.get(selectedIndex) : null);
    }
}

