/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.preferences;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import net.sf.jautodoc.preferences.replacements.Replacement;
import net.sf.jautodoc.preferences.replacements.ReplacementSerializer;
import net.sf.jautodoc.utils.StringUtils;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class PreferenceStore
extends ScopedPreferenceStore {
    private List<String> tagOrder;
    private Map<String, String> properties;

    public PreferenceStore(IScopeContext context, String qualifier, String defaultQualifierPath) {
        super(context, qualifier, defaultQualifierPath);
    }

    public PreferenceStore(IScopeContext context, String qualifier) {
        super(context, qualifier);
    }

    public Replacement[] getReplacements() {
        String name = "replacements";
        String value = super.getString(name);
        if (value != null && value.trim().startsWith("<")) {
            return ReplacementSerializer.deserialize(value);
        }
        return this.oldGetReplacements();
    }

    private Replacement[] oldGetReplacements() {
        String name = "replacements";
        String keyString = super.getString(name);
        List<String> keyList = this.getListFromString(keyString);
        Replacement[] result = new Replacement[keyList.size()];
        int i = 0;
        while (i < keyList.size()) {
            String key = keyList.get(i);
            String val = super.getString(String.valueOf(name) + "." + key);
            if (val != null) {
                int scope = key.startsWith("fields.") ? 2 : 1;
                result[i] = new Replacement(StringUtils.getLastElement(key, '.'), val, scope);
            }
            ++i;
        }
        return result;
    }

    public void setReplacements(Replacement[] prs) {
        String name = "replacements";
        String value = ReplacementSerializer.serialize(prs);
        super.setValue(name, value);
    }

    public Replacement[] getDefaultReplacements() {
        String name = "replacements";
        String keyString = super.getDefaultString(name);
        List<String> keyList = this.getListFromString(keyString);
        Replacement[] result = new Replacement[keyList.size()];
        int i = 0;
        while (i < keyList.size()) {
            String key = String.valueOf(name) + "." + keyList.get(i);
            String val = super.getDefaultString(key);
            if (val != null) {
                int scope = key.startsWith("fields.") ? 2 : 1;
                result[i] = new Replacement(StringUtils.getLastElement(key, '.'), val, scope);
            }
            ++i;
        }
        return result;
    }

    public void setDefaultReplacements(Replacement[] prs) {
        String name = "replacements";
        StringBuffer keyString = new StringBuffer();
        int i = 0;
        while (i < prs.length) {
            Replacement pr = prs[i];
            if (pr.getScope() == 2) {
                keyString.append("fields.");
            }
            keyString.append(pr.getShortcut());
            keyString.append(",");
            String key = pr.getScope() == 2 ? String.valueOf(name) + "." + "fields" : name;
            super.setDefault(String.valueOf(key) + "." + pr.getShortcut(), pr.getReplacement());
            ++i;
        }
        super.setDefault(name, keyString.toString());
    }

    public List<String> getTagOrder() {
        if (this.tagOrder == null) {
            this.tagOrder = new ArrayList<String>(Arrays.asList(super.getString("tag_order").split(",")));
        }
        return Collections.unmodifiableList(this.tagOrder);
    }

    public void setTagOrder(List<String> newTagOrder) {
        this.tagOrder.clear();
        this.tagOrder.addAll(newTagOrder);
        StringBuilder tagOrderString = new StringBuilder();
        for (String tag : this.tagOrder) {
            if (tagOrderString.length() > 0) {
                tagOrderString.append(',');
            }
            tagOrderString.append(tag);
        }
        super.setValue("tag_order", tagOrderString.toString());
    }

    public Map<String, String> getProperties() {
        if (this.properties != null) {
            return Collections.unmodifiableMap(this.properties);
        }
        String keyString = super.getString("properties");
        List<String> keyList = this.getListFromString(keyString);
        this.properties = new HashMap<String, String>();
        int i = 0;
        while (i < keyList.size()) {
            String key = keyList.get(i);
            String val = super.getString("properties." + key);
            if (val != null) {
                this.properties.put(key, val);
            }
            ++i;
        }
        return Collections.unmodifiableMap(this.properties);
    }

    public void setProperties(Map<String, String> newProperties) {
        this.properties.clear();
        this.properties.putAll(newProperties);
        StringBuilder keyString = new StringBuilder();
        for (String name : newProperties.keySet()) {
            keyString.append(name);
            keyString.append(",");
            super.setValue("properties." + name, newProperties.get(name));
        }
        super.setValue("properties", keyString.toString());
    }

    private List<String> getListFromString(String stringList) {
        ArrayList<String> result = new ArrayList<String>();
        if (stringList == null || stringList.trim().equals("")) {
            return result;
        }
        StringTokenizer tokens = new StringTokenizer(stringList, ",");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.equals("")) continue;
            result.add(token);
        }
        return result;
    }
}

