/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.preferences;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.sf.jautodoc.JAutodocPlugin;
import net.sf.jautodoc.preferences.Configuration;
import net.sf.jautodoc.preferences.OptionsBlock;
import net.sf.jautodoc.preferences.OverallConfiguration;
import net.sf.jautodoc.preferences.PreferenceType;
import net.sf.jautodoc.preferences.replacements.Replacement;
import net.sf.jautodoc.preferences.replacements.ReplacementBlock;
import net.sf.jautodoc.utils.JAXBSerializer;
import net.sf.jautodoc.utils.StringUtils;

public final class PreferenceSerializer {
    private PreferenceSerializer() {
    }

    public static void doImport(OptionsBlock ob, ReplacementBlock rb, List<PreferenceType> selectedPreferenceTypes, String fileName) throws Exception {
        OverallConfiguration oc = JAXBSerializer.doImport(fileName, OverallConfiguration.class);
        PreferenceSerializer.fromConfiguration(oc, ob, rb, selectedPreferenceTypes);
    }

    public static void doExport(OptionsBlock ob, ReplacementBlock rb, List<PreferenceType> selectedPreferenceTypes, String fileName) throws Exception {
        OverallConfiguration oc = PreferenceSerializer.toConfiguration(ob, rb, selectedPreferenceTypes);
        JAXBSerializer.doExport(fileName, oc);
    }

    private static OverallConfiguration toConfiguration(OptionsBlock ob, ReplacementBlock rb, List<PreferenceType> selectedPreferenceTypes) throws Exception {
        OverallConfiguration oc = new OverallConfiguration();
        if (selectedPreferenceTypes.contains((Object)PreferenceType.OPTIONS)) {
            Configuration configuration = new Configuration();
            configuration.setCompleteExistingJavadoc(ob.completeButton.getSelection());
            configuration.setKeepExistingJavadoc(ob.keepButton.getSelection());
            configuration.setReplaceExistingJavadoc(ob.replaceButton.getSelection());
            configuration.setVisibilityPublic(ob.publicButton.getSelection());
            configuration.setVisibilityProtected(ob.protectedButton.getSelection());
            configuration.setVisibilityPackage(ob.packageButton.getSelection());
            configuration.setVisibilityPrivate(ob.privateButton.getSelection());
            configuration.setCommentTypes(ob.filterTypesButton.getSelection());
            configuration.setCommentFields(ob.filterFieldsButton.getSelection());
            configuration.setCommentMethods(ob.filterMethodsButton.getSelection());
            configuration.setGetterSetterOnly(ob.filterGetterSetterButton.getSelection());
            configuration.setExcludeGetterSetter(ob.filterExcludeGetterSetterButton.getSelection());
            configuration.setAddTodoForAutodoc(ob.todoButton.getSelection());
            configuration.setCreateDummyComment(ob.dummyDocButton.getSelection());
            configuration.setSingleLineComment(ob.singleLineButton.getSelection());
            configuration.setUseEclipseFormatter(ob.useFormatterButton.getSelection());
            configuration.setGetterSetterFromField(ob.getSetFromFieldButton.getSelection());
            configuration.setIncludeSubPackages(ob.includeSubPackagesButton.getSelection());
            configuration.setGetterSetterFromFieldFirst(ob.getSetFromFieldFirstButton.getSelection());
            configuration.setGetterSetterFromFieldReplace(ob.getSetFromFieldReplaceButton.getSelection());
            configuration.setAddHeader(ob.addHeaderButton.getSelection());
            configuration.setReplaceHeader(ob.replaceHeaderButton.getSelection());
            configuration.setMultiCommentHeader(ob.multiHeaderButton.getSelection());
            configuration.setUsePackageInfo(ob.usePackageInfoButton.getSelection());
            oc.setTagOrder(ob.tagOrder);
            oc.setConfiguration(configuration);
        }
        if (selectedPreferenceTypes.contains((Object)PreferenceType.HEADERTEXT)) {
            oc.setHeaderText(ob.headerText);
        }
        if (selectedPreferenceTypes.contains((Object)PreferenceType.PACKAGEDOCTEXT)) {
            oc.setPackageDocText(ob.packageDocText);
        }
        if (selectedPreferenceTypes.contains((Object)PreferenceType.PACKAGEINFOTEXT)) {
            oc.setPackageInfoText(ob.packageInfoText);
        }
        if (selectedPreferenceTypes.contains((Object)PreferenceType.PROPERTIES)) {
            oc.setProperties(ob.properties);
        }
        if (selectedPreferenceTypes.contains((Object)PreferenceType.REPLACEMENTS)) {
            oc.setReplacements(Arrays.asList(rb.getReplacements()));
        }
        if (selectedPreferenceTypes.contains((Object)PreferenceType.TEMPLATES)) {
            oc.setTemplates(JAutodocPlugin.getContext().getTemplateManager().getTemplates());
        }
        return oc;
    }

    private static void fromConfiguration(OverallConfiguration oc, OptionsBlock ob, ReplacementBlock rb, List<PreferenceType> selectedPreferenceTypes) throws Exception {
        if (selectedPreferenceTypes.contains((Object)PreferenceType.OPTIONS) && oc.getConfiguration() != null) {
            Configuration configuration = oc.getConfiguration();
            ob.completeButton.setSelection(configuration.isCompleteExistingJavadoc());
            ob.keepButton.setSelection(configuration.isKeepExistingJavadoc());
            ob.replaceButton.setSelection(configuration.isReplaceExistingJavadoc());
            ob.publicButton.setSelection(configuration.isIncludePublic());
            ob.protectedButton.setSelection(configuration.isIncludeProtected());
            ob.packageButton.setSelection(configuration.isIncludePackage());
            ob.privateButton.setSelection(configuration.isIncludePrivate());
            ob.filterTypesButton.setSelection(configuration.isIncludeTypes());
            ob.filterFieldsButton.setSelection(configuration.isIncludeFields());
            ob.filterMethodsButton.setSelection(configuration.isIncludeMethods());
            ob.filterGetterSetterButton.setSelection(configuration.isGetterSetterOnly());
            ob.filterExcludeGetterSetterButton.setSelection(configuration.isExcludeGetterSetter());
            ob.todoButton.setSelection(configuration.isAddTodoForAutodoc());
            ob.dummyDocButton.setSelection(configuration.isCreateDummyComment());
            ob.singleLineButton.setSelection(configuration.isSingleLineComment());
            ob.useFormatterButton.setSelection(configuration.isUseEclipseFormatter());
            ob.getSetFromFieldButton.setSelection(configuration.isGetterSetterFromField());
            ob.includeSubPackagesButton.setSelection(configuration.isIncludeSubPackages());
            ob.getSetFromFieldFirstButton.setSelection(configuration.isGetterSetterFromFieldFirst());
            ob.getSetFromFieldReplaceButton.setSelection(configuration.isGetterSetterFromFieldReplace());
            ob.addHeaderButton.setSelection(configuration.isAddHeader());
            ob.replaceHeaderButton.setSelection(configuration.isReplaceHeader());
            ob.multiHeaderButton.setSelection(configuration.isMultiCommentHeader());
            ob.usePackageInfoButton.setSelection(configuration.isUsePackageInfo());
        }
        if (selectedPreferenceTypes.contains((Object)PreferenceType.OPTIONS) && oc.getTagOrder() != null && !oc.getTagOrder().isEmpty()) {
            ob.tagOrder = new ArrayList<String>(oc.getTagOrder());
        }
        if (selectedPreferenceTypes.contains((Object)PreferenceType.HEADERTEXT) && !StringUtils.isEmpty(oc.getHeaderText())) {
            ob.headerText = oc.getHeaderText();
        }
        if (selectedPreferenceTypes.contains((Object)PreferenceType.PACKAGEDOCTEXT) && !StringUtils.isEmpty(oc.getPackageDocText())) {
            ob.packageDocText = oc.getPackageDocText();
        }
        if (selectedPreferenceTypes.contains((Object)PreferenceType.PACKAGEINFOTEXT) && !StringUtils.isEmpty(oc.getPackageInfoText())) {
            ob.packageInfoText = oc.getPackageInfoText();
        }
        if (selectedPreferenceTypes.contains((Object)PreferenceType.PROPERTIES) && oc.getProperties() != null && !oc.getProperties().isEmpty()) {
            ob.properties = new HashMap<String, String>(oc.getProperties());
        }
        if (selectedPreferenceTypes.contains((Object)PreferenceType.REPLACEMENTS) && oc.getReplacements() != null && !oc.getReplacements().isEmpty()) {
            rb.setReplacements(oc.getReplacements().toArray(new Replacement[oc.getReplacements().size()]));
        }
        if (selectedPreferenceTypes.contains((Object)PreferenceType.TEMPLATES) && oc.getTemplates() != null && !oc.getTemplates().isEmpty()) {
            JAutodocPlugin.getContext().getTemplateManager().setTemplates(oc.getTemplates());
        }
    }
}

