/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.preferences;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import net.sf.jautodoc.JAutodocPlugin;
import net.sf.jautodoc.preferences.ConfigurationManager;
import net.sf.jautodoc.preferences.Constants;
import net.sf.jautodoc.preferences.ImportExportDialog;
import net.sf.jautodoc.preferences.OptionsBlock;
import net.sf.jautodoc.preferences.PreferenceSerializer;
import net.sf.jautodoc.preferences.PreferenceStore;
import net.sf.jautodoc.preferences.PreferenceType;
import net.sf.jautodoc.preferences.replacements.ReplacementBlock;
import net.sf.jautodoc.preferences.templates.TemplatePreferencePage;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.preferences.ProjectSelectionDialog;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class MainPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage,
Constants {
    private PreferenceManager preferenceManager;
    private IProject project;
    private Link scopeLink;
    private Button projectSettingsButton;
    private Composite basePanel;
    private ControlEnableState enableState;
    private ControlEnableState btnEnableState;
    private OptionsBlock ob;
    private ReplacementBlock rb;
    private Composite buttonBar;
    private boolean enableScopeLink = true;

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.updateControls();
    }

    protected Control createContents(Composite parent) {
        this.basePanel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.basePanel.setLayout((Layout)layout);
        this.ob = new OptionsBlock();
        this.ob.createContents(this.basePanel);
        this.rb = new ReplacementBlock();
        this.rb.createContents(this.basePanel);
        Dialog.applyDialogFont((Control)this.basePanel);
        return this.basePanel;
    }

    protected Label createDescriptionLabel(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.projectSettingsButton = new Button(composite, 32);
        this.projectSettingsButton.setText(LABEL_PROJECT_SETTINGS);
        this.projectSettingsButton.setLayoutData((Object)new GridData(768));
        this.projectSettingsButton.setVisible(this.isProjectPropertyPage());
        this.projectSettingsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainPreferencePage.this.updateControlStates();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                MainPreferencePage.this.updateControlStates();
            }
        });
        this.createScopeLink(composite);
        if (this.isProjectPropertyPage()) {
            Label horizontalLine = new Label(composite, 258);
            horizontalLine.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            horizontalLine.setFont(composite.getFont());
        }
        return super.createDescriptionLabel(parent);
    }

    protected void contributeButtons(Composite parent) {
        this.buttonBar = parent;
        GridLayout layout = (GridLayout)parent.getLayout();
        layout.numColumns += 3;
        parent.setLayoutData((Object)new GridData(4, -1, true, false));
        Button importButton = this.createButton(parent, "Import All...");
        importButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainPreferencePage.this.performImport();
            }
        });
        Button exportButton = this.createButton(parent, "Export All...");
        exportButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainPreferencePage.this.performExport();
            }
        });
        Label filler = new Label(parent, 0);
        filler.setLayoutData((Object)new GridData(4, 0, true, false));
    }

    private Button createButton(Composite parent, String text) {
        Button button = new Button(parent, 8);
        Dialog.applyDialogFont((Control)button);
        button.setText(text);
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        Point minButtonSize = button.computeSize(-1, -1, true);
        GridData data = new GridData();
        data.widthHint = Math.max(widthHint, minButtonSize.x);
        button.setLayoutData((Object)data);
        return button;
    }

    private void createScopeLink(Composite parent) {
        String text = this.isProjectPropertyPage() ? LABEL_CONFIGURE_WOKSPACE : LABEL_CONFIGURE_PROJECT;
        this.scopeLink = new Link(parent, 0);
        this.scopeLink.setFont(parent.getFont());
        this.scopeLink.setText("<A>" + text + "</A>");
        this.scopeLink.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MainPreferencePage.this.scopeLinkSelected();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                MainPreferencePage.this.scopeLinkSelected();
            }
        });
    }

    private void scopeLinkSelected() {
        if (this.isProjectPropertyPage()) {
            this.openWorkspacePreferences();
            return;
        }
        HashSet<IJavaProject> projectsWithSpecifics = new HashSet<IJavaProject>();
        try {
            IJavaProject[] projects = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaProjects();
            int i = 0;
            while (i < projects.length) {
                IJavaProject curr = projects[i];
                if (this.hasProjectSpecificSettings(curr.getProject())) {
                    projectsWithSpecifics.add(curr);
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
        ProjectSelectionDialog dialog = new ProjectSelectionDialog(this.getShell(), projectsWithSpecifics);
        if (dialog.open() == 0) {
            IJavaProject res = (IJavaProject)dialog.getFirstResult();
            this.openProjectProperties(res.getProject());
        }
    }

    private void updateControlStates() {
        this.updateEnableStates();
        this.updateScopeLinkState();
    }

    private void updateEnableStates() {
        if (!this.isProjectPropertyPage()) {
            return;
        }
        if (this.projectSettingsButton.getSelection()) {
            if (this.enableState != null) {
                this.enableState.restore();
                this.btnEnableState.restore();
                this.enableState = null;
            }
        } else if (this.enableState == null) {
            this.enableState = ControlEnableState.disable((Control)this.basePanel);
            this.btnEnableState = ControlEnableState.disable((Control)this.buttonBar);
        }
    }

    private void updateScopeLinkState() {
        if (this.isProjectPropertyPage()) {
            this.scopeLink.setEnabled(this.isEnableScopeLink() && !this.projectSettingsButton.getSelection());
        } else {
            this.scopeLink.setEnabled(this.isEnableScopeLink());
        }
    }

    private boolean hasProjectSpecificSettings(IProject aProject) {
        return aProject != null && ConfigurationManager.getPreferenceStore(aProject).getBoolean("project_specific_settings");
    }

    private void setEnableScopeLink(boolean enable) {
        this.enableScopeLink = enable;
    }

    private boolean isEnableScopeLink() {
        return this.enableScopeLink;
    }

    private boolean isProjectPropertyPage() {
        return this.project != null;
    }

    private void openWorkspacePreferences() {
        String id = "net.sf.jautodoc.preferences.MainPreferencePage";
        Boolean data = Boolean.FALSE;
        PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)id, (String[])new String[]{id}, (Object)data).open();
    }

    private void openProjectProperties(IProject project) {
        String id = "net.sf.jautodoc.properties.MainPreferencePage";
        Boolean data = Boolean.FALSE;
        PreferencesUtil.createPropertyDialogOn((Shell)this.getShell(), (IAdaptable)project, (String)id, (String[])new String[]{id}, (Object)data).open();
    }

    private void updateControls() {
        PreferenceStore prefStore = null;
        if (this.isProjectPropertyPage() && this.hasProjectSpecificSettings(this.project)) {
            this.projectSettingsButton.setSelection(true);
            prefStore = ConfigurationManager.getPreferenceStore(this.project);
        } else {
            this.projectSettingsButton.setSelection(false);
            prefStore = ConfigurationManager.getPreferenceStore();
        }
        String mode = prefStore.getString("mode");
        if ("mode_complete".equals(mode)) {
            this.ob.completeButton.setSelection(true);
        } else if ("mode_keep".equals(mode)) {
            this.ob.keepButton.setSelection(true);
        } else if ("mode_replace".equals(mode)) {
            this.ob.replaceButton.setSelection(true);
        }
        this.ob.publicButton.setSelection(prefStore.getBoolean("visibility_public"));
        this.ob.protectedButton.setSelection(prefStore.getBoolean("visibility_protected"));
        this.ob.packageButton.setSelection(prefStore.getBoolean("visibility_package"));
        this.ob.privateButton.setSelection(prefStore.getBoolean("visibility_private"));
        this.ob.filterTypesButton.setSelection(prefStore.getBoolean("filter_types"));
        this.ob.filterFieldsButton.setSelection(prefStore.getBoolean("filter_fields"));
        this.ob.filterMethodsButton.setSelection(prefStore.getBoolean("filter_methods"));
        this.ob.filterGetterSetterButton.setSelection(prefStore.getBoolean("filter_getset"));
        this.ob.filterExcludeGetterSetterButton.setSelection(prefStore.getBoolean("filter_exclgetset"));
        this.ob.todoButton.setSelection(prefStore.getBoolean("add_todo"));
        this.ob.dummyDocButton.setSelection(prefStore.getBoolean("create_dummy_doc"));
        this.ob.singleLineButton.setSelection(prefStore.getBoolean("single_line_comment"));
        this.ob.useFormatterButton.setSelection(prefStore.getBoolean("use_internal_formatter"));
        this.ob.getSetFromFieldButton.setSelection(prefStore.getBoolean("get_set_from_field"));
        this.ob.includeSubPackagesButton.setSelection(prefStore.getBoolean("include_subpackages"));
        this.ob.getSetFromFieldFirstButton.setSelection(prefStore.getBoolean("get_set_from_field_first"));
        this.ob.getSetFromFieldReplaceButton.setSelection(prefStore.getBoolean("get_set_from_field_replace"));
        this.ob.addHeaderButton.setSelection(prefStore.getBoolean("add_header"));
        this.ob.replaceHeaderButton.setSelection(prefStore.getBoolean("replace_header"));
        this.ob.multiHeaderButton.setSelection(prefStore.getBoolean("multi_header"));
        this.ob.usePackageInfoButton.setSelection(prefStore.getBoolean("use_pkg_info"));
        this.ob.headerText = prefStore.getString("header_text");
        this.ob.packageDocText = prefStore.getString("package_doc_text");
        this.ob.packageInfoText = prefStore.getString("package_info_text");
        this.ob.tagOrder = new ArrayList<String>(prefStore.getTagOrder());
        this.ob.properties = new HashMap<String, String>(prefStore.getProperties());
        this.ob.updateButtonStates();
        this.rb.setReplacements(prefStore.getReplacements());
        this.updateControlStates();
    }

    private void performImport() {
        ImportExportDialog ied;
        ArrayList<PreferenceType> preferenceTypes = new ArrayList<PreferenceType>(Arrays.asList(PreferenceType.values()));
        if (this.isProjectPropertyPage()) {
            preferenceTypes.remove((Object)PreferenceType.TEMPLATES);
        }
        if ((ied = new ImportExportDialog(this.getShell(), ImportExportDialog.Type.IMPORT, preferenceTypes)).open() == 0) {
            try {
                PreferenceSerializer.doImport(this.ob, this.rb, ied.getSelectedPreferenceTypes(), ied.getSelectedFileName());
                this.ob.updateButtonStates();
                this.refreshTemplatePreferencePage();
            }
            catch (Exception e) {
                JAutodocPlugin.getDefault().handleException(this.getShell(), (Throwable)e);
            }
        }
    }

    private void refreshTemplatePreferencePage() {
        if (this.preferenceManager != null) {
            TemplatePreferencePage tpp;
            IPreferenceNode pn = this.preferenceManager.find("org.eclipse.jdt.ui.preferences.JavaBasePreferencePage/net.sf.jautodoc.preferences.MainPreferencePage/net.sf.jautodoc.preferences.templates.TemplatePreferencePage");
            if (pn != null && pn.getPage() == null) {
                pn.createPage();
            }
            if ((tpp = (TemplatePreferencePage)pn.getPage()) != null) {
                tpp.setProperties(this.ob.properties);
                tpp.refresh();
            }
        }
    }

    private void performExport() {
        ImportExportDialog ied;
        ArrayList<PreferenceType> preferenceTypes = new ArrayList<PreferenceType>(Arrays.asList(PreferenceType.values()));
        if (this.isProjectPropertyPage()) {
            preferenceTypes.remove((Object)PreferenceType.TEMPLATES);
        }
        if ((ied = new ImportExportDialog(this.getShell(), ImportExportDialog.Type.EXPORT, preferenceTypes)).open() == 0) {
            try {
                PreferenceSerializer.doExport(this.ob, this.rb, ied.getSelectedPreferenceTypes(), ied.getSelectedFileName());
            }
            catch (Exception e) {
                JAutodocPlugin.getDefault().handleException(this.getShell(), (Throwable)e);
            }
        }
    }

    protected void performDefaults() {
        if (this.isProjectPropertyPage() && !this.projectSettingsButton.getSelection()) {
            return;
        }
        PreferenceStore prefStore = (PreferenceStore)this.getPreferenceStore();
        String mode = prefStore.getDefaultString("mode");
        if ("mode_complete".equals(mode)) {
            this.ob.completeButton.setSelection(true);
            this.ob.keepButton.setSelection(false);
            this.ob.replaceButton.setSelection(false);
        } else if ("mode_keep".equals(mode)) {
            this.ob.completeButton.setSelection(false);
            this.ob.keepButton.setSelection(true);
            this.ob.replaceButton.setSelection(false);
        } else if ("mode_replace".equals(mode)) {
            this.ob.completeButton.setSelection(false);
            this.ob.keepButton.setSelection(false);
            this.ob.replaceButton.setSelection(true);
        }
        this.ob.publicButton.setSelection(prefStore.getDefaultBoolean("visibility_public"));
        this.ob.protectedButton.setSelection(prefStore.getDefaultBoolean("visibility_protected"));
        this.ob.packageButton.setSelection(prefStore.getDefaultBoolean("visibility_package"));
        this.ob.privateButton.setSelection(prefStore.getDefaultBoolean("visibility_private"));
        this.ob.filterTypesButton.setSelection(prefStore.getDefaultBoolean("filter_types"));
        this.ob.filterFieldsButton.setSelection(prefStore.getDefaultBoolean("filter_fields"));
        this.ob.filterMethodsButton.setSelection(prefStore.getDefaultBoolean("filter_methods"));
        this.ob.filterGetterSetterButton.setSelection(prefStore.getDefaultBoolean("filter_getset"));
        this.ob.filterExcludeGetterSetterButton.setSelection(prefStore.getDefaultBoolean("filter_exclgetset"));
        this.ob.todoButton.setSelection(prefStore.getDefaultBoolean("add_todo"));
        this.ob.dummyDocButton.setSelection(prefStore.getDefaultBoolean("create_dummy_doc"));
        this.ob.singleLineButton.setSelection(prefStore.getDefaultBoolean("single_line_comment"));
        this.ob.useFormatterButton.setSelection(prefStore.getDefaultBoolean("use_internal_formatter"));
        this.ob.getSetFromFieldButton.setSelection(prefStore.getDefaultBoolean("get_set_from_field"));
        this.ob.includeSubPackagesButton.setSelection(prefStore.getDefaultBoolean("include_subpackages"));
        this.ob.getSetFromFieldFirstButton.setSelection(prefStore.getDefaultBoolean("get_set_from_field_first"));
        this.ob.getSetFromFieldReplaceButton.setSelection(prefStore.getDefaultBoolean("get_set_from_field_replace"));
        this.ob.addHeaderButton.setSelection(prefStore.getDefaultBoolean("add_header"));
        this.ob.replaceHeaderButton.setSelection(prefStore.getDefaultBoolean("replace_header"));
        this.ob.multiHeaderButton.setSelection(prefStore.getDefaultBoolean("multi_header"));
        this.ob.usePackageInfoButton.setSelection(prefStore.getDefaultBoolean("use_pkg_info"));
        this.ob.tagOrder.clear();
        this.ob.tagOrder.addAll(Arrays.asList("@author,@version,@param,@return,@throws,@see,@since,@serial,@serialField,@serialData,@deprecated".split(",")));
        this.ob.updateButtonStates();
        this.rb.setReplacements(prefStore.getDefaultReplacements());
        this.updateControlStates();
        super.performDefaults();
    }

    public boolean performOk() {
        PreferenceStore prefStore = (PreferenceStore)this.getPreferenceStore();
        if (this.isProjectPropertyPage()) {
            prefStore.setValue("project_specific_settings", this.projectSettingsButton.getSelection());
            if (!this.projectSettingsButton.getSelection()) {
                return super.performOk();
            }
        }
        if (this.ob.completeButton.getSelection()) {
            prefStore.setValue("mode", "mode_complete");
        } else if (this.ob.keepButton.getSelection()) {
            prefStore.setValue("mode", "mode_keep");
        } else if (this.ob.replaceButton.getSelection()) {
            prefStore.setValue("mode", "mode_replace");
        }
        prefStore.setValue("visibility_public", this.ob.publicButton.getSelection());
        prefStore.setValue("visibility_protected", this.ob.protectedButton.getSelection());
        prefStore.setValue("visibility_package", this.ob.packageButton.getSelection());
        prefStore.setValue("visibility_private", this.ob.privateButton.getSelection());
        prefStore.setValue("filter_types", this.ob.filterTypesButton.getSelection());
        prefStore.setValue("filter_fields", this.ob.filterFieldsButton.getSelection());
        prefStore.setValue("filter_methods", this.ob.filterMethodsButton.getSelection());
        prefStore.setValue("filter_getset", this.ob.filterGetterSetterButton.getSelection());
        prefStore.setValue("filter_exclgetset", this.ob.filterExcludeGetterSetterButton.getSelection());
        prefStore.setValue("add_todo", this.ob.todoButton.getSelection());
        prefStore.setValue("create_dummy_doc", this.ob.dummyDocButton.getSelection());
        prefStore.setValue("single_line_comment", this.ob.singleLineButton.getSelection());
        prefStore.setValue("use_internal_formatter", this.ob.useFormatterButton.getSelection());
        prefStore.setValue("get_set_from_field", this.ob.getSetFromFieldButton.getSelection());
        prefStore.setValue("include_subpackages", this.ob.includeSubPackagesButton.getSelection());
        prefStore.setValue("get_set_from_field_first", this.ob.getSetFromFieldFirstButton.getSelection());
        prefStore.setValue("get_set_from_field_replace", this.ob.getSetFromFieldReplaceButton.getSelection());
        prefStore.setValue("add_header", this.ob.addHeaderButton.getSelection());
        prefStore.setValue("replace_header", this.ob.replaceHeaderButton.getSelection());
        prefStore.setValue("multi_header", this.ob.multiHeaderButton.getSelection());
        prefStore.setValue("use_pkg_info", this.ob.usePackageInfoButton.getSelection());
        prefStore.setValue("header_text", this.ob.headerText);
        prefStore.setValue("package_doc_text", this.ob.packageDocText);
        prefStore.setValue("package_info_text", this.ob.packageInfoText);
        prefStore.setTagOrder(this.ob.tagOrder);
        prefStore.setProperties(this.ob.properties);
        prefStore.setReplacements(this.rb.getReplacements());
        return super.performOk();
    }

    public void init(IWorkbench workbench) {
        this.preferenceManager = workbench.getPreferenceManager();
    }

    public IPreferenceStore getPreferenceStore() {
        if (this.isProjectPropertyPage()) {
            return ConfigurationManager.getPreferenceStore(this.project);
        }
        return ConfigurationManager.getPreferenceStore();
    }

    public void applyData(Object data) {
        if (data instanceof Boolean) {
            this.setEnableScopeLink((Boolean)data);
        }
        this.updateScopeLinkState();
    }

    public IAdaptable getElement() {
        return this.project;
    }

    public void setElement(IAdaptable element) {
        this.project = (IProject)element.getAdapter(IResource.class);
    }
}

