/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.preferences;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlTransient;
import net.sf.jautodoc.preferences.Constants;
import net.sf.jautodoc.preferences.IMemberFilter;
import net.sf.jautodoc.preferences.PreferenceStore;
import net.sf.jautodoc.preferences.replacements.Replacement;
import net.sf.jautodoc.preferences.replacements.ReplacementManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class Configuration
implements IMemberFilter,
IPropertyChangeListener,
Constants {
    @XmlTransient
    private PreferenceStore prefStore;
    @XmlTransient
    private IProject project;
    @XmlTransient
    private boolean readonly = true;
    private boolean completeExistingJavadoc = true;
    private boolean keepExistingJavadoc = false;
    private boolean replaceExistingJavadoc = false;
    private boolean includePublic = true;
    private boolean includeProtected = true;
    private boolean includePackage = true;
    private boolean includePrivate = true;
    private boolean includeTypes = true;
    private boolean includeFields = true;
    private boolean includeMethods = true;
    private boolean getterSetterOnly = true;
    private boolean excludeGetterSetter = true;
    private boolean addTodoForAutodoc = true;
    private boolean createDummyComment = true;
    private boolean singleLineComment = true;
    private boolean useEclipseFormatter = false;
    private boolean getterSetterFromField = false;
    private boolean includeSubPackages = false;
    private boolean getterSetterFromFieldFirst = true;
    private boolean getterSetterFromFieldReplace = false;
    private boolean addHeader = false;
    private boolean replaceHeader = false;
    private boolean multiCommentHeader = false;
    private boolean usePackageInfo = false;
    @XmlTransient
    private String headerText = "";
    @XmlTransient
    private String packageDocText = "";
    @XmlTransient
    private String packageInfoText = "";
    @XmlTransient
    private List<String> tagOrder = new ArrayList<String>();
    @XmlTransient
    private Map<String, String> properties = new HashMap<String, String>();
    @XmlTransient
    private ReplacementManager replacementManager;

    public Configuration() {
        this.readonly = false;
    }

    public Configuration(PreferenceStore prefStore) {
        this(prefStore, null);
    }

    public Configuration(PreferenceStore prefStore, IProject project) {
        this.initialize(prefStore, project);
    }

    public Configuration(Configuration c) {
        this.readonly = false;
        this.completeExistingJavadoc = c.completeExistingJavadoc;
        this.keepExistingJavadoc = c.keepExistingJavadoc;
        this.replaceExistingJavadoc = c.replaceExistingJavadoc;
        this.includePublic = c.includePublic;
        this.includeProtected = c.includeProtected;
        this.includePackage = c.includePackage;
        this.includePrivate = c.includePrivate;
        this.includeTypes = c.includeTypes;
        this.includeFields = c.includeFields;
        this.includeMethods = c.includeMethods;
        this.getterSetterOnly = c.getterSetterOnly;
        this.excludeGetterSetter = c.excludeGetterSetter;
        this.addTodoForAutodoc = c.addTodoForAutodoc;
        this.createDummyComment = c.createDummyComment;
        this.singleLineComment = c.singleLineComment;
        this.useEclipseFormatter = c.useEclipseFormatter;
        this.getterSetterFromField = c.getterSetterFromField;
        this.includeSubPackages = c.includeSubPackages;
        this.getterSetterFromFieldFirst = c.getterSetterFromFieldFirst;
        this.getterSetterFromFieldReplace = c.getterSetterFromFieldReplace;
        this.addHeader = c.addHeader;
        this.replaceHeader = c.replaceHeader;
        this.multiCommentHeader = c.multiCommentHeader;
        this.headerText = new String(c.headerText);
        this.packageDocText = new String(c.packageDocText);
        this.packageInfoText = new String(c.packageInfoText);
        this.tagOrder.addAll(c.tagOrder);
        this.properties.putAll(c.properties);
        this.replacementManager = new ReplacementManager(c.replacementManager);
    }

    public PreferenceStore getPreferenceStore() {
        return this.prefStore;
    }

    public boolean isAddHeader() {
        return this.addHeader;
    }

    public void setAddHeader(boolean addHeader) {
        this.checkReadonly();
        this.addHeader = addHeader;
    }

    public boolean isAddTodoForAutodoc() {
        return this.addTodoForAutodoc;
    }

    public void setAddTodoForAutodoc(boolean addTodoForAutodoc) {
        this.checkReadonly();
        this.addTodoForAutodoc = addTodoForAutodoc;
    }

    @Override
    public boolean isIncludeFields() {
        return this.includeFields;
    }

    public void setCommentFields(boolean commentFields) {
        this.checkReadonly();
        this.includeFields = commentFields;
    }

    @Override
    public boolean isIncludeMethods() {
        return this.includeMethods;
    }

    public void setCommentMethods(boolean commentMethods) {
        this.checkReadonly();
        this.includeMethods = commentMethods;
    }

    @Override
    public boolean isIncludeTypes() {
        return this.includeTypes;
    }

    public void setCommentTypes(boolean commentTypes) {
        this.checkReadonly();
        this.includeTypes = commentTypes;
    }

    public boolean isCompleteExistingJavadoc() {
        return this.completeExistingJavadoc;
    }

    public void setCompleteExistingJavadoc(boolean completeExistingJavadoc) {
        this.checkReadonly();
        this.completeExistingJavadoc = completeExistingJavadoc;
    }

    public boolean isCreateDummyComment() {
        return this.createDummyComment;
    }

    public void setCreateDummyComment(boolean createDummyComment) {
        this.checkReadonly();
        this.createDummyComment = createDummyComment;
    }

    @Override
    public boolean isGetterSetterOnly() {
        return this.getterSetterOnly;
    }

    public void setGetterSetterOnly(boolean getterSetterOnly) {
        this.checkReadonly();
        this.getterSetterOnly = getterSetterOnly;
    }

    @Override
    public boolean isExcludeGetterSetter() {
        return this.excludeGetterSetter;
    }

    public void setExcludeGetterSetter(boolean excludeGetterSetter) {
        this.checkReadonly();
        this.excludeGetterSetter = excludeGetterSetter;
    }

    public boolean isKeepExistingJavadoc() {
        return this.keepExistingJavadoc;
    }

    public void setKeepExistingJavadoc(boolean keepExistingJavadoc) {
        this.checkReadonly();
        this.keepExistingJavadoc = keepExistingJavadoc;
    }

    public boolean isReplaceExistingJavadoc() {
        return this.replaceExistingJavadoc;
    }

    public void setReplaceExistingJavadoc(boolean replaceExistingJavadoc) {
        this.checkReadonly();
        this.replaceExistingJavadoc = replaceExistingJavadoc;
    }

    public boolean isReplaceHeader() {
        return this.replaceHeader;
    }

    public void setReplaceHeader(boolean replaceHeader) {
        this.checkReadonly();
        this.replaceHeader = replaceHeader;
    }

    public boolean isMultiCommentHeader() {
        return this.multiCommentHeader;
    }

    public void setMultiCommentHeader(boolean multiCommentHeader) {
        this.checkReadonly();
        this.multiCommentHeader = multiCommentHeader;
    }

    public boolean isUsePackageInfo() {
        return this.usePackageInfo;
    }

    public void setUsePackageInfo(boolean usePackageInfo) {
        this.checkReadonly();
        this.usePackageInfo = usePackageInfo;
    }

    public boolean isSingleLineComment() {
        return this.singleLineComment;
    }

    public void setSingleLineComment(boolean singleLineComment) {
        this.checkReadonly();
        this.singleLineComment = singleLineComment;
    }

    public boolean isUseEclipseFormatter() {
        return this.useEclipseFormatter;
    }

    public void setUseEclipseFormatter(boolean useEclipseFormatter) {
        this.checkReadonly();
        this.useEclipseFormatter = useEclipseFormatter;
    }

    public boolean isGetterSetterFromField() {
        return this.getterSetterFromField;
    }

    public void setGetterSetterFromField(boolean getterSetterFromField) {
        this.checkReadonly();
        this.getterSetterFromField = getterSetterFromField;
    }

    public boolean isGetterSetterFromFieldFirst() {
        return this.getterSetterFromFieldFirst;
    }

    public void setGetterSetterFromFieldFirst(boolean getterSetterFromFieldFirst) {
        this.checkReadonly();
        this.getterSetterFromFieldFirst = getterSetterFromFieldFirst;
    }

    public boolean isGetterSetterFromFieldReplace() {
        return this.getterSetterFromFieldReplace;
    }

    public void setGetterSetterFromFieldReplace(boolean getterSetterFromFieldReplace) {
        this.checkReadonly();
        this.getterSetterFromFieldReplace = getterSetterFromFieldReplace;
    }

    public boolean isIncludeSubPackages() {
        return this.includeSubPackages;
    }

    public void setIncludeSubPackages(boolean includeSubPackages) {
        this.checkReadonly();
        this.includeSubPackages = includeSubPackages;
    }

    @Override
    public boolean isIncludePackage() {
        return this.includePackage;
    }

    public void setVisibilityPackage(boolean visibilityPackage) {
        this.checkReadonly();
        this.includePackage = visibilityPackage;
    }

    @Override
    public boolean isIncludePrivate() {
        return this.includePrivate;
    }

    public void setVisibilityPrivate(boolean visibilityPrivate) {
        this.checkReadonly();
        this.includePrivate = visibilityPrivate;
    }

    @Override
    public boolean isIncludeProtected() {
        return this.includeProtected;
    }

    public void setVisibilityProtected(boolean visibilityProtected) {
        this.checkReadonly();
        this.includeProtected = visibilityProtected;
    }

    @Override
    public boolean isIncludePublic() {
        return this.includePublic;
    }

    public void setVisibilityPublic(boolean visibilityPublic) {
        this.checkReadonly();
        this.includePublic = visibilityPublic;
    }

    public String getHeaderText() {
        return this.headerText;
    }

    public void setHeaderText(String headerText) {
        this.checkReadonly();
        this.headerText = headerText;
    }

    public String getPackageDocText() {
        return this.packageDocText;
    }

    public void setPackageDocText(String packageDocText) {
        this.checkReadonly();
        this.packageDocText = packageDocText;
    }

    public String getPackageInfoText() {
        return this.packageInfoText;
    }

    public void setPackageInfoText(String packageInfoText) {
        this.checkReadonly();
        this.packageInfoText = packageInfoText;
    }

    public List<String> getTagOrder() {
        return Collections.unmodifiableList(this.tagOrder);
    }

    public void setTagOrder(List<String> tagOrder) {
        this.checkReadonly();
        this.tagOrder.clear();
        this.tagOrder.addAll(tagOrder);
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public void setProperties(Map<String, String> properties) {
        this.checkReadonly();
        this.properties.clear();
        this.properties.putAll(properties);
    }

    public ReplacementManager getReplacementManager() {
        return this.replacementManager;
    }

    private void initialize(PreferenceStore prefStore, IProject project) {
        this.prefStore = prefStore;
        this.project = project;
        this.initReplacements();
        this.initMode();
        this.tagOrder.addAll(prefStore.getTagOrder());
        this.properties.putAll(prefStore.getProperties());
        this.includePublic = prefStore.getBoolean("visibility_public");
        this.includeProtected = prefStore.getBoolean("visibility_protected");
        this.includePackage = prefStore.getBoolean("visibility_package");
        this.includePrivate = prefStore.getBoolean("visibility_private");
        this.includeTypes = prefStore.getBoolean("filter_types");
        this.includeFields = prefStore.getBoolean("filter_fields");
        this.includeMethods = prefStore.getBoolean("filter_methods");
        this.getterSetterOnly = prefStore.getBoolean("filter_getset");
        this.excludeGetterSetter = prefStore.getBoolean("filter_exclgetset");
        this.addTodoForAutodoc = prefStore.getBoolean("add_todo");
        this.createDummyComment = prefStore.getBoolean("create_dummy_doc");
        this.singleLineComment = prefStore.getBoolean("single_line_comment");
        this.useEclipseFormatter = prefStore.getBoolean("use_internal_formatter");
        this.getterSetterFromField = prefStore.getBoolean("get_set_from_field");
        this.includeSubPackages = prefStore.getBoolean("include_subpackages");
        this.addHeader = prefStore.getBoolean("add_header");
        this.replaceHeader = prefStore.getBoolean("replace_header");
        this.multiCommentHeader = prefStore.getBoolean("multi_header");
        this.usePackageInfo = prefStore.getBoolean("use_pkg_info");
        this.getterSetterFromFieldFirst = prefStore.getBoolean("get_set_from_field_first");
        this.getterSetterFromFieldReplace = prefStore.getBoolean("get_set_from_field_replace");
        this.headerText = prefStore.getString("header_text");
        this.packageDocText = prefStore.getString("package_doc_text");
        this.packageInfoText = prefStore.getString("package_info_text");
        prefStore.addPropertyChangeListener(this);
        this.initGlobalPreferenceChangeListener();
    }

    private void initReplacements() {
        List<Replacement> replacements = this.getDefaultFieldPrefixReplacements();
        replacements.addAll(Arrays.asList(this.prefStore.getReplacements()));
        this.replacementManager = new ReplacementManager(replacements.toArray(new Replacement[replacements.size()]));
    }

    private void initMode() {
        String mode = this.prefStore.getString("mode");
        if ("mode_complete".equals(mode)) {
            this.completeExistingJavadoc = true;
            this.keepExistingJavadoc = false;
            this.replaceExistingJavadoc = false;
        } else if ("mode_keep".equals(mode)) {
            this.completeExistingJavadoc = false;
            this.keepExistingJavadoc = true;
            this.replaceExistingJavadoc = false;
        } else if ("mode_replace".equals(mode)) {
            this.completeExistingJavadoc = false;
            this.keepExistingJavadoc = false;
            this.replaceExistingJavadoc = true;
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().startsWith("replacements")) {
            this.initReplacements();
        } else if ("mode".equals(event.getProperty())) {
            this.initMode();
        } else if ("tag_order".equals(event.getProperty())) {
            this.tagOrder.clear();
            this.tagOrder.addAll(this.prefStore.getTagOrder());
        } else if (event.getProperty().startsWith("properties")) {
            this.properties.clear();
            this.properties.putAll(this.prefStore.getProperties());
        } else if ("visibility_public".equals(event.getProperty())) {
            this.includePublic = this.prefStore.getBoolean("visibility_public");
        } else if ("visibility_protected".equals(event.getProperty())) {
            this.includeProtected = this.prefStore.getBoolean("visibility_protected");
        } else if ("visibility_package".equals(event.getProperty())) {
            this.includePackage = this.prefStore.getBoolean("visibility_package");
        } else if ("visibility_private".equals(event.getProperty())) {
            this.includePrivate = this.prefStore.getBoolean("visibility_private");
        } else if ("filter_types".equals(event.getProperty())) {
            this.includeTypes = this.prefStore.getBoolean("filter_types");
        } else if ("filter_fields".equals(event.getProperty())) {
            this.includeFields = this.prefStore.getBoolean("filter_fields");
        } else if ("filter_methods".equals(event.getProperty())) {
            this.includeMethods = this.prefStore.getBoolean("filter_methods");
        } else if ("filter_getset".equals(event.getProperty())) {
            this.getterSetterOnly = this.prefStore.getBoolean("filter_getset");
        } else if ("filter_exclgetset".equals(event.getProperty())) {
            this.excludeGetterSetter = this.prefStore.getBoolean("filter_exclgetset");
        } else if ("add_todo".equals(event.getProperty())) {
            this.addTodoForAutodoc = this.prefStore.getBoolean("add_todo");
        } else if ("create_dummy_doc".equals(event.getProperty())) {
            this.createDummyComment = this.prefStore.getBoolean("create_dummy_doc");
        } else if ("single_line_comment".equals(event.getProperty())) {
            this.singleLineComment = this.prefStore.getBoolean("single_line_comment");
        } else if ("use_internal_formatter".equals(event.getProperty())) {
            this.useEclipseFormatter = this.prefStore.getBoolean("use_internal_formatter");
        } else if ("get_set_from_field".equals(event.getProperty())) {
            this.getterSetterFromField = this.prefStore.getBoolean("get_set_from_field");
        } else if ("get_set_from_field_first".equals(event.getProperty())) {
            this.getterSetterFromFieldFirst = this.prefStore.getBoolean("get_set_from_field_first");
        } else if ("get_set_from_field_replace".equals(event.getProperty())) {
            this.getterSetterFromFieldReplace = this.prefStore.getBoolean("get_set_from_field_replace");
        } else if ("include_subpackages".equals(event.getProperty())) {
            this.includeSubPackages = this.prefStore.getBoolean("include_subpackages");
        } else if ("add_header".equals(event.getProperty())) {
            this.addHeader = this.prefStore.getBoolean("add_header");
        } else if ("replace_header".equals(event.getProperty())) {
            this.replaceHeader = this.prefStore.getBoolean("replace_header");
        } else if ("multi_header".equals(event.getProperty())) {
            this.multiCommentHeader = this.prefStore.getBoolean("multi_header");
        } else if ("use_pkg_info".equals(event.getProperty())) {
            this.usePackageInfo = this.prefStore.getBoolean("use_pkg_info");
        } else if ("header_text".equals(event.getProperty())) {
            this.headerText = this.prefStore.getString("header_text");
        } else if ("package_doc_text".equals(event.getProperty())) {
            this.packageDocText = this.prefStore.getString("package_doc_text");
        } else if ("package_info_text".equals(event.getProperty())) {
            this.packageInfoText = this.prefStore.getString("package_info_text");
        }
    }

    private void checkReadonly() {
        if (this.readonly) {
            throw new IllegalStateException("Configuration is read only");
        }
    }

    private IJavaProject getJavaProject() {
        return this.project == null ? null : JavaCore.create((IProject)this.project);
    }

    private List<Replacement> getDefaultFieldPrefixReplacements() {
        ArrayList<Replacement> replacements = new ArrayList<Replacement>();
        Set<String> prefixes = this.getDefaultFieldPrefixes();
        for (String prefix : prefixes) {
            String shortcut = prefix.trim();
            if (shortcut.length() <= 0) continue;
            replacements.add(new Replacement(shortcut, "", 2, 0));
        }
        return replacements;
    }

    private Set<String> getDefaultFieldPrefixes() {
        HashSet<String> prefixes = new HashSet<String>();
        IJavaProject javaProject = this.getJavaProject();
        this.getDefaultFieldPrefixes(javaProject, prefixes, "org.eclipse.jdt.core.codeComplete.fieldPrefixes");
        this.getDefaultFieldPrefixes(javaProject, prefixes, "org.eclipse.jdt.core.codeComplete.staticFieldPrefixes");
        this.getDefaultFieldPrefixes(javaProject, prefixes, "org.eclipse.jdt.core.codeComplete.argumentPrefixes");
        return prefixes;
    }

    private void getDefaultFieldPrefixes(IJavaProject javaProject, Set<String> prefixes, String optionName) {
        String sPrefixes;
        String string = sPrefixes = javaProject == null ? JavaCore.getOption((String)optionName) : javaProject.getOption(optionName, true);
        if (sPrefixes != null && sPrefixes.length() > 0) {
            prefixes.addAll(Arrays.asList(sPrefixes.split(",")));
        }
    }

    private void initGlobalPreferenceChangeListener() {
        this.getScopeContext().getNode("org.eclipse.jdt.core").addPreferenceChangeListener(new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                if (event.getKey().equals("org.eclipse.jdt.core.codeComplete.fieldPrefixes") || event.getKey().equals("org.eclipse.jdt.core.codeComplete.staticFieldPrefixes") || event.getKey().equals("org.eclipse.jdt.core.codeComplete.argumentPrefixes")) {
                    Configuration.this.initReplacements();
                }
            }
        });
    }

    private IScopeContext getScopeContext() {
        return this.project == null ? InstanceScope.INSTANCE : new ProjectScope(this.project);
    }
}

