/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.jautodoc.actions.AbstractOAD;
import net.sf.jautodoc.preferences.Configuration;
import net.sf.jautodoc.preferences.ConfigurationManager;
import net.sf.jautodoc.preferences.Constants;
import net.sf.jautodoc.source.JavadocFormatter;
import net.sf.jautodoc.source.SourceManipulator;
import net.sf.jautodoc.utils.Utils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class AddJavadocOAD
extends AbstractOAD {
    @Override
    protected AbstractOAD.ITask getTask(Map<ICompilationUnit, List<IMember>> cus) {
        return new AddJavadocTask(cus);
    }

    private class AddJavadocTask
    implements AbstractOAD.ITask {
        private Exception exception;
        private ICompilationUnit compUnit;
        private final Map<ICompilationUnit, List<IMember>> cus;

        public AddJavadocTask(Map<ICompilationUnit, List<IMember>> cus) {
            this.cus = cus;
        }

        @Override
        public ICompilationUnit getCompilationUnit() {
            return this.compUnit;
        }

        @Override
        public void checkSuccess() throws Exception {
            if (this.exception != null) {
                throw this.exception;
            }
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                try {
                    monitor.beginTask(Constants.TITLE_JDOC_TASK, this.cus.size());
                    for (Map.Entry<ICompilationUnit, List<IMember>> entry : this.cus.entrySet()) {
                        IEditorPart editor;
                        this.compUnit = entry.getKey();
                        List<IMember> members = entry.getValue();
                        monitor.subTask(this.compUnit.getElementName());
                        if (monitor.isCanceled()) {
                            break;
                        }
                        Configuration config = ConfigurationManager.getConfiguration(this.compUnit);
                        if (config.isUseEclipseFormatter()) {
                            JavadocFormatter.getInstance().startFormatting(this.compUnit);
                        }
                        if ((editor = Utils.findEditor((IJavaElement)this.compUnit)) != null) {
                            editor.getEditorSite().getPage().bringToTop((IWorkbenchPart)editor);
                        }
                        ICompilationUnit workingCopy = Utils.getWorkingCopy(this.compUnit, editor);
                        SourceManipulator sm = new SourceManipulator(workingCopy, config);
                        if (members != null && members.size() > 0) {
                            IMember[] wcMembers = this.getWorkingCopyMembers(workingCopy, members);
                            sm.addJavadoc(wcMembers, null);
                        } else {
                            sm.addJavadoc((IProgressMonitor)null);
                        }
                        if (editor == null) {
                            workingCopy.commitWorkingCopy(false, null);
                            workingCopy.discardWorkingCopy();
                        } else if (members != null && members.size() > 0) {
                            IMember member = members.get(0);
                            int offset = member.getNameRange().getOffset();
                            int length = member.getNameRange().getLength();
                            ((ITextEditor)editor).selectAndReveal(offset, length);
                        }
                        monitor.worked(1);
                    }
                }
                catch (Exception e) {
                    this.exception = e;
                    JavadocFormatter.getInstance().stopFormatting();
                    monitor.done();
                }
            }
            finally {
                JavadocFormatter.getInstance().stopFormatting();
                monitor.done();
            }
        }

        private IMember[] getWorkingCopyMembers(ICompilationUnit workingCopy, List<IMember> members) {
            ArrayList<IMember> memberList = new ArrayList<IMember>();
            int i = 0;
            while (i < members.size()) {
                IMember member = members.get(i);
                if (this.compUnit == member.getCompilationUnit()) {
                    if (workingCopy == member.getCompilationUnit()) {
                        memberList.add(member);
                    } else {
                        IJavaElement[] elements = workingCopy.findElements((IJavaElement)member);
                        if (elements != null) {
                            int j = 0;
                            while (j < elements.length) {
                                if (elements[j] instanceof IMember) {
                                    memberList.add((IMember)elements[j]);
                                }
                                ++j;
                            }
                        }
                    }
                }
                ++i;
            }
            return memberList.toArray(new IMember[memberList.size()]);
        }
    }
}

