/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import net.sf.jautodoc.actions.AbstractOAD;
import net.sf.jautodoc.preferences.Constants;
import net.sf.jautodoc.source.SourceManipulator;
import net.sf.jautodoc.utils.Utils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class AddHeaderOAD
extends AbstractOAD {
    @Override
    protected AbstractOAD.ITask getTask(Map<ICompilationUnit, List<IMember>> cus) {
        return new AddHeaderTask(cus.keySet().toArray(new ICompilationUnit[cus.size()]));
    }

    private class AddHeaderTask
    implements AbstractOAD.ITask {
        private ICompilationUnit compUnit;
        private ICompilationUnit[] compUnits;
        private Exception exception;

        public AddHeaderTask(ICompilationUnit[] compUnits) {
            this.compUnits = compUnits;
        }

        @Override
        public ICompilationUnit getCompilationUnit() {
            return this.compUnit;
        }

        @Override
        public void checkSuccess() throws Exception {
            if (this.exception != null) {
                throw this.exception;
            }
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                try {
                    monitor.beginTask(Constants.TITLE_HEADER_TASK, this.compUnits.length);
                    int i = 0;
                    while (i < this.compUnits.length) {
                        this.compUnit = this.compUnits[i];
                        monitor.subTask(this.compUnit.getElementName());
                        if (monitor.isCanceled()) {
                            break;
                        }
                        ITextSelection selection = null;
                        IEditorPart editor = Utils.findEditor((IJavaElement)this.compUnit);
                        if (editor != null) {
                            editor.getEditorSite().getPage().bringToTop((IWorkbenchPart)editor);
                            selection = (ITextSelection)editor.getEditorSite().getSelectionProvider().getSelection();
                        }
                        ICompilationUnit workingCopy = Utils.getWorkingCopy(this.compUnit, editor);
                        SourceManipulator sm = new SourceManipulator(workingCopy);
                        sm.setForceAddHeader(true);
                        if (selection != null) {
                            sm.setCursorPosition(selection.getOffset());
                        }
                        sm.addJavadoc(new IMember[0], null);
                        if (editor == null) {
                            workingCopy.commitWorkingCopy(false, null);
                            workingCopy.discardWorkingCopy();
                        } else if (editor != null) {
                            ((ITextEditor)editor).selectAndReveal(sm.getCursorPosition(), 0);
                        }
                        monitor.worked(1);
                        ++i;
                    }
                }
                catch (Exception e) {
                    this.exception = e;
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
        }
    }
}

