/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import net.sf.jautodoc.JAutodocPlugin;
import net.sf.jautodoc.preferences.Configuration;
import net.sf.jautodoc.preferences.ConfigurationManager;
import net.sf.jautodoc.preferences.OptionsDialog;
import net.sf.jautodoc.preview.CompilationUnitRefactoring;
import net.sf.jautodoc.preview.CompilationUnitRefactoringWizard;
import net.sf.jautodoc.source.SourceManipulator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.IWorkingCopyManager;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.internal.operations.TimeTriggeredProgressMonitorDialog;

public abstract class AbstractEAD
implements IEditorActionDelegate {
    private static final String JAVADOC_DLG_ACTION = "net.sf.jautodoc.view.action.addJavadocDlg";
    private static final String HEADER_DLG_ACTION = "net.sf.jautodoc.view.action.addHeaderDlg";
    protected String dialogTitle;
    protected boolean showDialog;
    protected IEditorPart editorPart;

    public void setShowDialog(boolean showDialog, String dialogTitle) {
        this.showDialog = showDialog;
        this.dialogTitle = dialogTitle;
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.editorPart = targetEditor;
    }

    public void run(IAction action) {
        boolean showPreview;
        Configuration config;
        SourceManipulator sm;
        IRunnableWithProgress task;
        IEditorInput editorInput = this.editorPart.getEditorInput();
        IWorkingCopyManager manager = JavaUI.getWorkingCopyManager();
        ICompilationUnit compUnit = manager.getWorkingCopy(editorInput);
        if (compUnit.findPrimaryType() == null) {
            return;
        }
        do {
            int rc;
            if ((rc = this.showOptionsDialog(action, compUnit)) == 1) {
                return;
            }
            boolean bl = showPreview = rc == 1024;
        } while (this.runTask(task = this.createTask(sm = this.createSourceManipulator(compUnit, config = this.findConfiguration(compUnit), showPreview), compUnit, config), sm, compUnit, showPreview) != 0);
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    protected abstract void doRun(SourceManipulator var1, ICompilationUnit var2, Configuration var3, IProgressMonitor var4) throws Exception;

    protected IMember getSelectedMember(ICompilationUnit compUnit) throws JavaModelException {
        ITextSelection textSelection = this.getSelection();
        if (textSelection == null) {
            return null;
        }
        IJavaElement element = compUnit.getElementAt(textSelection.getOffset());
        if (element == null) {
            return null;
        }
        if (element instanceof IType) {
            ISourceRange typeNameRange = ((IType)element).getNameRange();
            if (typeNameRange.getOffset() > textSelection.getOffset()) {
                element = null;
            } else if (typeNameRange.getOffset() + typeNameRange.getLength() < textSelection.getOffset()) {
                element = null;
            }
            return (IMember)element;
        }
        if (!(element instanceof IField) && !(element instanceof IMethod)) {
            element = null;
        }
        return (IMember)element;
    }

    protected ITextSelection getSelection() {
        return this.editorPart != null && this.editorPart.getEditorSite().getSelectionProvider() != null ? (ITextSelection)this.editorPart.getEditorSite().getSelectionProvider().getSelection() : null;
    }

    private Shell getShell() {
        return this.editorPart.getSite().getShell();
    }

    private Configuration findConfiguration(ICompilationUnit compUnit) {
        Configuration config = ConfigurationManager.getCachedConfiguration(compUnit);
        if (config == null) {
            config = ConfigurationManager.getConfiguration(compUnit);
        }
        return config;
    }

    private int showOptionsDialog(IAction action, ICompilationUnit compUnit) {
        if (this.showDialog || action != null && (JAVADOC_DLG_ACTION.equals(action.getId()) || HEADER_DLG_ACTION.equals(action.getId()))) {
            if (this.dialogTitle == null && action != null) {
                this.dialogTitle = JAVADOC_DLG_ACTION.equals(action.getId()) ? "Add Javadoc" : "Add Header";
            }
            OptionsDialog dlg = new OptionsDialog(this.getShell(), this.dialogTitle, compUnit);
            return dlg.open();
        }
        return 0;
    }

    private SourceManipulator createSourceManipulator(ICompilationUnit compUnit, Configuration config, boolean showPreview) {
        SourceManipulator sm = new SourceManipulator(compUnit, config);
        sm.setShowPreview(showPreview);
        return sm;
    }

    private IRunnableWithProgress createTask(final SourceManipulator sm, final ICompilationUnit compUnit, final Configuration config) {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    try {
                        AbstractEAD.this.doRun(sm, compUnit, config, monitor);
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
    }

    private IRunnableContext createRunnableContext(boolean showPreview) {
        return showPreview ? new TimeTriggeredProgressMonitorDialog(this.getShell(), 800) : new ProgressMonitorDialog(this.getShell());
    }

    private int runTask(IRunnableWithProgress task, SourceManipulator sm, ICompilationUnit compUnit, boolean showPreview) {
        int rc = 0;
        try {
            this.createRunnableContext(showPreview).run(false, true, task);
            if (showPreview) {
                rc = this.showPreview(compUnit, (TextEdit)sm.getChanges(), sm.getChangeDescriptions());
            }
        }
        catch (InvocationTargetException e) {
            JAutodocPlugin.getDefault().handleException(this.getShell(), compUnit, e.getTargetException());
        }
        catch (InterruptedException e) {
            JAutodocPlugin.getDefault().handleException((IJavaElement)compUnit, (Throwable)e);
        }
        return rc;
    }

    private int showPreview(ICompilationUnit cu, TextEdit te, Map<TextEdit, String> changeDescriptions) throws InterruptedException {
        CompilationUnitRefactoring refactoring = new CompilationUnitRefactoring(cu, te, changeDescriptions);
        CompilationUnitRefactoringWizard wizard = new CompilationUnitRefactoringWizard(refactoring);
        RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
        return op.run(this.getShell(), "JAutodoc");
    }
}

