/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.parser.custom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.emf.ui.services.parser.ISemanticParser;
import org.eclipse.papyrus.uml.diagram.activity.parsers.MessageFormatParser;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.UMLPackage;

public abstract class AssociatedBehaviorParser
extends MessageFormatParser
implements ISemanticParser {
    public AssociatedBehaviorParser(EAttribute[] features, EAttribute[] editableFeatures) {
        super(features, editableFeatures);
    }

    public AssociatedBehaviorParser(EAttribute[] features) {
        super(features);
    }

    public AssociatedBehaviorParser() {
        super(new EAttribute[]{UMLPackage.eINSTANCE.getNamedElement_Name()});
    }

    protected EStructuralFeature getEStructuralFeature(Object notification) {
        Object feature;
        EStructuralFeature featureImpl = null;
        if (notification instanceof Notification && (feature = ((Notification)notification).getFeature()) instanceof EStructuralFeature) {
            featureImpl = (EStructuralFeature)feature;
        }
        return featureImpl;
    }

    @Override
    public boolean isAffectingEvent(Object event, int flags) {
        EStructuralFeature feature = this.getEStructuralFeature(event);
        return this.isValidFeature(feature);
    }

    @Override
    public String getEditString(IAdaptable adapter, int flags) {
        String value = this.getValueString(adapter, flags);
        if (value != null) {
            return value;
        }
        return "";
    }

    @Override
    public ICommand getParseCommand(IAdaptable adapter, String newString, int flags) {
        Object behavior;
        Object obj = adapter.getAdapter(EObject.class);
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((Object)obj);
        if (editingDomain == null) {
            return UnexecutableCommand.INSTANCE;
        }
        if (this.getReferenceFeature().getContainerClass().isInstance(obj) && (behavior = ((EObject)obj).eGet(this.getReferenceFeature())) instanceof Behavior) {
            return this.getModificationCommand((EObject)behavior, UMLPackage.eINSTANCE.getNamedElement_Name(), newString);
        }
        return UnexecutableCommand.INSTANCE;
    }

    @Override
    public String getPrintString(IAdaptable element, int flags) {
        String label = this.getValueString(element, flags);
        label = label == null || label.length() == 0 ? "" : String.format(this.getFormatString(), label);
        return label;
    }

    protected abstract String getFormatString();

    private String getValueString(IAdaptable element, int flags) {
        Object behavior;
        Object obj = element.getAdapter(EObject.class);
        if (this.getReferenceFeature().getContainerClass().isInstance(obj) && (behavior = ((EObject)obj).eGet(this.getReferenceFeature())) instanceof Behavior) {
            return ((Behavior)behavior).getName();
        }
        return "";
    }

    public boolean areSemanticElementsAffected(EObject listener, Object notification) {
        EStructuralFeature feature = this.getEStructuralFeature(notification);
        return this.isValidFeature(feature);
    }

    public List<?> getSemanticElementsBeingParsed(EObject element) {
        ArrayList<Element> semanticElementsBeingParsed = new ArrayList<Element>();
        if (this.getReferenceFeature().getContainerClass().isInstance(element)) {
            semanticElementsBeingParsed.add((Element)element);
            Object behavior = element.eGet(this.getReferenceFeature());
            if (behavior instanceof Behavior) {
                semanticElementsBeingParsed.add((Element)behavior);
            }
        }
        return semanticElementsBeingParsed;
    }

    private boolean isValidFeature(EStructuralFeature feature) {
        return this.getReferenceFeature().equals(feature) || UMLPackage.eINSTANCE.getNamedElement_Name().equals(feature);
    }

    protected abstract EStructuralFeature getReferenceFeature();
}

