/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layers.stackmodel.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.layers.stackmodel.util.DiagramViewToListSynchronizer;
import org.eclipse.papyrus.layers.stackmodel.util.NotationAndUmlModelsFactory;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.NamedElement;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DiagramViewToListSynchronizerTest {
    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testDiagramViewToListSynchronizer() {
        NotationAndUmlModelsFactory factory = new NotationAndUmlModelsFactory();
        Diagram diagram1 = factory.newDiagram();
        ArrayList<View> list = new ArrayList<View>();
        DiagramViewToListSynchronizer listSynchronizer = new DiagramViewToListSynchronizer(diagram1, list);
        Assert.assertNotNull((String)"object created", (Object)listSynchronizer);
    }

    @Test
    public void testSetDiagram() {
        NotationAndUmlModelsFactory factory = new NotationAndUmlModelsFactory();
        Diagram diagram1 = factory.newDiagram();
        Class C1 = factory.newClass(diagram1, "C1");
        View shape1 = factory.lookupViewFor(diagram1, (NamedElement)C1);
        Class C2 = factory.newClass(diagram1, "C2");
        View shape2 = factory.lookupViewFor(diagram1, (NamedElement)C2);
        Class C3 = factory.newClass(diagram1, "C3");
        View shape3 = factory.lookupViewFor(diagram1, (NamedElement)C3);
        ArrayList expectedViews1 = Lists.newArrayList((Object[])new View[]{shape1, shape2, shape3});
        ArrayList<View> list = new ArrayList<View>();
        DiagramViewToListSynchronizer listSynchronizer = new DiagramViewToListSynchronizer(diagram1, list);
        int expectedSize = 3;
        Assert.assertEquals((String)"list size", (long)expectedSize, (long)list.size());
        Assert.assertTrue((String)"list correctly set", (boolean)list.containsAll(expectedViews1));
        Diagram diagram2 = factory.newDiagram();
        Class C21 = factory.newClass(diagram2, "C1");
        View shape21 = factory.lookupViewFor(diagram2, (NamedElement)C21);
        Class C22 = factory.newClass(diagram2, "C2");
        View shape22 = factory.lookupViewFor(diagram2, (NamedElement)C22);
        Class C23 = factory.newClass(diagram2, "C3");
        View shape23 = factory.lookupViewFor(diagram2, (NamedElement)C23);
        ArrayList expectedViews2 = Lists.newArrayList((Object[])new View[]{shape21, shape22, shape23});
        int expectedSize2 = 3;
        listSynchronizer.setDiagram(diagram2);
        Assert.assertEquals((String)"list size", (long)expectedSize2, (long)list.size());
        Assert.assertTrue((String)"list correctly set", (boolean)list.containsAll(expectedViews2));
    }

    @Test
    public void testSyncWhenViewIsAdded() {
        NotationAndUmlModelsFactory factory = new NotationAndUmlModelsFactory();
        Diagram diagram1 = factory.newDiagram();
        int expectedSize = 1;
        ArrayList<View> list = new ArrayList<View>();
        DiagramViewToListSynchronizer listSynchronizer = new DiagramViewToListSynchronizer(diagram1, list);
        Class C1 = factory.newClass(diagram1, "C1");
        View shape1 = factory.lookupViewFor(diagram1, (NamedElement)C1);
        Assert.assertEquals((String)"listSize", (long)expectedSize, (long)list.size());
        Assert.assertTrue((String)"list contain expected view", (boolean)list.contains(shape1));
    }

    @Test
    public void testSyncWhenViewIsRemoved() {
        NotationAndUmlModelsFactory factory = new NotationAndUmlModelsFactory();
        Diagram diagram1 = factory.newDiagram();
        int expectedSize = 3;
        ArrayList<View> list = new ArrayList<View>();
        DiagramViewToListSynchronizer listSynchronizer = new DiagramViewToListSynchronizer(diagram1, list);
        Class C1 = factory.newClass(diagram1, "C1");
        View shape1 = factory.lookupViewFor(diagram1, (NamedElement)C1);
        Class C2 = factory.newClass(diagram1, "C2");
        View shape2 = factory.lookupViewFor(diagram1, (NamedElement)C2);
        Class C3 = factory.newClass(diagram1, "C3");
        View shape3 = factory.lookupViewFor(diagram1, (NamedElement)C3);
        Assert.assertEquals((String)"listSize", (long)expectedSize, (long)list.size());
        Assert.assertTrue((String)"list contain expected view", (boolean)list.contains(shape2));
        factory.remove(diagram1, (NamedElement)C2);
        Assert.assertEquals((String)"listSize", (long)(expectedSize - 1), (long)list.size());
        Assert.assertFalse((String)"list contain expected view", (boolean)list.contains(shape2));
    }
}

