/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layers.stackmodel.util;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.layers.stackmodel.notifier.DiagramViewChangedEventNotifier;
import org.eclipse.papyrus.layers.stackmodel.notifier.DiagramViewChangedEventNotifierFactory;
import org.eclipse.papyrus.layers.stackmodel.notifier.IDiagramViewEventListener;
import org.eclipse.papyrus.layers.stackmodel.util.LayerDiagramViewPredicate;

public class DiagramViewToListSynchronizer {
    protected Diagram diagram;
    protected Collection<View> synchronizedList;
    private IDiagramViewEventListener viewEventListener = new IDiagramViewEventListener(){

        @Override
        public void diagramViewRemoved(Notification msg) {
            DiagramViewToListSynchronizer.this.synchronizedList.remove((View)msg.getOldValue());
        }

        @Override
        public void diagramViewAdded(Notification msg) {
            View view = (View)msg.getNewValue();
            if (DiagramViewToListSynchronizer.this.synchronizedList.contains(view)) {
                return;
            }
            DiagramViewToListSynchronizer.this.synchronizedList.add(view);
        }
    };

    public DiagramViewToListSynchronizer(Diagram diagram, Collection<View> synchronizedList) {
        this.synchronizedList = synchronizedList;
        this.setDiagram(diagram);
    }

    public DiagramViewToListSynchronizer(Collection<View> synchronizedList) {
        this.synchronizedList = synchronizedList;
    }

    public void setDiagram(Diagram diagram) {
        DiagramViewChangedEventNotifier notifier;
        Diagram oldDiagram = this.diagram;
        if (oldDiagram != null) {
            notifier = DiagramViewChangedEventNotifierFactory.instance.adapt((Notifier)oldDiagram);
            notifier.removeEventListener(this.viewEventListener);
        }
        this.synchronizedList.clear();
        Iterable filteredList = Iterables.filter((Iterable)diagram.getChildren(), (Predicate)LayerDiagramViewPredicate.instance);
        for (View view : filteredList) {
            this.synchronizedList.add(view);
        }
        this.diagram = diagram;
        if (diagram != null) {
            notifier = DiagramViewChangedEventNotifierFactory.instance.adapt((Notifier)diagram);
            notifier.addEventListener(this.viewEventListener);
        }
    }
}

