/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layers.stackmodel.layers.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.papyrus.layers.stackmodel.LayersException;
import org.eclipse.papyrus.layers.stackmodel.layers.Layer;
import org.eclipse.papyrus.layers.stackmodel.layers.LayerExpression;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersFactory;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersFactoryForStack;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersStack;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersStackApplication;
import org.eclipse.papyrus.layers.stackmodel.layers.TopLayerOperator;

public class LayersFactoryForStackTestUtils {
    protected LayersStackApplication application;
    protected LayersStack stack;
    protected LayersFactoryForStack factory;
    protected Map<String, LayerExpression> createdLayers = new HashMap<String, LayerExpression>();

    public LayersFactoryForStackTestUtils(LayersStack stack, LayersFactoryForStack factory, LayersStackApplication application) {
        this.stack = stack;
        this.factory = factory;
        this.application = application;
    }

    public LayersFactoryForStackTestUtils(LayersStack stack, LayersStackApplication application) {
        this.stack = stack;
        this.factory = LayersFactoryForStack.eINSTANCE;
        this.application = application;
    }

    public Map<String, LayerExpression> getCreatedLayers() {
        return this.createdLayers;
    }

    public LayerExpression getLayer(String name) {
        return this.createdLayers.get(name);
    }

    public TopLayerOperator newTopLayer() throws LayersException {
        TopLayerOperator layer = this.factory.createTopLayerOperator(this.stack, this.stack, this.application);
        return layer;
    }

    public TopLayerOperator newTopLayer(String name) throws LayersException {
        TopLayerOperator layer = this.newTopLayer();
        this.createdLayers.put(name, layer);
        return layer;
    }

    public TopLayerOperator newTopLayer(String name, LayerExpression ... exprs) throws LayersException {
        TopLayerOperator layer = this.newTopLayer(exprs);
        this.createdLayers.put(name, layer);
        return layer;
    }

    public TopLayerOperator newTopLayer(LayerExpression ... exprs) throws LayersException {
        TopLayerOperator layer = this.newTopLayer();
        LayerExpression[] layerExpressionArray = exprs;
        int n = exprs.length;
        int n2 = 0;
        while (n2 < n) {
            LayerExpression l = layerExpressionArray[n2];
            this.factory.initLayer(l, layer, this.stack, this.application);
            ++n2;
        }
        return layer;
    }

    public LayerExpression newLayer() {
        Layer layer = LayersFactory.eINSTANCE.createLayer();
        return layer;
    }

    public LayerExpression newLayer(String name) {
        LayerExpression layer = this.newLayer();
        this.createdLayers.put(name, layer);
        return layer;
    }
}

