/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layers.stackmodel.layers.impl;

import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.layers.configmodel.layersconfig.Folder;
import org.eclipse.papyrus.layers.configmodel.layersconfig.LayerOperatorConfig;
import org.eclipse.papyrus.layers.configmodel.layersconfig.LayerOperatorMultipleBinding;
import org.eclipse.papyrus.layers.configmodel.layersconfig.OperatorConfig;
import org.eclipse.papyrus.layers.configmodel.layersconfig.PropertyId;
import org.eclipse.papyrus.layers.configmodel.layersconfig.TypeConfig;
import org.eclipse.papyrus.layers.stackmodel.LayersException;
import org.eclipse.papyrus.layers.stackmodel.command.ComputePropertyValueCommand;
import org.eclipse.papyrus.layers.stackmodel.layers.Layer;
import org.eclipse.papyrus.layers.stackmodel.layers.LayerOperator;
import org.eclipse.papyrus.layers.stackmodel.layers.LayerOperatorDescriptorRegistry;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersFactory;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersPackage;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersStackApplication;
import org.eclipse.papyrus.layers.stackmodel.layers.Property;
import org.eclipse.papyrus.layers.stackmodel.layers.PropertyRegistry;
import org.eclipse.papyrus.layers.stackmodel.layers.StackedLayerOperator;
import org.eclipse.papyrus.layers.stackmodel.layers.impl.FakeOperator;
import org.eclipse.papyrus.layers.stackmodel.layers.loaders.LayersConfigModel;
import org.eclipse.papyrus.layers.stackmodel.layers.loaders.LayersConfigModelUtils;
import org.eclipse.papyrus.layers.stackmodel.layers.loaders.RegistriesLoader;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StackedLayerOperatorImplGetComputePropertyCommandTest {
    private static final String FAKE_STACKED_LAYERS_OPERATOR_NAME = "FakeStackedLayersOperator";

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testStackedLayerOperatorImpl() throws LayersException {
        LayersStackApplication application = LayersFactory.eINSTANCE.createLayersStackApplication();
        PropertyRegistry propertyRegistry = application.getPropertyRegistry();
        LayerOperatorDescriptorRegistry layerOperatorDescriptorRegistry = application.getLayerOperatorDescriptorRegistry();
        LayersConfigModel model = new LayersConfigModel();
        this.initLayersConfigWithTestStackedOperator(model, propertyRegistry);
        RegistriesLoader loader = new RegistriesLoader(model);
        loader.loadLayerOperatorDescriptorRegistry(layerOperatorDescriptorRegistry, propertyRegistry);
        StackedLayerOperator layer = (StackedLayerOperator)layerOperatorDescriptorRegistry.getLayerOperatorDescriptor(FAKE_STACKED_LAYERS_OPERATOR_NAME).createLayerOperator();
        layer.setApplication(application);
        Assert.assertNotNull((String)"object created", (Object)layer);
    }

    @Test
    public void testGetComputePropertyValueCommand() throws LayersException {
        LayersStackApplication application = LayersFactory.eINSTANCE.createLayersStackApplication();
        PropertyRegistry propertyRegistry = application.getPropertyRegistry();
        LayerOperatorDescriptorRegistry layerOperatorDescriptorRegistry = application.getLayerOperatorDescriptorRegistry();
        LayersConfigModel model = new LayersConfigModel();
        this.initLayersConfigWithTestStackedOperator(model, propertyRegistry);
        RegistriesLoader loader = new RegistriesLoader(model);
        loader.loadLayerOperatorDescriptorRegistry(layerOperatorDescriptorRegistry, propertyRegistry);
        StackedLayerOperator layer = (StackedLayerOperator)layerOperatorDescriptorRegistry.getLayerOperatorDescriptor(FAKE_STACKED_LAYERS_OPERATOR_NAME).createLayerOperator();
        layer.setApplication(application);
        Shape view1 = NotationFactory.eINSTANCE.createShape();
        Shape view2 = NotationFactory.eINSTANCE.createShape();
        Shape view3 = NotationFactory.eINSTANCE.createShape();
        int index = 0;
        Property property1 = (Property)propertyRegistry.getProperties().get(index++);
        Property property2 = (Property)propertyRegistry.getProperties().get(index++);
        Property property3 = (Property)propertyRegistry.getProperties().get(index++);
        Layer layer1 = this.createLayer(layer, Arrays.asList(view1), Arrays.asList(property1));
        Layer layer2 = this.createLayer(layer, Arrays.asList(view1, view2), Arrays.asList(property1, property2));
        Layer layer3 = this.createLayer(layer, Arrays.asList(view3), Arrays.asList(property2, property3));
        ComputePropertyValueCommand cmd = layer.getComputePropertyValueCommand((View)view2, property1);
        Assert.assertNotNull((String)"cmd created", (Object)cmd);
        Assert.assertTrue((String)"cmd is of Fake type", (boolean)(cmd instanceof FakeOperator.FakeCommand));
        Assert.assertSame((String)"cmd has 1 sub command", (Object)1, (Object)((FakeOperator.FakeCommand)cmd).nestedCommand.size());
        cmd = layer.getComputePropertyValueCommand((View)view1, property1);
        Assert.assertNotNull((String)"cmd created", (Object)cmd);
        Assert.assertTrue((String)"cmd is of Fake type", (boolean)(cmd instanceof FakeOperator.FakeCommand));
        Assert.assertSame((String)"cmd has 1 sub command", (Object)2, (Object)((FakeOperator.FakeCommand)cmd).nestedCommand.size());
        cmd = layer.getComputePropertyValueCommand((View)view3, property1);
        Assert.assertNull((String)"cmd is null", (Object)cmd);
    }

    @Test
    public void testGetViewsComputePropertyValueCommandListOfViewProperty() throws LayersException {
        LayersStackApplication application = LayersFactory.eINSTANCE.createLayersStackApplication();
        PropertyRegistry propertyRegistry = application.getPropertyRegistry();
        LayerOperatorDescriptorRegistry layerOperatorDescriptorRegistry = application.getLayerOperatorDescriptorRegistry();
        LayersConfigModel model = new LayersConfigModel();
        this.initLayersConfigWithTestStackedOperator(model, propertyRegistry);
        RegistriesLoader loader = new RegistriesLoader(model);
        loader.loadLayerOperatorDescriptorRegistry(layerOperatorDescriptorRegistry, propertyRegistry);
        StackedLayerOperator layer = (StackedLayerOperator)layerOperatorDescriptorRegistry.getLayerOperatorDescriptor(FAKE_STACKED_LAYERS_OPERATOR_NAME).createLayerOperator();
        layer.setApplication(application);
        Shape view1 = NotationFactory.eINSTANCE.createShape();
        Shape view2 = NotationFactory.eINSTANCE.createShape();
        Shape view3 = NotationFactory.eINSTANCE.createShape();
        Shape view4 = NotationFactory.eINSTANCE.createShape();
        int index = 0;
        Property property1 = (Property)propertyRegistry.getProperties().get(index++);
        Property property2 = (Property)propertyRegistry.getProperties().get(index++);
        Property property3 = (Property)propertyRegistry.getProperties().get(index++);
        Property property4 = (Property)propertyRegistry.getProperties().get(index++);
        Layer layer1 = this.createLayer(layer, Arrays.asList(view1), Arrays.asList(property1));
        Layer layer2 = this.createLayer(layer, Arrays.asList(view1, view2), Arrays.asList(property1, property2));
        Layer layer3 = this.createLayer(layer, Arrays.asList(view2, view3), Arrays.asList(property2, property3));
        EList<ComputePropertyValueCommand> cmds = layer.getViewsComputePropertyValueCommand(Arrays.asList(view1, view2), property1);
        Assert.assertNotNull((String)"cmd created", cmds);
        Assert.assertSame((String)"cmd size is equals to views size", (Object)2, (Object)cmds.size());
        int i = 0;
        Assert.assertTrue((String)"cmd is of Fake type", (boolean)(cmds.get(i) instanceof FakeOperator.FakeCommand));
        Assert.assertSame((String)"cmd has 1 sub command", (Object)2, (Object)((FakeOperator.FakeCommand)cmds.get((int)i)).nestedCommand.size());
        Assert.assertTrue((String)"cmd is of Fake type", (boolean)(cmds.get(++i) instanceof FakeOperator.FakeCommand));
        Assert.assertSame((String)"cmd has 1 sub command", (Object)1, (Object)((FakeOperator.FakeCommand)cmds.get((int)i)).nestedCommand.size());
        cmds = layer.getViewsComputePropertyValueCommand(Arrays.asList(view1, view3), property3);
        Assert.assertNotNull((String)"cmd created", cmds);
        Assert.assertSame((String)"cmd size is equals to views size", (Object)2, (Object)cmds.size());
        i = 0;
        Assert.assertSame((String)"cmd is null", null, cmds.get(i++));
        Assert.assertTrue((String)"cmd is of Fake type", (boolean)(cmds.get(i) instanceof FakeOperator.FakeCommand));
        Assert.assertSame((String)"cmd has 1 sub command", (Object)1, (Object)((FakeOperator.FakeCommand)cmds.get((int)i)).nestedCommand.size());
        cmds = layer.getViewsComputePropertyValueCommand(Arrays.asList(view4), property3);
        Assert.assertNull((String)"cmd created", cmds);
        cmds = layer.getViewsComputePropertyValueCommand(Arrays.asList(view1, view2), property4);
        Assert.assertNull((String)"cmd created", cmds);
        cmds = layer.getViewsComputePropertyValueCommand(Arrays.asList(view1, null, view3), property1);
        Assert.assertNotNull((String)"cmd created", cmds);
        Assert.assertSame((String)"cmd size is equals to views size", (Object)3, (Object)cmds.size());
        i = 0;
        Assert.assertTrue((String)"cmd is of Fake type", (boolean)(cmds.get(i++) instanceof FakeOperator.FakeCommand));
        Assert.assertSame((String)"cmd is null", null, cmds.get(i++));
        Assert.assertSame((String)"cmd is null", null, cmds.get(i++));
    }

    @Test
    public void testGetPropertiesComputePropertyValueCommandViewListOfProperty() throws LayersException {
        LayersStackApplication application = LayersFactory.eINSTANCE.createLayersStackApplication();
        PropertyRegistry propertyRegistry = application.getPropertyRegistry();
        LayerOperatorDescriptorRegistry layerOperatorDescriptorRegistry = application.getLayerOperatorDescriptorRegistry();
        LayersConfigModel model = new LayersConfigModel();
        this.initLayersConfigWithTestStackedOperator(model, propertyRegistry);
        RegistriesLoader loader = new RegistriesLoader(model);
        loader.loadLayerOperatorDescriptorRegistry(layerOperatorDescriptorRegistry, propertyRegistry);
        StackedLayerOperator layer = (StackedLayerOperator)layerOperatorDescriptorRegistry.getLayerOperatorDescriptor(FAKE_STACKED_LAYERS_OPERATOR_NAME).createLayerOperator();
        layer.setApplication(application);
        Shape view1 = NotationFactory.eINSTANCE.createShape();
        Shape view2 = NotationFactory.eINSTANCE.createShape();
        Shape view3 = NotationFactory.eINSTANCE.createShape();
        Shape view4 = NotationFactory.eINSTANCE.createShape();
        int index = 0;
        Property property1 = (Property)propertyRegistry.getProperties().get(index++);
        Property property2 = (Property)propertyRegistry.getProperties().get(index++);
        Property property3 = (Property)propertyRegistry.getProperties().get(index++);
        Property property4 = (Property)propertyRegistry.getProperties().get(index++);
        Layer layer1 = this.createLayer(layer, Arrays.asList(view1), Arrays.asList(property1));
        Layer layer2 = this.createLayer(layer, Arrays.asList(view1, view2), Arrays.asList(property1, property2));
        Layer layer3 = this.createLayer(layer, Arrays.asList(view2, view3), Arrays.asList(property3));
        EList<ComputePropertyValueCommand> cmds = layer.getPropertiesComputePropertyValueCommand((View)view1, Arrays.asList(property1, property2));
        Assert.assertNotNull((String)"cmd created", cmds);
        Assert.assertSame((String)"cmd size is equals to views size", (Object)2, (Object)cmds.size());
        int i = 0;
        Assert.assertTrue((String)"cmd is of Fake type", (boolean)(cmds.get(i) instanceof FakeOperator.FakeCommand));
        Assert.assertSame((String)"cmd has 1 sub command", (Object)2, (Object)((FakeOperator.FakeCommand)cmds.get((int)i)).nestedCommand.size());
        Assert.assertTrue((String)"cmd is of Fake type", (boolean)(cmds.get(++i) instanceof FakeOperator.FakeCommand));
        Assert.assertSame((String)"cmd has 1 sub command", (Object)1, (Object)((FakeOperator.FakeCommand)cmds.get((int)i)).nestedCommand.size());
        cmds = layer.getPropertiesComputePropertyValueCommand((View)view2, Arrays.asList(property1, property4));
        Assert.assertNotNull((String)"cmd created", cmds);
        Assert.assertSame((String)"cmd size is equals to views size", (Object)2, (Object)cmds.size());
        i = 0;
        Assert.assertTrue((String)"cmd is of Fake type", (boolean)(cmds.get(i++) instanceof FakeOperator.FakeCommand));
        Assert.assertSame((String)"cmd is the property instance", null, cmds.get(i++));
        cmds = layer.getPropertiesComputePropertyValueCommand((View)view4, Arrays.asList(property3));
        Assert.assertNull((String)"cmd created", cmds);
        cmds = layer.getPropertiesComputePropertyValueCommand((View)view3, Arrays.asList(property1, property2));
        Assert.assertNull((String)"cmd created", cmds);
        cmds = layer.getPropertiesComputePropertyValueCommand((View)view1, Arrays.asList(property1, null, property2));
        Assert.assertNotNull((String)"cmd created", cmds);
        Assert.assertSame((String)"cmd size is equals to views size", (Object)3, (Object)cmds.size());
        i = 0;
        Assert.assertTrue((String)"cmd is of Fake type", (boolean)(cmds.get(i++) instanceof FakeOperator.FakeCommand));
        Assert.assertSame((String)"cmd is null", null, cmds.get(i++));
        Assert.assertTrue((String)"cmd is of Fake type", (boolean)(cmds.get(i++) instanceof FakeOperator.FakeCommand));
    }

    protected Layer createLayer(LayerOperator parent, List<View> views, List<Property> properties) throws LayersException {
        Layer layer = LayersFactory.eINSTANCE.createLayer();
        layer.setApplication(parent.getApplication());
        parent.getLayers().add((Object)layer);
        for (View view : views) {
            layer.getViews().add((Object)view);
        }
        for (Property property : properties) {
            layer.addPropertyInstance(property);
        }
        return layer;
    }

    private void initLayersConfigWithTestStackedOperator(LayersConfigModel model, PropertyRegistry propertyRegistry) {
        Folder layeropFolder = LayersConfigModelUtils.createFolder(model.getRootFolder(), "layerOpDesc");
        LayerOperatorConfig fakeLayerOp = LayersConfigModelUtils.createLayerOperatorConfig(layeropFolder, FAKE_STACKED_LAYERS_OPERATOR_NAME, LayersPackage.eINSTANCE.getStackedLayerOperatorDescriptor().getName());
        Folder operatorFolder = LayersConfigModelUtils.createFolder(model.getRootFolder(), "operatorDesc");
        OperatorConfig operator = LayersConfigModelUtils.createPropertyOperatorConfig(operatorFolder, "FakeOperator", FakeOperator.class.getName());
        Folder typeFolder = LayersConfigModelUtils.createFolder(model.getRootFolder(), "types");
        TypeConfig typeBoolean = LayersConfigModelUtils.createTypeConfig(typeFolder, "boolean");
        Folder propertiesFolder = LayersConfigModelUtils.createFolder(model.getRootFolder(), "properties");
        int index = 0;
        PropertyId property1 = LayersConfigModelUtils.createPropertyId(propertiesFolder, ((Property)propertyRegistry.getProperties().get(index++)).getName(), typeBoolean);
        PropertyId property2 = LayersConfigModelUtils.createPropertyId(propertiesFolder, ((Property)propertyRegistry.getProperties().get(index++)).getName(), typeBoolean);
        PropertyId property3 = LayersConfigModelUtils.createPropertyId(propertiesFolder, ((Property)propertyRegistry.getProperties().get(index++)).getName(), typeBoolean);
        Folder opBindingFolder = LayersConfigModelUtils.createFolder(model.getRootFolder(), "opBindings");
        LayerOperatorMultipleBinding layerOpBindingsA = LayersConfigModelUtils.createLayerOperatorsMultipleBinding(opBindingFolder, fakeLayerOp);
        LayersConfigModelUtils.createOperatorBinding(layerOpBindingsA, property1, operator);
        LayersConfigModelUtils.createOperatorBinding(layerOpBindingsA, property2, operator);
        LayersConfigModelUtils.createOperatorBinding(layerOpBindingsA, property3, operator);
    }
}

