/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layers.stackmodel.layers.impl;

import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.papyrus.layers.stackmodel.NotFoundException;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersFactory;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersStack;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersStackApplication;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LayersStackApplicationImplTest {
    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testLayersStackApplicationImpl() {
        LayersStackApplication application = LayersFactory.eINSTANCE.createLayersStackApplication();
        Assert.assertNotNull((String)"instance created", (Object)application);
    }

    @Test
    public void testInit() {
        LayersStackApplication application = LayersFactory.eINSTANCE.createLayersStackApplication();
        Assert.assertNotNull((String)"propertyRegistry created", (Object)application.getPropertyRegistry());
        Assert.assertNotNull((String)"layerDescriptorRegistry created", (Object)application.getLayerDescriptorRegistry());
        Assert.assertNotNull((String)"propertySetterRegistry  created", (Object)application.getPropertySetterRegistry());
        Assert.assertNotNull((String)"LayerOperatorDescriptorRegistry  created", (Object)application.getLayerOperatorDescriptorRegistry());
    }

    @Test
    public void testGetLayersStacks() {
        LayersStackApplication application = LayersFactory.eINSTANCE.createLayersStackApplication();
        Assert.assertNotNull((String)"stacks list created", application.getLayersStacks());
    }

    @Test
    public void testGetPropertyRegistry() {
        LayersStackApplication application = LayersFactory.eINSTANCE.createLayersStackApplication();
        Assert.assertNotNull((String)"propertyRegistry created", (Object)application.getPropertyRegistry());
    }

    @Test
    public void testGetLayerDescriptorRegistry() {
        LayersStackApplication application = LayersFactory.eINSTANCE.createLayersStackApplication();
        Assert.assertNotNull((String)"layerDescriptorRegistry created", (Object)application.getLayerDescriptorRegistry());
    }

    @Test
    public void testRemoveLayersStackFor() {
        LayersStackApplication application = LayersFactory.eINSTANCE.createLayersStackApplication();
        Diagram diagram = NotationFactory.eINSTANCE.createDiagram();
        application.getLayersStackFor(diagram);
        Diagram diagram2 = NotationFactory.eINSTANCE.createDiagram();
        LayersStack stack2 = application.getLayersStackFor(diagram2);
        application.removeLayersStackFor(diagram);
        Assert.assertFalse((String)"stack is detached", (boolean)application.isLayersStackAttachedFor(diagram));
        Assert.assertTrue((String)"stack is attached", (boolean)application.isLayersStackAttachedFor(diagram2));
        Assert.assertSame((String)"get found previous stack", (Object)stack2, (Object)application.getLayersStackFor(diagram2));
    }

    @Test
    public void testIsLayersStackAttachedFor() {
        LayersStackApplication application = LayersFactory.eINSTANCE.createLayersStackApplication();
        Diagram diagram = NotationFactory.eINSTANCE.createDiagram();
        Assert.assertFalse((String)"no stack is found", (boolean)application.isLayersStackAttachedFor(diagram));
        LayersStack stack = application.getLayersStackFor(diagram);
        Assert.assertNotNull((String)"stack is created", (Object)stack);
        Assert.assertTrue((String)"stack is attached", (boolean)application.isLayersStackAttachedFor(diagram));
    }

    @Test
    public void testLookupLayersStackFor() throws NotFoundException {
        LayersStackApplication application = LayersFactory.eINSTANCE.createLayersStackApplication();
        Diagram diagram = NotationFactory.eINSTANCE.createDiagram();
        try {
            application.lookupLayersStackFor(diagram);
            Assert.fail((String)"An NotFoundException should be throw");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        LayersStack stack = application.getLayersStackFor(diagram);
        Assert.assertNotNull((String)"stack is created", (Object)stack);
        Assert.assertSame((String)"lookup found stack", (Object)stack, (Object)application.lookupLayersStackFor(diagram));
    }

    @Test
    public void testGetLayersStackFor() {
        LayersStackApplication application = LayersFactory.eINSTANCE.createLayersStackApplication();
        Diagram diagram = NotationFactory.eINSTANCE.createDiagram();
        LayersStack stack = application.getLayersStackFor(diagram);
        Assert.assertNotNull((String)"stack is created", (Object)stack);
        Diagram diagram2 = NotationFactory.eINSTANCE.createDiagram();
        LayersStack stack2 = application.getLayersStackFor(diagram2);
        Assert.assertNotNull((String)"stack is created", (Object)stack2);
        Assert.assertSame((String)"get found previuous stack", (Object)stack, (Object)application.getLayersStackFor(diagram));
        Assert.assertSame((String)"get found previuous stack", (Object)stack2, (Object)application.getLayersStackFor(diagram2));
    }

    @Test
    public void testCreateLayersStackFor() {
        LayersStackApplication application = LayersFactory.eINSTANCE.createLayersStackApplication();
        Diagram diagram = NotationFactory.eINSTANCE.createDiagram();
        LayersStack stack = application.createLayersStackFor(diagram);
        Assert.assertNotNull((String)"stack is created", (Object)stack);
    }
}

