/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layers.stackmodel.layers.impl;

import org.eclipse.papyrus.layers.stackmodel.NotFoundException;
import org.eclipse.papyrus.layers.stackmodel.layers.DefaultPropertyOperator;
import org.eclipse.papyrus.layers.stackmodel.layers.LayerOperatorDescriptor;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersFactory;
import org.eclipse.papyrus.layers.stackmodel.layers.Property;
import org.eclipse.papyrus.layers.stackmodel.layers.PropertyOperator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class LayerOperatorDescriptorImplTest {
    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    protected PropertyOperator createOperator(String name) {
        PropertyOperator propertyOperator = LayersFactory.eINSTANCE.createPropertyOperator();
        propertyOperator.setName(name);
        return propertyOperator;
    }

    protected Property createProperty(String name, int index) {
        Property property = LayersFactory.eINSTANCE.createProperty();
        property.setName(name);
        property.setIndex(index);
        return property;
    }

    @Test
    public void testGetPropertyOperator() throws NotFoundException {
        int expectedSize = 5;
        DefaultPropertyOperator defaultPropertyOperator = LayersFactory.eINSTANCE.createDefaultPropertyOperator();
        LayerOperatorDescriptor descriptor = LayersFactory.eINSTANCE.createLayerOperatorDescriptor();
        descriptor.setPropertyCollectionSize(expectedSize, defaultPropertyOperator);
        int i = 0;
        Property property1 = this.createProperty("prop" + i, i++);
        Property property2 = this.createProperty("prop" + i, i++);
        Property property4 = this.createProperty("prop4", 4);
        i = 0;
        PropertyOperator operator1 = this.createOperator("oper" + i++);
        PropertyOperator operator2 = this.createOperator("oper" + i++);
        PropertyOperator operator4 = this.createOperator("oper4");
        descriptor.setPropertyOperator(property1, operator1);
        descriptor.setPropertyOperator(property2, operator2);
        descriptor.setPropertyOperator(property4, operator4);
        Assert.assertSame((String)"operators size has not changed", (Object)expectedSize, (Object)descriptor.getPropertyOperators().size());
        Assert.assertSame((String)"operator can be found", (Object)operator1, (Object)descriptor.getPropertyOperator(property1));
        Assert.assertSame((String)"operator can be found", (Object)operator2, (Object)descriptor.getPropertyOperator(property2));
        Assert.assertSame((String)"operator can be found", (Object)operator4, (Object)descriptor.getPropertyOperator(property4));
    }

    @Test
    public void testSetPropertyOperator() throws NotFoundException {
        int expectedSize = 5;
        DefaultPropertyOperator defaultPropertyOperator = LayersFactory.eINSTANCE.createDefaultPropertyOperator();
        LayerOperatorDescriptor descriptor = LayersFactory.eINSTANCE.createLayerOperatorDescriptor();
        descriptor.setPropertyCollectionSize(expectedSize, defaultPropertyOperator);
        int i = 0;
        Property property1 = this.createProperty("prop" + i, i++);
        Property property2 = this.createProperty("prop" + i, i++);
        Property property4 = this.createProperty("prop4", 4);
        i = 0;
        PropertyOperator operator1 = this.createOperator("oper" + i++);
        PropertyOperator operator2 = this.createOperator("oper" + i++);
        PropertyOperator operator4 = this.createOperator("oper4");
        descriptor.setPropertyOperator(property1, operator1);
        descriptor.setPropertyOperator(property2, operator2);
        descriptor.setPropertyOperator(property4, operator4);
        Assert.assertSame((String)"operators size has not changed", (Object)expectedSize, (Object)descriptor.getPropertyOperators().size());
        Assert.assertSame((String)"operator can be found", (Object)operator1, (Object)descriptor.getPropertyOperator(property1));
        Assert.assertSame((String)"operator can be found", (Object)operator2, (Object)descriptor.getPropertyOperator(property2));
        Assert.assertSame((String)"operator can be found", (Object)operator4, (Object)descriptor.getPropertyOperator(property4));
    }

    @Test
    @Ignore
    public void testCreateLayerOperator() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    public void testSetPropertyCollectionSize() {
        int expectedSize = 5;
        DefaultPropertyOperator defaultPropertyOperator = LayersFactory.eINSTANCE.createDefaultPropertyOperator();
        LayerOperatorDescriptor descriptor = LayersFactory.eINSTANCE.createLayerOperatorDescriptor();
        descriptor.setPropertyCollectionSize(expectedSize, defaultPropertyOperator);
        Assert.assertSame((String)"list has the expected size", (Object)expectedSize, (Object)descriptor.getPropertyOperators().size());
        Assert.assertSame((String)"list is initialized", (Object)defaultPropertyOperator, (Object)descriptor.getPropertyOperators().get(0));
    }
}

