/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layers.stackmodel.layers.impl;

import org.eclipse.papyrus.layers.stackmodel.BadStateException;
import org.eclipse.papyrus.layers.stackmodel.LayersException;
import org.eclipse.papyrus.layers.stackmodel.layers.Layer;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersFactory;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersPackage;
import org.eclipse.papyrus.layers.stackmodel.layers.NullInstance;
import org.eclipse.papyrus.layers.stackmodel.layers.Property;
import org.eclipse.papyrus.layers.stackmodel.layers.StringInstance;
import org.eclipse.papyrus.layers.stackmodel.layers.impl.LayerImpl;
import org.eclipse.papyrus.layers.stackmodel.layers.util.PropertyUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LayerImplTest {
    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testLayerImpl() {
        Layer layer = LayersFactory.eINSTANCE.createLayer();
        Assert.assertNotNull((String)"object created", (Object)layer);
    }

    @Test
    public void testGetPropertyValues() {
        Layer layer = LayersFactory.eINSTANCE.createLayer();
        Assert.assertNotNull((String)"list created", layer.getPropertyValues());
    }

    @Test
    public void testPropertyValuesAllowsDouble() {
        LayerImpl layer = (LayerImpl)LayersFactory.eINSTANCE.createLayer();
        NullInstance instance = NullInstance.NULLINSTANCE;
        layer.getPropertyValues().add((Object)instance);
        Assert.assertEquals((String)"instance added", (long)1L, (long)layer.getPropertyValues().size());
        layer.getPropertyValues().add((Object)instance);
        Assert.assertEquals((String)"same instance added==> double allowed", (long)2L, (long)layer.getPropertyValues().size());
    }

    @Test
    public void testGetPropertyValueMap() {
        Layer layer = LayersFactory.eINSTANCE.createLayer();
        Assert.assertNotNull((String)"PropertyValueMap exist", layer.getPropertyValueMap());
        StringInstance typeInstance = LayersFactory.eINSTANCE.createStringInstance();
        String key = "name";
        layer.getPropertyValueMap().put((Object)key, (Object)typeInstance);
        Assert.assertNotNull((String)"PropertyValueMap exis", (Object)layer.getPropertyValueMap().get((Object)key));
    }

    @Test
    public void testResetAllPropertyValuesFromRegistry() throws BadStateException {
        LayerImpl layer = (LayerImpl)LayersFactory.eINSTANCE.createLayer();
        layer.resetAllPropertyValuesFromRegistry();
        Assert.assertEquals((String)"list is empty", (long)0L, (long)layer.getPropertyValues().size());
    }

    @Test
    public void testGetViews() {
        Layer layer = LayersFactory.eINSTANCE.createLayer();
        Assert.assertNotNull((String)"list created", layer.getViews());
    }

    @Test
    public void testAddPropertyInstance() throws LayersException {
        Layer layer = LayersFactory.eINSTANCE.createLayer();
        String propertyName = "isSunday";
        Property property = PropertyUtils.getInstance().createProperty(propertyName, LayersPackage.eINSTANCE.getBooleanType());
        layer.addPropertyInstance(property);
        Assert.assertNotNull((String)"list created", (Object)layer.getPropertyValueMap().get((Object)propertyName));
    }

    @Test
    public void testgetPropertyInstanceByProperty() throws LayersException {
        Layer layer = LayersFactory.eINSTANCE.createLayer();
        String propertyName = "isSunday";
        Property property = PropertyUtils.getInstance().createProperty(propertyName, LayersPackage.eINSTANCE.getBooleanType());
        layer.addPropertyInstance(property);
        Assert.assertNotNull((String)"property found by property", (Object)layer.getPropertyInstance(property));
        Assert.assertNotNull((String)"property found by name", (Object)layer.getPropertyInstance(propertyName));
    }
}

