/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layers.stackmodel.layers.impl;

import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.papyrus.layers.stackmodel.layers.Layer;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersFactory;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersStack;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersStackApplication;
import org.eclipse.papyrus.layers.stackmodel.layers.TopLayerOperator;
import org.eclipse.papyrus.layers.stackmodel.layers.util.LayersFactoryTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class LayerExpressionInitWithApplicationImplTest {
    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testLayerExpressionImpl() {
        LayersStackApplication application = LayersFactory.eINSTANCE.createLayersStackApplication();
        Diagram diagram = NotationFactory.eINSTANCE.createDiagram();
        LayersStack stack = application.getLayersStackFor(diagram);
        LayersFactoryTestUtils factory = new LayersFactoryTestUtils(application);
        factory.newTopLayer("top", factory.newLayer("layer1"), factory.newLayer("layer2"), factory.newTopLayer("container1", factory.newLayer("layer3")));
        TopLayerOperator top = (TopLayerOperator)factory.getLayer("top");
        stack.setLayers(top);
        TopLayerOperator container1 = (TopLayerOperator)factory.getLayer("top");
        Layer layer1 = (Layer)factory.getLayer("layer1");
        Layer layer2 = (Layer)factory.getLayer("layer2");
        Layer layer3 = (Layer)factory.getLayer("layer3");
        Assert.assertNotNull((String)"object created", (Object)top);
        Assert.assertEquals((String)"application initialized", (Object)application, (Object)top.getApplication());
        Assert.assertNotNull((String)"object created", (Object)container1);
        Assert.assertEquals((String)"application initialized", (Object)application, (Object)container1.getApplication());
        Assert.assertNotNull((String)"object created", (Object)layer1);
        Assert.assertEquals((String)"application initialized", (Object)application, (Object)layer1.getApplication());
        Assert.assertNotNull((String)"object created", (Object)layer2);
        Assert.assertEquals((String)"application initialized", (Object)application, (Object)layer2.getApplication());
        Assert.assertNotNull((String)"object created", (Object)layer3);
        Assert.assertEquals((String)"application initialized", (Object)application, (Object)layer3.getApplication());
    }

    @Test
    public void testAddSubTreeImpl() {
        LayersStackApplication application = LayersFactory.eINSTANCE.createLayersStackApplication();
        Diagram diagram = NotationFactory.eINSTANCE.createDiagram();
        LayersStack stack = application.getLayersStackFor(diagram);
        LayersFactoryTestUtils factory = new LayersFactoryTestUtils(application);
        factory.newTopLayer("top", factory.newLayer("layer1"), factory.newLayer("layer2"), factory.newTopLayer("container1", factory.newLayer("layer3")));
        factory.newTopLayer("container2", factory.newLayer("layer21"), factory.newLayer("layer22"));
        TopLayerOperator top = (TopLayerOperator)factory.getLayer("top");
        stack.setLayers(top);
        TopLayerOperator container2 = (TopLayerOperator)factory.getLayer("container2");
        Layer layer21 = (Layer)factory.getLayer("layer21");
        Layer layer22 = (Layer)factory.getLayer("layer22");
        top.getLayers().add((Object)container2);
        Assert.assertNotNull((String)"object created", (Object)top);
        Assert.assertEquals((String)"application initialized", (Object)application, (Object)top.getApplication());
        Assert.assertNotNull((String)"object created", (Object)container2);
        Assert.assertEquals((String)"application initialized", (Object)application, (Object)container2.getApplication());
        Assert.assertEquals((String)"container (stack) initialized", (Object)stack, (Object)container2.getOwningLayersStack());
        Assert.assertNotNull((String)"object created", (Object)layer21);
        Assert.assertEquals((String)"application initialized", (Object)application, (Object)layer21.getApplication());
        Assert.assertEquals((String)"container (stack) initialized", (Object)stack, (Object)layer21.getOwningLayersStack());
        Assert.assertNotNull((String)"object created", (Object)layer22);
        Assert.assertEquals((String)"application initialized", (Object)application, (Object)layer22.getApplication());
        Assert.assertEquals((String)"container (stack) initialized", (Object)stack, (Object)layer22.getOwningLayersStack());
    }

    @Test
    @Ignore
    public void testIsLayerEnabled() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    @Ignore
    public void testIsBranchEnabled() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    public void testGetOwningLayersStack() {
        LayersStackApplication application = LayersFactory.eINSTANCE.createLayersStackApplication();
        Diagram diagram = NotationFactory.eINSTANCE.createDiagram();
        LayersStack stack = application.getLayersStackFor(diagram);
        LayersFactoryTestUtils factory = new LayersFactoryTestUtils(application);
        factory.newTopLayer("top", factory.newLayer("layer1"), factory.newLayer("layer2"), factory.newTopLayer("container1", factory.newLayer("layer3")));
        TopLayerOperator top = (TopLayerOperator)factory.getLayer("top");
        stack.setLayers(top);
        TopLayerOperator container1 = (TopLayerOperator)factory.getLayer("top");
        Layer layer1 = (Layer)factory.getLayer("layer1");
        Layer layer2 = (Layer)factory.getLayer("layer2");
        Layer layer3 = (Layer)factory.getLayer("layer3");
        Assert.assertNotNull((String)"object created", (Object)top);
        Assert.assertEquals((String)"container (stack) initialized", (Object)stack, (Object)top.getOwningLayersStack());
        Assert.assertNotNull((String)"object created", (Object)container1);
        Assert.assertEquals((String)"container (stack) initialized", (Object)stack, (Object)container1.getOwningLayersStack());
        Assert.assertNotNull((String)"object created", (Object)layer1);
        Assert.assertEquals((String)"container (stack) initialized", (Object)stack, (Object)layer1.getOwningLayersStack());
        Assert.assertNotNull((String)"object created", (Object)layer2);
        Assert.assertEquals((String)"container (stack) initialized", (Object)stack, (Object)layer2.getOwningLayersStack());
        Assert.assertNotNull((String)"object created", (Object)layer3);
        Assert.assertEquals((String)"container (stack) initialized", (Object)stack, (Object)layer3.getOwningLayersStack());
    }
}

