/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layers.stackmodel.layers;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum LayerState implements Enumerator
{
    DETACHED(0, "detached", "detached"),
    ATTACHED(1, "attached", "attached");

    public static final int DETACHED_VALUE = 0;
    public static final int ATTACHED_VALUE = 1;
    private static final LayerState[] VALUES_ARRAY;
    public static final List<LayerState> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new LayerState[]{DETACHED, ATTACHED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static LayerState get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LayerState result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LayerState getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LayerState result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LayerState get(int value) {
        switch (value) {
            case 0: {
                return DETACHED;
            }
            case 1: {
                return ATTACHED;
            }
        }
        return null;
    }

    private LayerState(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

