/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.newchild;

import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.papyrus.infra.newchild.elementcreationmenumodel.ElementCreationMenuModelPackage;
import org.eclipse.papyrus.infra.newchild.elementcreationmenumodel.Folder;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreationMenuRegistry {
    private final String MENU_CREATION_MODEL_EXTENSION_ID = "org.eclipse.papyrus.infra.newchild";
    private final String MODEL_ID = "model";
    private ArrayList<Folder> rootFolders = new ArrayList();

    public CreationMenuRegistry() {
        this.init();
    }

    public void init() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getPackageRegistry().put((Object)ElementCreationMenuModelPackage.eINSTANCE.getNsURI(), (Object)ElementCreationMenuModelPackage.eINSTANCE);
        IConfigurationElement[] configElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.papyrus.infra.newchild");
        int i = 0;
        while (i < configElements.length) {
            this.rootFolders.add(this.initializeOneModel((ResourceSet)resourceSet, configElements[i]));
            ++i;
        }
    }

    public ArrayList<Folder> getRootFolder() {
        return this.rootFolders;
    }

    private Folder initializeOneModel(ResourceSet resourceSet, IConfigurationElement element) {
        try {
            return CreationMenuRegistry.createExtension(resourceSet, element, element.getAttribute("model"));
        }
        catch (Exception e) {
            System.err.println("model of new child can not be loaded: " + e);
            return null;
        }
    }

    private static Folder createExtension(ResourceSet resourceSet, IConfigurationElement element, String classAttribute) throws Exception {
        try {
            URI uri;
            Resource resource;
            Bundle extensionBundle = Platform.getBundle((String)element.getDeclaringExtension().getNamespaceIdentifier());
            URL url = extensionBundle.getResource(classAttribute);
            Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
            if (url != null && (resource = resourceSet.getResource(uri = URI.createURI((String)url.toURI().toASCIIString()), true)).getContents().get(0) instanceof Folder) {
                return (Folder)resource.getContents().get(0);
            }
            return null;
        }
        catch (Exception e) {
            throw new Exception("unable to create Extension" + e);
        }
    }
}

