/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.search;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.internal.tasks.core.ITaskList;
import org.eclipse.mylyn.internal.tasks.ui.search.Messages;
import org.eclipse.mylyn.internal.tasks.ui.search.RepositorySearchResult;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.RepositoryStatus;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataCollector;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.PlatformUI;

public class SearchHitCollector
extends TaskDataCollector
implements ISearchQuery {
    private final ITaskList taskList;
    private final TaskRepository repository;
    private final IRepositoryQuery repositoryQuery;
    private final RepositorySearchResult searchResult;
    private AbstractRepositoryConnector connector;

    public SearchHitCollector(ITaskList tasklist, TaskRepository repository, IRepositoryQuery repositoryQuery) {
        this.taskList = tasklist;
        this.repository = repository;
        this.repositoryQuery = repositoryQuery;
        this.searchResult = new RepositorySearchResult(this);
    }

    public void aboutToStart() {
        this.searchResult.removeAll();
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                NewSearchUI.activateSearchResultView();
            }
        });
    }

    public void accept(TaskData taskData) {
        ITask task = this.taskList.getTask(this.repository.getRepositoryUrl(), taskData.getTaskId());
        if (task == null) {
            task = TasksUi.getRepositoryModel().createTask(this.repository, taskData.getTaskId());
            if (this.connector != null) {
                this.connector.updateTaskFromTaskData(this.repository, task, taskData);
            }
        }
        this.searchResult.addMatch(new Match((Object)task, 0, 0));
    }

    public String getLabel() {
        return Messages.SearchHitCollector_Querying_Repository_;
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        return this.searchResult;
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        this.aboutToStart();
        if (monitor.isCanceled()) {
            throw new OperationCanceledException(Messages.SearchHitCollector_Search_cancelled);
        }
        this.connector = TasksUi.getRepositoryManager().getRepositoryConnector(this.repositoryQuery.getConnectorKind());
        if (this.connector != null) {
            final IStatus status = this.connector.performQuery(this.repository, this.repositoryQuery, (TaskDataCollector)this, null, monitor);
            if (!status.isOK()) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        TasksUiInternal.displayStatus((String)Messages.SearchHitCollector_Search_failed, (IStatus)status);
                    }
                });
            } else if (this.searchResult.getMatchCount() >= 5000) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        TasksUiInternal.displayStatus((String)Messages.SearchHitCollector_Search_returned_maximum_number_of_hits, (IStatus)RepositoryStatus.createStatus((String)SearchHitCollector.this.repository.getRepositoryUrl(), (int)2, (String)"org.eclipse.mylyn.tasks.ui", (String)Messages.SearchHitCollector_Max_allowed_number_of_hits_returned_exceeded));
                    }
                });
            }
        } else {
            return new Status(4, "org.eclipse.mylyn.tasks.ui", 0, Messages.SearchHitCollector_Repository_connector_could_not_be_found, null);
        }
        return Status.OK_STATUS;
    }

    public IRepositoryQuery getRepositoryQuery() {
        return this.repositoryQuery;
    }
}

