/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.layoutdata.tools.internal.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.layoutdata.AbstractLayoutData;
import org.eclipse.sirius.diagram.layoutdata.EdgeLayoutData;
import org.eclipse.sirius.diagram.layoutdata.NodeLayoutData;
import org.eclipse.sirius.diagram.layoutdata.Point;
import org.eclipse.sirius.diagram.layoutdata.tools.api.util.LayoutHelper;
import org.eclipse.sirius.diagram.layoutdata.tools.api.util.configuration.Configuration;
import org.eclipse.sirius.diagram.layoutdata.tools.api.util.configuration.EdgeConfiguration;
import org.eclipse.sirius.diagram.layoutdata.tools.api.util.configuration.NodeConfiguration;

public class LayoutHelperImpl
implements LayoutHelper {
    @Override
    public boolean haveSameLayout(NodeLayoutData nodeLayout1, NodeLayoutData nodeLayout2, Configuration configuration) {
        return this.doHaveSameLayout(nodeLayout1, nodeLayout2, configuration) == null;
    }

    private <T extends AbstractLayoutData> LayoutHelper.LayoutDifference<T> doAbstractLayoutDataHaveSameLayout(T abstractLayout1, T abstractLayout2, Configuration configuration) {
        LayoutDifferenceImpl result = null;
        boolean haveSameLayout = false;
        if (abstractLayout1 == abstractLayout2) {
            haveSameLayout = true;
        } else if (abstractLayout1 != null && abstractLayout2 != null) {
            haveSameLayout = abstractLayout1.getId() != null;
            haveSameLayout = haveSameLayout && abstractLayout1.getId().equals(abstractLayout2.getId());
            boolean bl = haveSameLayout = haveSameLayout && this.haveSameLayout(abstractLayout1.getLabel(), abstractLayout2.getLabel(), configuration);
        }
        if (!haveSameLayout && result == null) {
            result = new LayoutDifferenceImpl(abstractLayout1, abstractLayout2, configuration);
        }
        return result;
    }

    private LayoutHelper.LayoutDifference<? extends AbstractLayoutData> doHaveSameLayout(NodeLayoutData nodeLayout1, NodeLayoutData nodeLayout2, Configuration configuration) {
        LayoutHelper.LayoutDifference<AbstractLayoutData> result = null;
        boolean haveSameLayout = false;
        LayoutHelper.LayoutDifference<NodeLayoutData> abstractDataHaveSameLayout = this.doAbstractLayoutDataHaveSameLayout(nodeLayout1, nodeLayout2, configuration);
        boolean bl = haveSameLayout = abstractDataHaveSameLayout == null;
        if (haveSameLayout && nodeLayout1 != null && nodeLayout2 != null) {
            NodeConfiguration nodeConfiguration = configuration.getNodeConfiguration();
            haveSameLayout = haveSameLayout && this.isAroundPoint(nodeLayout1.getLocation(), nodeLayout2.getLocation(), nodeConfiguration.getDistanceAroundPoint());
            haveSameLayout = haveSameLayout && nodeLayout1.getWidth() == nodeLayout2.getWidth();
            boolean bl2 = haveSameLayout = haveSameLayout && nodeLayout1.getHeight() == nodeLayout2.getHeight();
            if (haveSameLayout && configuration.isRecursive()) {
                haveSameLayout = nodeLayout1.getChildren().size() == nodeLayout2.getChildren().size();
                boolean bl3 = haveSameLayout = haveSameLayout && nodeLayout1.getOutgoingEdges().size() == nodeLayout2.getOutgoingEdges().size();
                if (haveSameLayout) {
                    int i = 0;
                    while (i < nodeLayout1.getChildren().size() && haveSameLayout) {
                        result = this.doHaveSameLayout((NodeLayoutData)nodeLayout1.getChildren().get(i), (NodeLayoutData)nodeLayout2.getChildren().get(i), configuration);
                        haveSameLayout = result == null;
                        ++i;
                    }
                    i = 0;
                    while (i < nodeLayout1.getOutgoingEdges().size() && haveSameLayout) {
                        result = this.doHaveSameLayout((EdgeLayoutData)nodeLayout1.getOutgoingEdges().get(i), (EdgeLayoutData)nodeLayout2.getOutgoingEdges().get(i), configuration);
                        haveSameLayout = result == null;
                        ++i;
                    }
                }
            }
            if (!haveSameLayout && result == null) {
                result = new LayoutDifferenceImpl<NodeLayoutData>(nodeLayout1, nodeLayout2, configuration);
            }
        } else {
            result = abstractDataHaveSameLayout;
        }
        return result;
    }

    private boolean isAroundPoint(Point expectedLocation, Point realLocation, double distance) {
        org.eclipse.draw2d.geometry.Point draw2dRealPoint;
        org.eclipse.draw2d.geometry.Point draw2dExpectedPoint = new org.eclipse.draw2d.geometry.Point(expectedLocation.getX(), expectedLocation.getY());
        return (double)draw2dExpectedPoint.getDistance2(draw2dRealPoint = new org.eclipse.draw2d.geometry.Point(realLocation.getX(), realLocation.getY())) <= distance * distance;
    }

    @Override
    public LayoutHelper.LayoutDifference<?> computeFirstLayoutDifference(Collection<? extends EObject> col1, Collection<? extends EObject> col2, Configuration configuration) {
        LayoutHelper.LayoutDifference<Object> result = null;
        boolean haveSameLayout = false;
        if (col1 == col2) {
            haveSameLayout = true;
        } else {
            boolean bl = haveSameLayout = col1 != null && col2 != null && col1.size() == col2.size();
            if (haveSameLayout) {
                Iterator<? extends EObject> it1 = col1.iterator();
                Iterator<? extends EObject> it2 = col2.iterator();
                while (haveSameLayout && it1.hasNext() && it2.hasNext()) {
                    EObject layoutData1 = it1.next();
                    EObject layoutData2 = it2.next();
                    if (layoutData1 instanceof NodeLayoutData && layoutData2 instanceof NodeLayoutData) {
                        result = this.doHaveSameLayout((NodeLayoutData)layoutData1, (NodeLayoutData)layoutData2, configuration);
                    } else if (layoutData1 instanceof EdgeLayoutData && layoutData2 instanceof EdgeLayoutData) {
                        result = this.doHaveSameLayout((EdgeLayoutData)layoutData1, (EdgeLayoutData)layoutData2, configuration);
                    }
                    boolean bl2 = haveSameLayout = result == null;
                }
            }
        }
        if (!haveSameLayout && result == null) {
            result = new LayoutDifferenceImpl(col1, col2, configuration);
        }
        return result;
    }

    @Override
    public boolean haveSameLayout(Collection<? extends EObject> col1, Collection<? extends EObject> col2, Configuration configuration) {
        return this.computeFirstLayoutDifference(col1, col2, configuration) == null;
    }

    @Override
    public boolean haveSameLayout(EdgeLayoutData edgeLayout1, EdgeLayoutData edgeLayout2, Configuration configuration) {
        return this.doHaveSameLayout(edgeLayout1, edgeLayout2, configuration) == null;
    }

    private LayoutHelper.LayoutDifference<EdgeLayoutData> doHaveSameLayout(EdgeLayoutData edgeLayout1, EdgeLayoutData edgeLayout2, Configuration configuration) {
        LayoutHelper.LayoutDifference<EdgeLayoutData> result = null;
        boolean haveSameLayout = false;
        LayoutHelper.LayoutDifference<EdgeLayoutData> abstractDataHaveSameLayout = this.doAbstractLayoutDataHaveSameLayout(edgeLayout1, edgeLayout2, configuration);
        boolean bl = haveSameLayout = abstractDataHaveSameLayout == null;
        if (haveSameLayout && edgeLayout1 != null && edgeLayout2 != null) {
            EdgeConfiguration edgeConfiguration = configuration.getEdgeConfiguration();
            haveSameLayout = haveSameLayout && StringUtil.equals((CharSequence)edgeLayout1.getSourceTerminal(), (CharSequence)edgeLayout2.getSourceTerminal());
            haveSameLayout = haveSameLayout && StringUtil.equals((CharSequence)edgeLayout1.getTargetTerminal(), (CharSequence)edgeLayout2.getTargetTerminal());
            haveSameLayout = haveSameLayout && edgeLayout1.getRouting() == edgeLayout2.getRouting();
            haveSameLayout = haveSameLayout && this.isAroundPoint(edgeLayout1.getSourceRefPoint(), edgeLayout2.getSourceRefPoint(), edgeConfiguration.getDistanceAroundPointsOfEdgeBendpointsList());
            boolean bl2 = haveSameLayout = haveSameLayout && edgeLayout1.getPointList().size() == edgeLayout2.getPointList().size();
            if (haveSameLayout) {
                int i = 0;
                while (i < edgeLayout1.getPointList().size() && haveSameLayout) {
                    haveSameLayout = this.isAroundPoint((Point)edgeLayout1.getPointList().get(i), (Point)edgeLayout2.getPointList().get(i), edgeConfiguration.getDistanceAroundPointsOfEdgeBendpointsList());
                    ++i;
                }
            }
            if (!haveSameLayout) {
                result = new LayoutDifferenceImpl<EdgeLayoutData>(edgeLayout1, edgeLayout2, configuration);
            }
        } else {
            result = abstractDataHaveSameLayout;
        }
        return result;
    }

    private static String toString(EObject eobject) {
        return LayoutHelperImpl.toString("\n", eobject);
    }

    private static String toString(String prefix, EObject eobject) {
        StringBuilder sb = new StringBuilder();
        EClass eClass = eobject.eClass();
        int size = eClass.getFeatureCount();
        int i = 0;
        while (i < size) {
            EStructuralFeature feature = eClass.getEStructuralFeature(i);
            if (!feature.isDerived()) {
                sb.append(prefix);
                sb.append(feature.getName());
                sb.append(" : ");
                Object obj = eobject.eGet(feature);
                if (obj == null) {
                    sb.append("null");
                } else if (obj instanceof EObject) {
                    sb.append(LayoutHelperImpl.toString("\n     ", (EObject)obj));
                } else if (obj instanceof List) {
                    List list = (List)obj;
                    if (!list.isEmpty()) {
                        sb.append('\n');
                        sb.append("     ");
                    }
                    for (Object object : list) {
                        sb.append('\n');
                        sb.append("     ");
                        if (object instanceof EObject) {
                            sb.append(LayoutHelperImpl.toString((EObject)object));
                            continue;
                        }
                        sb.append(object.toString());
                    }
                } else {
                    sb.append(obj.toString());
                }
            }
            ++i;
        }
        return sb.toString();
    }

    private static final class LayoutDifferenceImpl<T>
    implements LayoutHelper.LayoutDifference<T> {
        private final T leftElement;
        private final T rightElement;
        private final Configuration configuration;

        private LayoutDifferenceImpl(T leftElement, T rightElement, Configuration configuration) {
            this.leftElement = leftElement;
            this.rightElement = rightElement;
            this.configuration = configuration;
        }

        @Override
        public String getMessage() {
            return "Configuration: [\n" + this.configuration + "\n]\nDifference between left element [[\n\t" + this.elementToString(this.leftElement) + "\n]] and right element [[\n\t" + this.elementToString(this.rightElement) + "\n]]";
        }

        private String elementToString(T element) {
            String elementToString = this.leftElement instanceof EObject ? LayoutHelperImpl.toString((EObject)element) : element.toString();
            return elementToString;
        }

        @Override
        public T getLeftElement() {
            return this.leftElement;
        }

        @Override
        public T getRightElement() {
            return this.rightElement;
        }

        public String toString() {
            return this.getMessage();
        }
    }
}

