/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.labelprovider.service;

import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.papyrus.infra.services.labelprovider.service.IFilteredLabelProvider;
import org.eclipse.papyrus.infra.services.labelprovider.service.IQualifierLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class ExtensibleLabelProvider
implements ILabelProvider,
IQualifierLabelProvider,
ILabelProviderListener,
IColorProvider,
IFontProvider {
    private final Set<ILabelProviderListener> listeners = new LinkedHashSet<ILabelProviderListener>();
    private final SortedMap<Integer, List<IFilteredLabelProvider>> providers = new TreeMap<Integer, List<IFilteredLabelProvider>>();
    private final ILabelProvider defaultProvider = new LabelProvider();

    public void addListener(ILabelProviderListener listener) {
        this.listeners.add(listener);
    }

    public void dispose() {
        this.listeners.clear();
        for (List<IFilteredLabelProvider> filteredProviders : this.providers.values()) {
            for (IFilteredLabelProvider provider : filteredProviders) {
                provider.dispose();
            }
        }
        this.providers.clear();
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
        this.listeners.remove(listener);
    }

    public void registerProvider(int priority, IFilteredLabelProvider provider) {
        this.getProviders(priority).add(provider);
        provider.addListener(this);
    }

    public Color getForeground(Object element) {
        IColorProvider provider = this.getProvider(element, IColorProvider.class);
        if (provider != null) {
            return provider.getForeground(element);
        }
        return null;
    }

    public Color getBackground(Object element) {
        IColorProvider provider = this.getProvider(element, IColorProvider.class);
        if (provider != null) {
            return provider.getBackground(element);
        }
        return null;
    }

    public Font getFont(Object element) {
        IFontProvider provider = this.getProvider(element, IFontProvider.class);
        if (provider != null) {
            return provider.getFont(element);
        }
        return null;
    }

    public Image getImage(Object element) {
        return this.getProvider(element).getImage(element);
    }

    public String getText(Object element) {
        return this.getProvider(element).getText(element);
    }

    @Override
    public Image getQualifierImage(Object element) {
        Image result = null;
        IQualifierLabelProvider provider = this.getProvider(element, IQualifierLabelProvider.class);
        if (provider != null) {
            result = provider.getQualifierImage(element);
        }
        return result;
    }

    @Override
    public String getQualifierText(Object element) {
        String result = null;
        IQualifierLabelProvider provider = this.getProvider(element, IQualifierLabelProvider.class);
        if (provider != null) {
            result = provider.getQualifierText(element);
        }
        return result;
    }

    protected final ILabelProvider getProvider(Object element) {
        for (List<IFilteredLabelProvider> filteredProviders : this.providers.values()) {
            for (IFilteredLabelProvider provider : filteredProviders) {
                if (!provider.accept(element)) continue;
                return provider;
            }
        }
        return this.defaultProvider;
    }

    protected final <T> T getProvider(Object element, Class<T> type) {
        for (List<IFilteredLabelProvider> filteredProviders : this.providers.values()) {
            for (IFilteredLabelProvider provider : filteredProviders) {
                if (!type.isInstance(provider) || !provider.accept(element)) continue;
                return type.cast(provider);
            }
        }
        return type.isInstance(this.defaultProvider) ? (T)type.cast(this.defaultProvider) : null;
    }

    protected final List<IFilteredLabelProvider> getProviders(int priority) {
        if (!this.providers.containsKey(priority)) {
            this.providers.put(priority, new LinkedList());
        }
        return (List)this.providers.get(priority);
    }

    public void labelProviderChanged(LabelProviderChangedEvent event) {
        for (ILabelProviderListener listener : this.listeners) {
            listener.labelProviderChanged(event);
        }
    }
}

