/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.textedit.stereotypeproperty.xtext.ui.contributions;

import com.google.inject.Injector;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.papyrus.uml.alf.alf.BOOLEAN_LITERAL;
import org.eclipse.papyrus.uml.alf.alf.INTEGER_LITERAL;
import org.eclipse.papyrus.uml.alf.alf.NameExpression;
import org.eclipse.papyrus.uml.alf.alf.STRING_LITERAL;
import org.eclipse.papyrus.uml.profile.structure.AppliedStereotypeProperty;
import org.eclipse.papyrus.uml.textedit.stereotypeproperty.xtext.AppliedStereotypePropertyEditorUtil;
import org.eclipse.papyrus.uml.textedit.stereotypeproperty.xtext.ui.internal.AppliedStereotypePropertyActivator;
import org.eclipse.papyrus.uml.xtext.integration.DefaultXtextDirectEditorConfiguration;
import org.eclipse.papyrus.uml.xtext.integration.XtextFakeResourceContext;
import org.eclipse.papyrus.uml.xtext.integration.core.ContextElementAdapter;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.Type;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.StringInputStream;

public class StereotypePropertyEditorConfigurationContribution
extends DefaultXtextDirectEditorConfiguration {
    protected static AppliedStereotypeProperty statocAppliedStereotypeProperty;

    public static AppliedStereotypeProperty getAppliedStereoProperty() {
        return statocAppliedStereotypeProperty;
    }

    public Object preEditAction(Object objectToEdit) {
        if (objectToEdit instanceof AppliedStereotypeProperty) {
            statocAppliedStereotypeProperty = (AppliedStereotypeProperty)objectToEdit;
        }
        return super.preEditAction(objectToEdit);
    }

    public Injector getInjector() {
        return AppliedStereotypePropertyActivator.getInstance().getInjector("org.eclipse.papyrus.uml.textedit.stereotypeproperty.xtext.AppliedStereotypeProperty");
    }

    protected ICommand getParseCommand(EObject umlObject, EObject xtextObject) {
        umlObject = (EObject)this.objectToEdit;
        CompositeCommand command = new CompositeCommand("");
        AppliedStereotypeProperty appliedStereotypeProperty = (AppliedStereotypeProperty)umlObject;
        Object[] result = AppliedStereotypePropertyEditorUtil.getPossibleElements((AppliedStereotypeProperty)appliedStereotypeProperty);
        Type type = appliedStereotypeProperty.getStereotypeProperty().getType();
        ICommand specificCommand = null;
        if (type.getName().equals("Integer")) {
            specificCommand = this.reconcileInteger(appliedStereotypeProperty, xtextObject);
        } else if (type.getName().equals("Boolean")) {
            specificCommand = this.reconcileBoolean(appliedStereotypeProperty, xtextObject);
        } else if (type.getName().equals("String")) {
            specificCommand = this.reconcileString(appliedStereotypeProperty, xtextObject);
        } else if (type.eClass().getName().equals("Stereotype")) {
            specificCommand = this.reconcileRefToStereotypeApp(appliedStereotypeProperty, xtextObject, result);
        } else if (type.eClass().getName().equals("DataType")) {
            specificCommand = this.reconcileString(appliedStereotypeProperty, xtextObject);
        } else if (type.eClass().getName().equals("PrimitiveType")) {
            specificCommand = this.reconcileString(appliedStereotypeProperty, xtextObject);
        } else if (type instanceof Enumeration) {
            specificCommand = this.reconcileEnumerationLiteral(appliedStereotypeProperty, xtextObject, result);
        } else if (type instanceof Element) {
            specificCommand = this.reconcileRefToElement(appliedStereotypeProperty, xtextObject, result);
        }
        if (specificCommand != null) {
            command.add((IUndoableOperation)specificCommand);
        }
        return command;
    }

    protected ICommand reconcileEnumerationLiteral(AppliedStereotypeProperty appliedStereotypeProperty, EObject xtextObject, Object[] possibleElement) {
        ArrayList<NameExpression> eObjects = this.getAllElementRef(xtextObject);
        if (appliedStereotypeProperty.getStereotypeProperty().getUpper() == 1) {
            if (eObjects.size() == 0) {
                return this.createUpdateCommand(appliedStereotypeProperty, null);
            }
            NameExpression nameExpression = eObjects.get(0);
            String id = nameExpression.getId();
            EEnumLiteral foundStereotypeApplication = null;
            int i = 0;
            while (i < possibleElement.length) {
                if (possibleElement[i] instanceof EEnumLiteral && ((EEnumLiteral)possibleElement[i]).getName().equals(id)) {
                    foundStereotypeApplication = (EEnumLiteral)possibleElement[i];
                }
                if (possibleElement[i] instanceof Enumerator && ((Enumerator)possibleElement[i]).getName().equals(id)) {
                    return this.createUpdateCommand(appliedStereotypeProperty, possibleElement[i]);
                }
                ++i;
            }
            if (foundStereotypeApplication != null) {
                return this.createUpdateCommand(appliedStereotypeProperty, foundStereotypeApplication);
            }
        } else {
            if (eObjects.size() == 0) {
                return this.createUpdateCommand(appliedStereotypeProperty, new ArrayList());
            }
            ArrayList<EEnumLiteral> stereotypeApplicationList = new ArrayList<EEnumLiteral>();
            for (NameExpression nameExpression : eObjects) {
                String id = nameExpression.getId();
                EEnumLiteral foundStereotypeApplication = null;
                int i = 0;
                while (i < possibleElement.length) {
                    if (possibleElement[i] instanceof EEnumLiteral && ((EEnumLiteral)possibleElement[i]).getName().equals(id)) {
                        foundStereotypeApplication = (EEnumLiteral)possibleElement[i];
                    }
                    if (possibleElement[i] instanceof Enumerator && ((Enumerator)possibleElement[i]).getName().equals(id)) {
                        foundStereotypeApplication = (Enumerator)possibleElement[i];
                    }
                    ++i;
                }
                if (foundStereotypeApplication == null) continue;
                stereotypeApplicationList.add(foundStereotypeApplication);
            }
            return this.createUpdateCommand(appliedStereotypeProperty, stereotypeApplicationList);
        }
        return null;
    }

    protected ICommand reconcileRefToStereotypeApp(AppliedStereotypeProperty appliedStereotypeProperty, EObject xtextObject, Object[] result) {
        ArrayList<NameExpression> eObjects = this.getAllElementRef(xtextObject);
        if (appliedStereotypeProperty.getStereotypeProperty().getUpper() == 1) {
            if (eObjects.size() == 0) {
                return this.createUpdateCommand(appliedStereotypeProperty, null);
            }
            NameExpression nameExpression = eObjects.get(0);
            EObject foundStereotypeApplication = AppliedStereotypePropertyEditorUtil.getApplicationStereotypeFor((AppliedStereotypeProperty)appliedStereotypeProperty, (NameExpression)nameExpression);
            return this.createUpdateCommand(appliedStereotypeProperty, foundStereotypeApplication);
        }
        if (eObjects.size() == 0) {
            return this.createUpdateCommand(appliedStereotypeProperty, new ArrayList());
        }
        ArrayList<EObject> stereotypeApplicationList = new ArrayList<EObject>();
        for (NameExpression nameExpression : eObjects) {
            EObject foundStereotypeApplication = AppliedStereotypePropertyEditorUtil.getApplicationStereotypeFor((AppliedStereotypeProperty)appliedStereotypeProperty, (NameExpression)nameExpression);
            if (foundStereotypeApplication == null) continue;
            stereotypeApplicationList.add(foundStereotypeApplication);
        }
        return this.createUpdateCommand(appliedStereotypeProperty, stereotypeApplicationList);
    }

    protected ICommand reconcileInteger(AppliedStereotypeProperty appliedStereotypeProperty, EObject xtextObject) {
        ArrayList intList = AppliedStereotypePropertyEditorUtil.get_INTEGER((EObject)xtextObject);
        if (appliedStereotypeProperty.getStereotypeProperty().getUpper() == 1) {
            if (intList.size() == 0) {
                return this.createUpdateCommand(appliedStereotypeProperty, null);
            }
            INTEGER_LITERAL theint = (INTEGER_LITERAL)intList.get(0);
            Integer value = new Integer(theint.getValue());
            return this.createUpdateCommand(appliedStereotypeProperty, (int)value);
        }
        if (intList.size() == 0) {
            return this.createUpdateCommand(appliedStereotypeProperty, new ArrayList());
        }
        ArrayList<Integer> resultList = new ArrayList<Integer>();
        for (INTEGER_LITERAL theint : intList) {
            Integer value = new Integer(theint.getValue());
            resultList.add(value);
        }
        return this.createUpdateCommand(appliedStereotypeProperty, resultList);
    }

    protected ICommand reconcileBoolean(AppliedStereotypeProperty appliedStereotypeProperty, EObject xtextObject) {
        ArrayList booleanList = AppliedStereotypePropertyEditorUtil.get_BOOLEAN((EObject)xtextObject);
        if (appliedStereotypeProperty.getStereotypeProperty().getUpper() == 1) {
            if (booleanList.size() == 0) {
                return this.createUpdateCommand(appliedStereotypeProperty, null);
            }
            BOOLEAN_LITERAL theboolean = (BOOLEAN_LITERAL)booleanList.get(0);
            Boolean value = new Boolean(theboolean.getValue().toString());
            return this.createUpdateCommand(appliedStereotypeProperty, (boolean)value);
        }
        if (booleanList.size() == 0) {
            return this.createUpdateCommand(appliedStereotypeProperty, new ArrayList());
        }
        ArrayList<Boolean> resultList = new ArrayList<Boolean>();
        for (BOOLEAN_LITERAL theboolean : booleanList) {
            Boolean value = new Boolean(theboolean.getValue().toString());
            resultList.add(value);
        }
        return this.createUpdateCommand(appliedStereotypeProperty, resultList);
    }

    protected ICommand reconcileRefToElement(AppliedStereotypeProperty appliedStereotypeProperty, EObject xtextObject, Object[] result) {
        ArrayList<NameExpression> eObjects = this.getAllElementRef(xtextObject);
        if (appliedStereotypeProperty.getStereotypeProperty().getUpper() == 1) {
            if (eObjects.size() == 0) {
                return this.createUpdateCommand(appliedStereotypeProperty, null);
            }
            NameExpression nameExpression = eObjects.get(0);
            EObject foundStereotypeApplication = AppliedStereotypePropertyEditorUtil.getNamedElementFor((NameExpression)nameExpression, (Object[])result);
            return this.createUpdateCommand(appliedStereotypeProperty, foundStereotypeApplication);
        }
        if (eObjects.size() == 0) {
            return this.createUpdateCommand(appliedStereotypeProperty, new ArrayList());
        }
        ArrayList<EObject> stereotypeApplicationList = new ArrayList<EObject>();
        for (NameExpression nameExpression : eObjects) {
            EObject foundStereotypeApplication = AppliedStereotypePropertyEditorUtil.getNamedElementFor((NameExpression)nameExpression, (Object[])result);
            if (foundStereotypeApplication == null) continue;
            stereotypeApplicationList.add(foundStereotypeApplication);
        }
        return this.createUpdateCommand(appliedStereotypeProperty, stereotypeApplicationList);
    }

    protected ICommand reconcileString(AppliedStereotypeProperty appliedStereotypeProperty, EObject xtextObject) {
        ArrayList theStringList = AppliedStereotypePropertyEditorUtil.get_STRING((EObject)xtextObject);
        if (appliedStereotypeProperty.getStereotypeProperty().getUpper() == 1) {
            if (theStringList.size() == 0) {
                return this.createUpdateCommand(appliedStereotypeProperty, null);
            }
            STRING_LITERAL theString = (STRING_LITERAL)theStringList.get(0);
            return this.createUpdateCommand(appliedStereotypeProperty, theString.getValue());
        }
        if (theStringList.size() == 0) {
            return this.createUpdateCommand(appliedStereotypeProperty, new ArrayList());
        }
        ArrayList<String> resultList = new ArrayList<String>();
        for (STRING_LITERAL theString : theStringList) {
            resultList.add(theString.getValue());
        }
        return this.createUpdateCommand(appliedStereotypeProperty, resultList);
    }

    protected ICommand createUpdateCommand(final AppliedStereotypeProperty appliedStereotypeProperty, final Object value) {
        AbstractTransactionalCommand setValueCommand = new AbstractTransactionalCommand(TransactionUtil.getEditingDomain((EObject)appliedStereotypeProperty.getStereotypeProperty()), "", Collections.EMPTY_LIST){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                appliedStereotypeProperty.getBaseElement().setValue(appliedStereotypeProperty.getStereotype(), appliedStereotypeProperty.getStereotypeProperty().getName(), value);
                return CommandResult.newOKCommandResult();
            }
        };
        return setValueCommand;
    }

    private ArrayList<NameExpression> getAllElementRef(EObject xtextObject) {
        ArrayList<NameExpression> result = new ArrayList<NameExpression>();
        TreeIterator iterator = xtextObject.eAllContents();
        while (iterator.hasNext()) {
            EObject eObject = (EObject)iterator.next();
            if (!(eObject instanceof NameExpression)) continue;
            result.add((NameExpression)eObject);
        }
        return result;
    }

    public String getTextToEdit(Object editedObject) {
        if (editedObject instanceof AppliedStereotypeProperty) {
            return AppliedStereotypePropertyEditorUtil.getLabel((AppliedStereotypeProperty)((AppliedStereotypeProperty)editedObject)).trim();
        }
        return "<UNDEFINED>";
    }

    public IParser createParser(final EObject semanticObject) {
        return new IParser(){

            public String getEditString(IAdaptable element, int flags) {
                return StereotypePropertyEditorConfigurationContribution.this.getTextToEdit(StereotypePropertyEditorConfigurationContribution.this.objectToEdit);
            }

            public ICommand getParseCommand(IAdaptable element, String newString, int flags) {
                CompositeCommand result = new CompositeCommand("validation");
                ContextElementAdapter.IContextElementProvider provider = StereotypePropertyEditorConfigurationContribution.this.getContextProvider();
                XtextFakeResourceContext context = new XtextFakeResourceContext(StereotypePropertyEditorConfigurationContribution.this.getInjector());
                context.getFakeResource().eAdapters().add((Object)new ContextElementAdapter(provider));
                try {
                    context.getFakeResource().load((InputStream)new StringInputStream(newString), Collections.EMPTY_MAP);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (provider instanceof ContextElementAdapter.IContextElementProviderWithInit) {
                    ((ContextElementAdapter.IContextElementProviderWithInit)provider).initResource(context.getFakeResource());
                }
                EcoreUtil2.resolveLazyCrossReferences((Resource)context.getFakeResource(), (CancelIndicator)CancelIndicator.NullImpl);
                if (!context.getFakeResource().getParseResult().hasSyntaxErrors() && context.getFakeResource().getErrors().size() == 0) {
                    EObject xtextObject = context.getFakeResource().getParseResult().getRootASTElement();
                    result.add((IUndoableOperation)StereotypePropertyEditorConfigurationContribution.this.getParseCommand(semanticObject, xtextObject));
                } else {
                    result.add((IUndoableOperation)StereotypePropertyEditorConfigurationContribution.this.createInvalidStringCommand(newString, semanticObject));
                }
                return result;
            }

            public String getPrintString(IAdaptable element, int flags) {
                return StereotypePropertyEditorConfigurationContribution.this.getTextToEdit(StereotypePropertyEditorConfigurationContribution.this.objectToEdit);
            }

            public boolean isAffectingEvent(Object event, int flags) {
                return false;
            }

            public IContentAssistProcessor getCompletionProcessor(IAdaptable element) {
                return null;
            }

            public IParserEditStatus isValidEditString(IAdaptable element, String editString) {
                return null;
            }
        };
    }
}

