/*
 * Decompiled with CFR 0.152.
 */
package de.itemis.gmf.runtime.commons.treelayout.policies;

import de.itemis.gmf.runtime.commons.treelayout.TreeLayoutConstraint;
import de.itemis.gmf.runtime.commons.treelayout.TreeLayoutUtil;
import de.itemis.gmf.runtime.commons.treelayout.commands.UpdateAnnotationsOnCreationCommand;
import de.itemis.gmf.runtime.commons.treelayout.commands.UpdateAnnotationsOnMoveCommand;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.AlignmentRequest;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.LabelEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeLayoutEditPolicy
extends XYLayoutEditPolicy {
    private IFigure feedbackFigure;

    protected Command getCreateCommand(CreateRequest request) {
        CreateViewAndElementRequest req;
        CompoundCommand cmd = new CompoundCommand();
        cmd.add(super.getCreateCommand(request));
        if (request instanceof CreateViewAndElementRequest && this.shouldUpdateAnnotationsOnCreation(req = (CreateViewAndElementRequest)request)) {
            cmd.add((Command)new ICommandProxy((ICommand)new UpdateAnnotationsOnCreationCommand(this.getHost().getEditingDomain(), req)));
        }
        return cmd;
    }

    protected boolean shouldUpdateAnnotationsOnCreation(CreateViewAndElementRequest request) {
        return true;
    }

    protected Object getConstraintFor(ChangeBoundsRequest request, GraphicalEditPart child) {
        if (request instanceof AlignmentRequest) {
            return super.getConstraintFor(request, child);
        }
        Rectangle rect = (Rectangle)super.getConstraintFor(request, child);
        Rectangle cons = this.getCurrentConstraintFor(child);
        int newTreePosition = TreeLayoutUtil.getNewTreeNodePosition(request.getLocation(), TreeLayoutUtil.getSiblings((IGraphicalEditPart)child));
        if (cons instanceof TreeLayoutConstraint) {
            TreeLayoutConstraint treeLayoutConstraint = (TreeLayoutConstraint)cons;
            return new TreeLayoutConstraint(rect, treeLayoutConstraint.isRoot(), newTreePosition);
        }
        return new TreeLayoutConstraint(rect, false, newTreePosition);
    }

    protected Command createChangeConstraintCommand(EditPart child, Object constraint) {
        if (constraint instanceof TreeLayoutConstraint) {
            if (((TreeLayoutConstraint)((Object)constraint)).isRoot()) {
                return UnexecutableCommand.INSTANCE;
            }
            return new ICommandProxy((ICommand)new UpdateAnnotationsOnMoveCommand(this.getHost().getEditingDomain(), (IGraphicalEditPart)child, (TreeLayoutConstraint)((Object)constraint)));
        }
        return super.createChangeConstraintCommand(child, constraint);
    }

    protected void showLayoutTargetFeedback(Request request) {
        IGraphicalEditPart editPart;
        List<IGraphicalEditPart> siblingList;
        ChangeBoundsRequest changeBoundsRequest;
        if (request instanceof ChangeBoundsRequest && !(changeBoundsRequest = (ChangeBoundsRequest)request).getEditParts().isEmpty() && !(changeBoundsRequest.getEditParts().get(0) instanceof LabelEditPart) && !(siblingList = TreeLayoutUtil.getSiblings(editPart = (IGraphicalEditPart)changeBoundsRequest.getEditParts().get(0))).isEmpty()) {
            int newTreePosition = TreeLayoutUtil.getNewTreeNodePosition(changeBoundsRequest.getLocation(), TreeLayoutUtil.getSiblings(editPart));
            Point point = newTreePosition == 0 ? this.getFeedBackFigurePoint(editPart.getFigure(), siblingList, 0, 0) : (newTreePosition == siblingList.size() ? this.getFeedBackFigurePoint(editPart.getFigure(), siblingList, siblingList.size(), siblingList.size()) : this.getFeedBackFigurePoint(editPart.getFigure(), siblingList, newTreePosition - 1, newTreePosition));
            Rectangle bounds = this.getFeedbackFigureBounds();
            siblingList.get(0).getFigure().translateToAbsolute((Translatable)bounds);
            bounds.setLocation(point);
            this.getFeedbackFigure().setBounds(bounds);
            this.getFeedbackFigure().translateToRelative((Translatable)this.getFeedbackFigure().getBounds());
            this.getFeedbackLayer().add(this.getFeedbackFigure());
            this.getFeedbackLayer().repaint();
        }
    }

    protected void eraseLayoutTargetFeedback(Request request) {
        super.eraseLayoutTargetFeedback(request);
        this.getFeedbackLayer().getChildren().remove(this.getFeedbackFigure());
        this.getFeedbackLayer().repaint();
    }

    private Point getFeedBackFigurePoint(IFigure childFigure, List<IGraphicalEditPart> siblingList, int lowerIndex, int upperIndex) {
        IFigure bottomFigure;
        IFigure topFigure;
        Point point = new Point();
        if (lowerIndex == siblingList.size()) {
            topFigure = siblingList.get(lowerIndex - 1).getFigure();
            bottomFigure = siblingList.get(upperIndex - 1).getFigure();
        } else {
            topFigure = siblingList.get(lowerIndex).getFigure();
            bottomFigure = siblingList.get(upperIndex).getFigure();
        }
        Rectangle absTopFigBounds = topFigure.getBounds().getCopy();
        topFigure.translateToAbsolute((Translatable)absTopFigBounds);
        Rectangle absBottomFigBounds = bottomFigure.getBounds().getCopy();
        bottomFigure.translateToAbsolute((Translatable)absBottomFigBounds);
        Rectangle feedbackFigBounds = this.getFeedbackFigureBounds();
        topFigure.translateToAbsolute((Translatable)feedbackFigBounds);
        point.x = absTopFigBounds.x - (feedbackFigBounds.width - absTopFigBounds.width) / 2;
        point.y = lowerIndex == 0 && upperIndex == 0 ? absTopFigBounds.y + (absBottomFigBounds.y - absTopFigBounds.y) / 2 - 5 : (lowerIndex == siblingList.size() && upperIndex == siblingList.size() ? absTopFigBounds.y + (absBottomFigBounds.y - absTopFigBounds.y) / 2 + absBottomFigBounds.height + 5 : absTopFigBounds.y + (absBottomFigBounds.y - absTopFigBounds.y) / 2 + absBottomFigBounds.height / 2);
        return point;
    }

    private IFigure getFeedbackFigure() {
        if (this.feedbackFigure == null) {
            RoundedRectangle pl = new RoundedRectangle();
            pl.setForegroundColor(ColorConstants.black);
            pl.setBackgroundColor(ColorConstants.black);
            pl.setBounds(this.getFeedbackFigureBounds());
            this.feedbackFigure = pl;
        }
        return this.feedbackFigure;
    }

    private Rectangle getFeedbackFigureBounds() {
        return new Rectangle(0, 0, 120, 2);
    }

    public IGraphicalEditPart getHost() {
        return (IGraphicalEditPart)super.getHost();
    }
}

