/*
 * Decompiled with CFR 0.152.
 */
package de.itemis.gmf.runtime.commons.treelayout.commands;

import de.itemis.gmf.runtime.commons.treelayout.TreeLayoutUtil;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;

public class UpdateAnnotationsOnCreationCommand
extends AbstractTransactionalCommand {
    public static final String TREE_NODE_PARENT = "TreeNodeParent";
    public static final String ELEMENTS_TO_MERGE = "ElementsToMerge";
    private final CreateViewAndElementRequest request;

    public UpdateAnnotationsOnCreationCommand(TransactionalEditingDomain domain, CreateViewAndElementRequest request) {
        super(domain, "Update Annotations On Creation", null);
        this.request = request;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        Object parent = this.request.getExtendedData().get(TREE_NODE_PARENT);
        if (parent != null && parent instanceof IGraphicalEditPart) {
            int position;
            IGraphicalEditPart parentEditPart = (IGraphicalEditPart)parent;
            ArrayList<IGraphicalEditPart> editPartList = TreeLayoutUtil.getOrderedTreeChildren(parentEditPart);
            Object object = this.request.getExtendedData().get(ELEMENTS_TO_MERGE);
            if (object != null && object instanceof List) {
                List elements = (List)object;
                editPartList.removeAll(elements);
                List<View> viewList = TreeLayoutUtil.getViews(elements);
                TreeLayoutUtil.setTreeNodesPositionAnnotation(viewList);
            }
            if ((position = TreeLayoutUtil.getNewTreeNodePosition(this.request.getLocation(), editPartList)) != -1 && !this.request.getViewDescriptors().isEmpty()) {
                CreateViewRequest.ViewDescriptor viewDescriptor = (CreateViewRequest.ViewDescriptor)this.request.getViewDescriptors().get(0);
                View newView = (View)viewDescriptor.getAdapter(View.class);
                List<View> viewList = TreeLayoutUtil.getViews(editPartList);
                if (position == viewList.size()) {
                    viewList.add(newView);
                } else {
                    viewList.add(position, newView);
                }
                TreeLayoutUtil.setTreeNodesPositionAnnotation(viewList);
                TreeLayoutUtil.setTreeNodeParentAnnotation(newView, parentEditPart.getNotationView());
                return CommandResult.newOKCommandResult();
            }
        }
        return CommandResult.newErrorCommandResult((Throwable)new ExecutionException("ParentTreeNode EditPart not found."));
    }
}

