/*
 * Decompiled with CFR 0.152.
 */
package de.itemis.gmf.runtime.commons.treelayout;

import de.itemis.gmf.runtime.commons.treelayout.TreeLayoutConstraint;
import de.itemis.gmf.runtime.commons.treelayout.TreeLayoutUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeLayout
extends FreeformLayout {
    private final int rankSpacing;
    private final ConnectionLayer connectionLayer;
    private Point parentOffset;
    private Dimension graphSize;
    private int maxTreeLevel;
    private int leafSpacing;
    private boolean isVertical;
    private boolean isTopLeftAlignment;
    private int[] levelOffset;

    public TreeLayout(int rankSpacing, ConnectionLayer connectionLayer) {
        this.rankSpacing = rankSpacing;
        this.connectionLayer = connectionLayer;
        this.isVertical = true;
        this.isTopLeftAlignment = true;
        this.leafSpacing = 5;
        this.maxTreeLevel = 0;
        this.graphSize = new Dimension();
    }

    public boolean isVertical() {
        return this.isVertical;
    }

    public void setVertical(boolean isVertical) {
        this.isVertical = isVertical;
    }

    public boolean isTopLeftAlignment() {
        return this.isTopLeftAlignment;
    }

    public void setTopLeftAlignment(boolean isTopLeftAlignment) {
        this.isTopLeftAlignment = isTopLeftAlignment;
    }

    public int getLeafSpacing() {
        return this.leafSpacing;
    }

    public void setLeafSpacing(int leafSpacing) {
        this.leafSpacing = leafSpacing;
    }

    public void layout(IFigure figure) {
        this.parentOffset = this.getOrigin(figure);
        TreeNode rootTreeNode = this.createNodeTree(figure);
        Dimension parentSize = figure.getBounds().getSize().getCopy();
        if (this.graphSize.width > parentSize.width) {
            parentSize.width = this.graphSize.width;
        }
        if (this.graphSize.height > parentSize.height) {
            parentSize.height = this.graphSize.height;
        }
        if (rootTreeNode != null) {
            double share = this.isVertical ? parentSize.width / rootTreeNode.weight : parentSize.height / rootTreeNode.weight;
            this.layoutTree(rootTreeNode, 0, share);
            this.reduceLeafSpacing(rootTreeNode);
        }
    }

    private void layoutTree(TreeNode treeNode, int start, double share) {
        TreeLayoutConstraint constraint = this.getConstraint(treeNode.figure);
        if (constraint != null) {
            Rectangle bounds = constraint.getCopy();
            if (bounds.width <= 0 || bounds.height <= 0) {
                Dimension preferredSize = treeNode.figure.getPreferredSize(bounds.width, bounds.height);
                if (bounds.width <= 0) {
                    bounds.width = preferredSize.width;
                }
                if (bounds.height <= 0) {
                    bounds.height = preferredSize.height;
                }
            }
            int rankPos = this.isTopLeftAlignment ? treeNode.level : this.maxTreeLevel - treeNode.level;
            int levelPos = this.getlevelPos(rankPos) + this.rankSpacing / 2;
            int cellPos = (int)((double)start + (double)treeNode.weight * share / 2.0);
            bounds.x = this.isVertical ? cellPos - bounds.width / 2 : levelPos;
            bounds.y = this.isVertical ? levelPos : cellPos - bounds.height / 2;
            for (TreeNode childNode : treeNode.children) {
                this.layoutTree(childNode, start, share);
                start = (int)((double)start + share * (double)childNode.weight);
            }
            bounds = bounds.getTranslated(this.parentOffset);
            treeNode.figure.setBounds(bounds);
            treeNode.setLayouted(true);
        }
    }

    private int getlevelPos(int rankPos) {
        int pos = 0;
        int i = this.levelOffset.length - rankPos;
        while (i < this.levelOffset.length) {
            pos += this.levelOffset[i];
            ++i;
        }
        return pos;
    }

    public TreeLayoutConstraint getConstraint(IFigure figure) {
        Rectangle constraint = (Rectangle)super.getConstraint(figure);
        if (constraint != null && !(constraint instanceof TreeLayoutConstraint)) {
            this.setConstraint(figure, (Object)new TreeLayoutConstraint(constraint.getCopy(), false, -1));
        }
        return (TreeLayoutConstraint)((Object)super.getConstraint(figure));
    }

    private TreeNode createNodeTree(IFigure figure) {
        TreeNode rootTreeNode = this.createRootTreeNode(figure);
        if (rootTreeNode != null) {
            this.graphSize = new Dimension();
            List<List<TreeNode>> treeLevelList = this.getTreeLevels(Collections.singletonList(rootTreeNode), 0);
            this.maxTreeLevel = treeLevelList.size() - 1;
            int requiredSize = 0;
            int largestRankSize = 0;
            int rankSize = 0;
            int rowSize = 0;
            this.levelOffset = new int[treeLevelList.size()];
            int rankIndex = treeLevelList.size() - 1;
            while (rankIndex > -1) {
                rankSize = 0;
                rowSize = 0;
                int cellIndex = 0;
                while (cellIndex < treeLevelList.get(rankIndex).size()) {
                    TreeNode treeNode = treeLevelList.get(rankIndex).get(cellIndex);
                    treeNode.setCell(cellIndex);
                    if (treeNode.children.isEmpty()) {
                        treeNode.weight = 1;
                    } else if (treeNode.children.size() == 1) {
                        TreeNode childGraphNode = (TreeNode)treeNode.children.get(0);
                        treeNode.weight = childGraphNode.weight;
                    } else {
                        treeNode.weight = 0;
                        for (TreeNode childGraphNode : treeNode.children) {
                            TreeNode treeNode2 = treeNode;
                            treeNode2.weight = treeNode2.weight + childGraphNode.weight;
                        }
                    }
                    rankSize += this.isVertical ? treeNode.getFigure().getSize().width + this.leafSpacing : treeNode.getFigure().getSize().height + this.leafSpacing;
                    if (this.isVertical) {
                        if (rowSize < treeNode.getFigure().getSize().height + this.rankSpacing) {
                            rowSize = treeNode.getFigure().getSize().height + this.rankSpacing;
                        }
                    } else if (rowSize < treeNode.getFigure().getSize().width + this.rankSpacing) {
                        rowSize = treeNode.getFigure().getSize().width + this.rankSpacing;
                    }
                    ++cellIndex;
                }
                if (largestRankSize < rankSize) {
                    largestRankSize = rankSize;
                }
                this.levelOffset[rankIndex] = rowSize;
                requiredSize += rowSize;
                --rankIndex;
            }
            if (this.isVertical) {
                this.graphSize.width = largestRankSize * 3;
                this.graphSize.height = requiredSize;
            } else {
                this.graphSize.height = largestRankSize * 3;
                this.graphSize.width = requiredSize;
            }
        }
        return rootTreeNode;
    }

    protected TreeNode createRootTreeNode(IFigure parent) {
        List<IFigure> rootFigures = this.getGraphRootFigures(parent);
        if (rootFigures.size() > 1) {
            RectangleFigure rootFigure = new RectangleFigure();
            rootFigure.setPreferredSize(1, 1);
            rootFigure.setSize(1, 1);
            this.setConstraint((IFigure)rootFigure, new Rectangle(0, 0, 0, 0));
            TreeNode rootTreeNode = new TreeNode(null, (IFigure)rootFigure);
            for (IFigure figure : rootFigures) {
                rootTreeNode.children.add(new TreeNode(null, figure));
            }
            return rootTreeNode;
        }
        if (rootFigures.size() == 1) {
            return new TreeNode(null, rootFigures.get(0));
        }
        return null;
    }

    private List<IFigure> getGraphRootFigures(IFigure parent) {
        LinkedList<IFigure> figures = new LinkedList<IFigure>();
        for (IFigure figure : parent.getChildren()) {
            TreeLayoutConstraint bounds;
            TreeLayoutConstraint constraint = this.getConstraint(figure);
            if (!(constraint instanceof TreeLayoutConstraint) || !(bounds = constraint).isRoot()) continue;
            figures.add(figure);
        }
        return figures;
    }

    protected List<List<TreeNode>> getTreeLevels(List<TreeNode> treeNodeList, int level) {
        ArrayList<List<TreeNode>> levelElements = new ArrayList<List<TreeNode>>();
        ArrayList<TreeNode> nextRankElements = new ArrayList<TreeNode>();
        levelElements.add(new ArrayList());
        ((List)levelElements.get(0)).addAll(treeNodeList);
        for (TreeNode treeNode : treeNodeList) {
            treeNode.level = level;
            if (treeNode.children.isEmpty()) {
                List<Connection> connectionList = TreeLayoutUtil.getTreeFigureIncomingConnections(this.connectionLayer, treeNode.getFigure());
                int i = 0;
                while (i < connectionList.size()) {
                    Connection connection = connectionList.get(i);
                    if (connection.getSourceAnchor().getOwner() != null) {
                        IFigure childFig = connection.getSourceAnchor().getOwner();
                        TreeNode childTreeNode = new TreeNode(treeNode, childFig);
                        treeNode.children.add(childTreeNode);
                    }
                    ++i;
                }
            }
            treeNode.children = this.sortTreeNodeList(treeNode.children);
            nextRankElements.addAll(treeNode.children);
        }
        if (!nextRankElements.isEmpty()) {
            levelElements.addAll(this.getTreeLevels(nextRankElements, ++level));
        }
        return levelElements;
    }

    private List<TreeNode> sortTreeNodeList(List<TreeNode> treeNodeList) {
        TreeNode[] sortedTreeNodeList = new TreeNode[treeNodeList.size()];
        ArrayList<TreeNode> notConstrained = new ArrayList<TreeNode>();
        int index = 0;
        while (index < treeNodeList.size()) {
            TreeNode treeNode = treeNodeList.get(index);
            TreeLayoutConstraint constraint = this.getConstraint(treeNode.figure);
            if (constraint.getTreeInnerRankIndex() != -1 && constraint.getTreeInnerRankIndex() < sortedTreeNodeList.length && sortedTreeNodeList[constraint.getTreeInnerRankIndex()] == null) {
                sortedTreeNodeList[constraint.getTreeInnerRankIndex()] = treeNode;
            } else {
                notConstrained.add(treeNode);
            }
            ++index;
        }
        for (TreeNode treeNode : notConstrained) {
            int nextEmptyIndex = this.getNextEmptyIndex(sortedTreeNodeList);
            TreeLayoutConstraint constraint = this.getConstraint(treeNode.figure);
            constraint.setTreeInnerRankIndex(nextEmptyIndex);
            sortedTreeNodeList[nextEmptyIndex] = treeNode;
        }
        return Arrays.asList(sortedTreeNodeList);
    }

    private int getNextEmptyIndex(TreeNode[] list) {
        int index = 0;
        while (index < list.length) {
            if (list[index] == null) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private void reduceLeafSpacing(TreeNode treeNode) {
        block3: {
            block2: {
                if (!this.areLeafs(treeNode.children) || treeNode.children.size() <= 1) break block2;
                TreeNode firstNode = (TreeNode)treeNode.children.get(0);
                TreeNode lastNode = (TreeNode)treeNode.children.get(treeNode.children.size() - 1);
                int delta = ((TreeNode)lastNode).figure.getBounds().y - ((TreeNode)firstNode).figure.getBounds().y;
                int newDelta = (firstNode.getFigure().getBounds().height + this.leafSpacing) * (treeNode.children.size() - 1);
                if (delta - newDelta <= 0) break block3;
                int offset = delta - newDelta;
                int start = ((TreeNode)firstNode).figure.getBounds().y + offset / 2;
                for (TreeNode childTreeNode : treeNode.children) {
                    int index = treeNode.children.indexOf(childTreeNode);
                    Rectangle bounds = childTreeNode.getFigure().getBounds().getCopy();
                    bounds.y = start + (((TreeNode)childTreeNode).figure.getSize().height + this.leafSpacing) * index;
                    childTreeNode.getFigure().setBounds(bounds);
                }
                break block3;
            }
            for (TreeNode childTreeNode : treeNode.children) {
                this.reduceLeafSpacing(childTreeNode);
            }
        }
    }

    private boolean areLeafs(List<TreeNode> childTreeNodeList) {
        for (TreeNode treeNode : childTreeNodeList) {
            if (treeNode.children.isEmpty()) continue;
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class TreeNode {
        private final TreeNode parent;
        private List<TreeNode> children;
        private final IFigure figure;
        private int weight;
        private int level;
        private int cell;
        private boolean isLayouted;

        public TreeNode(TreeNode parent, IFigure figure) {
            this.parent = parent;
            this.figure = figure;
            this.children = new LinkedList<TreeNode>();
            this.weight = 0;
            this.level = -1;
            this.cell = -1;
            this.isLayouted = false;
        }

        public IFigure getFigure() {
            return this.figure;
        }

        public int getWeight() {
            return this.weight;
        }

        public void setWeight(int weight) {
            this.weight = weight;
        }

        public int getLevel() {
            return this.level;
        }

        public void setLevel(int level) {
            this.level = level;
        }

        public int getCell() {
            return this.cell;
        }

        public void setCell(int cell) {
            this.cell = cell;
        }

        public TreeNode getParent() {
            return this.parent;
        }

        public List<TreeNode> getChildren() {
            return this.children;
        }

        public boolean isLayouted() {
            return this.isLayouted;
        }

        public void setLayouted(boolean isLayouted) {
            this.isLayouted = isLayouted;
        }
    }
}

