/*
 * Decompiled with CFR 0.152.
 */
package de.itemis.gmf.runtime.commons.highlighting;

import de.itemis.gmf.runtime.commons.highlighting.HighlightingParameters;
import de.itemis.gmf.runtime.commons.highlighting.IHighlightingSupport;
import de.itemis.gmf.runtime.commons.util.EditPartUtils;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderedNodeFigure;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.parts.DiagramDocumentEditor;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HighlightingSupportAdapter
implements IHighlightingSupport {
    private final Map<IFigure, ColorMemento> figureStates = new HashMap<IFigure, ColorMemento>();
    private final Map<Color, Color> greyscaleColors = new HashMap<Color, Color>();
    private boolean locked = false;
    private final IDiagramWorkbenchPart diagramWorkbenchPart;

    public HighlightingSupportAdapter(IDiagramWorkbenchPart diagramWorkbenchPart) {
        this.diagramWorkbenchPart = diagramWorkbenchPart;
    }

    @Override
    public synchronized void fadeIn(EObject semanticElement, HighlightingParameters parameters) {
        IGraphicalEditPart editPart = this.getEditPartForSemanticElement(semanticElement);
        if (editPart == null) {
            return;
        }
        this.diagramWorkbenchPart.getDiagramGraphicalViewer().reveal((EditPart)editPart);
        IFigure figure = this.getTargetFigure(editPart);
        Assert.isNotNull((Object)figure, (String)"Could not obtain target figure");
        Display.getCurrent().asyncExec((Runnable)new Fader(figure, figure.getForegroundColor(), parameters.foregroundFadingColor, figure.getBackgroundColor(), parameters.backgroundFadingColor, (int)parameters.fadingTime, false));
    }

    @Override
    public synchronized void fadeOut(EObject semanticElement, HighlightingParameters parameters) {
        if (!this.locked) {
            throw new IllegalStateException("May only highlight if editor is locked");
        }
        IGraphicalEditPart editPart = this.getEditPartForSemanticElement(semanticElement);
        if (editPart == null) {
            return;
        }
        IFigure figure = this.getTargetFigure(editPart);
        Assert.isNotNull((Object)figure, (String)"Could not obtain target figure");
        Color foregroundColor = this.figureStates.get(figure).foregroundColor;
        Color backgroundColor = this.figureStates.get(figure).backgroundColor;
        Display.getCurrent().asyncExec((Runnable)new Fader(figure, parameters.foregroundFadingColor, parameters.grayScale ? this.getGreyscaled(foregroundColor) : foregroundColor, parameters.backgroundFadingColor, parameters.grayScale ? this.getGreyscaled(backgroundColor) : backgroundColor, (int)parameters.fadingTime, false));
    }

    @Override
    public synchronized void flash(EObject semanticElement, HighlightingParameters parameters) {
        if (!this.locked) {
            throw new IllegalStateException("May only highlight if editor is locked");
        }
        IGraphicalEditPart editPart = this.getEditPartForSemanticElement(semanticElement);
        if (editPart == null) {
            return;
        }
        this.diagramWorkbenchPart.getDiagramGraphicalViewer().reveal((EditPart)editPart);
        IFigure figure = this.getTargetFigure(editPart);
        Display.getCurrent().asyncExec((Runnable)new Fader(figure, figure.getForegroundColor(), parameters.foregroundFadingColor, figure.getBackgroundColor(), parameters.backgroundFadingColor, (int)parameters.fadingTime, true));
    }

    private IGraphicalEditPart getEditPartForSemanticElement(EObject semanticElement) {
        return EditPartUtils.findEditPartForSemanticElement((EditPart)this.diagramWorkbenchPart.getDiagramGraphicalViewer().getRootEditPart(), semanticElement);
    }

    private Color getGreyscaled(Color color) {
        if (this.greyscaleColors.containsKey(color)) {
            return this.greyscaleColors.get(color);
        }
        ImageData imageData = new ImageData(1, 1, 24, new PaletteData(255, 65280, 0xFF0000));
        imageData.setPixel(0, 0, imageData.palette.getPixel(color.getRGB()));
        Image image = new Image((Device)Display.getCurrent(), imageData);
        Image convertedImage = new Image((Device)Display.getCurrent(), image, 1);
        Color newColor = new Color((Device)Display.getCurrent(), convertedImage.getImageData().palette.getRGB(convertedImage.getImageData().getPixel(0, 0)));
        this.greyscaleColors.put(color, newColor);
        convertedImage.dispose();
        image.dispose();
        return newColor;
    }

    private IFigure getTargetFigure(IGraphicalEditPart editPart) {
        IFigure figure = editPart.getFigure();
        if (figure instanceof BorderedNodeFigure) {
            figure = (IFigure)figure.getChildren().get(0);
        }
        if (figure instanceof DefaultSizeNodeFigure) {
            figure = (IFigure)figure.getChildren().get(0);
        }
        return figure;
    }

    @Override
    public synchronized void lockEditor() {
        if (this.locked) {
            throw new IllegalStateException("Editor already locked!");
        }
        this.setSanityCheckEnablementState(false);
        for (Object editPart : this.diagramWorkbenchPart.getDiagramGraphicalViewer().getEditPartRegistry().values()) {
            if (!(editPart instanceof IGraphicalEditPart)) continue;
            IGraphicalEditPart graphicalEditPart = (IGraphicalEditPart)editPart;
            IFigure figure = this.getTargetFigure(graphicalEditPart);
            this.figureStates.put(figure, new ColorMemento(figure));
        }
        this.locked = true;
    }

    private void setSanityCheckEnablementState(boolean state) {
        try {
            Method enableMethod = DiagramDocumentEditor.class.getDeclaredMethod("enableSanityChecking", Boolean.TYPE);
            enableMethod.setAccessible(true);
            enableMethod.invoke((Object)this.diagramWorkbenchPart, state);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public synchronized void releaseEditor() {
        if (!this.locked) {
            throw new IllegalStateException("Editor not locked!");
        }
        for (ColorMemento figureState : this.figureStates.values()) {
            figureState.restore();
        }
        this.figureStates.clear();
        this.diagramWorkbenchPart.getDiagramEditPart().enableEditMode();
        this.setSanityCheckEnablementState(true);
        this.locked = false;
    }

    @Override
    public void highlight(EObject semanticElement, HighlightingParameters parameters) {
        IGraphicalEditPart editPartForSemanticElement = this.getEditPartForSemanticElement(semanticElement);
        if (editPartForSemanticElement != null) {
            IFigure figure = this.getTargetFigure(editPartForSemanticElement);
            if (parameters != null) {
                figure.setForegroundColor(parameters.foregroundFadingColor);
                figure.setBackgroundColor(parameters.backgroundFadingColor);
                figure.invalidate();
            } else {
                ColorMemento memento = this.figureStates.get(figure);
                if (memento != null) {
                    memento.restore();
                }
            }
        }
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public void executeBatch(final List<IHighlightingSupport.Action> actions) {
        if (actions != null) {
            Display.getCurrent().asyncExec(new Runnable(){

                public void run() {
                    for (IHighlightingSupport.Action a : actions) {
                        a.execute(HighlightingSupportAdapter.this);
                    }
                }
            });
        }
    }

    private class ColorMemento {
        private final Color foregroundColor;
        private final Color backgroundColor;
        private final IFigure figure;

        protected ColorMemento(IFigure figure) {
            this.figure = figure;
            this.foregroundColor = figure.getForegroundColor();
            this.backgroundColor = figure.getBackgroundColor();
        }

        protected void restore() {
            this.figure.setForegroundColor(this.foregroundColor);
            this.figure.setBackgroundColor(this.backgroundColor);
        }
    }

    private class Fader
    implements Runnable {
        private final int fadingTime;
        private final Color sourceForegroundColor;
        private final Color targetForegroundColor;
        private final IFigure figure;
        private final boolean shouldFadeBack;
        private final Color sourceBackgroundColor;
        private final Color targetBackgroundColor;

        private Fader(IFigure figure, Color sourceForegroundColor, Color targetForegroundColor, Color sourceBackgroundColor, Color targetBackgroundColor, int fadingTime, boolean shouldFadeBack) {
            this.figure = figure;
            this.sourceForegroundColor = sourceForegroundColor;
            this.targetForegroundColor = targetForegroundColor;
            this.sourceBackgroundColor = sourceBackgroundColor;
            this.targetBackgroundColor = targetBackgroundColor;
            this.shouldFadeBack = shouldFadeBack;
            this.fadingTime = fadingTime;
        }

        public void run() {
            if (!HighlightingSupportAdapter.this.locked) {
                return;
            }
            this.figure.setForegroundColor(this.targetForegroundColor);
            this.figure.setBackgroundColor(this.targetBackgroundColor);
            this.figure.invalidate();
            if (this.shouldFadeBack) {
                Display.getCurrent().timerExec(this.fadingTime, (Runnable)new Fader(this.figure, this.targetForegroundColor, this.sourceForegroundColor, this.targetBackgroundColor, this.sourceBackgroundColor, this.fadingTime, false));
            }
        }
    }
}

