/*
 * Decompiled with CFR 0.152.
 */
package de.itemis.gmf.runtime.commons.editpolicies;

import de.itemis.gmf.runtime.commons.commands.CompartmentChildCreateCommand;
import de.itemis.gmf.runtime.commons.commands.CompartmentRepositionEObjectCommand;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.OrderedLayout;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.FlowLayoutEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.AddCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ResizableEditPolicyEx;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.notation.View;

public class CompartmentLayoutEditPolicy
extends FlowLayoutEditPolicy {
    private EStructuralFeature feature = null;

    public CompartmentLayoutEditPolicy(EStructuralFeature feature) {
        this.feature = feature;
    }

    protected Command createAddCommand(EditPart child, EditPart after) {
        int index = this.getHost().getChildren().indexOf(after);
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        CompartmentAddCommand command = new CompartmentAddCommand(editingDomain, (IAdaptable)new EObjectAdapter((EObject)((View)this.getHost().getModel())), (IAdaptable)new EObjectAdapter((EObject)((View)child.getModel())), index);
        return new ICommandProxy((ICommand)command);
    }

    protected EditPolicy createChildEditPolicy(EditPart child) {
        ResizableEditPolicyEx policy = new ResizableEditPolicyEx();
        policy.setResizeDirections(0);
        return policy;
    }

    protected Command createMoveChildCommand(EditPart child, EditPart after) {
        int displacement;
        int newIndex;
        int childIndex = this.getHost().getChildren().indexOf(child);
        int afterIndex = this.getHost().getChildren().indexOf(after);
        if (afterIndex == -1) {
            newIndex = this.getHost().getChildren().size() - 1;
            displacement = newIndex - childIndex;
        } else {
            newIndex = afterIndex;
            displacement = afterIndex - childIndex;
            if (childIndex <= afterIndex) {
                --newIndex;
                --displacement;
            }
        }
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        CompartmentRepositionEObjectCommand command = new CompartmentRepositionEObjectCommand(child, editingDomain, "", (EList)((View)child.getParent().getModel()).getElement().eGet(this.feature), ((View)child.getModel()).getElement(), displacement, newIndex);
        this.eraseLayoutTargetFeedback(null);
        return new ICommandProxy((ICommand)command);
    }

    protected Command getCreateCommand(CreateRequest request) {
        if (request instanceof CreateViewAndElementRequest) {
            TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
            CompositeTransactionalCommand cc = new CompositeTransactionalCommand(editingDomain, DiagramUIMessages.AddCommand_Label);
            for (CreateViewRequest.ViewDescriptor descriptor : ((CreateViewRequest)request).getViewDescriptors()) {
                int feedBackIndex = this.getFeedbackIndexFor((Request)request);
                CreateElementRequest createElementRequest = (CreateElementRequest)((CreateViewAndElementRequest)request).getViewAndElementDescriptor().getCreateElementRequestAdapter().getAdapter(CreateElementRequest.class);
                if (createElementRequest != null) {
                    createElementRequest.getParameters().put(RequestParameterKeys.RegionFeedbackIndex, feedBackIndex);
                }
                CompartmentChildCreateCommand createCommand = new CompartmentChildCreateCommand(editingDomain, descriptor, (View)this.getHost().getModel(), feedBackIndex);
                cc.compose((IUndoableOperation)createCommand);
            }
            return new ICommandProxy(cc.reduce());
        }
        return null;
    }

    protected boolean isHorizontal() {
        IFigure figure = ((IGraphicalEditPart)this.getHost()).getContentPane();
        if (figure.getLayoutManager() instanceof OrderedLayout) {
            return ((OrderedLayout)figure.getLayoutManager()).isHorizontal();
        }
        return true;
    }

    protected Command getDeleteDependantCommand(Request request) {
        return null;
    }

    protected Command getOrphanChildrenCommand(Request request) {
        return null;
    }

    private class CompartmentAddCommand
    extends AddCommand {
        private IAdaptable parent;
        private IAdaptable child;
        private int index;

        public CompartmentAddCommand(TransactionalEditingDomain editingDomain, IAdaptable parent, IAdaptable child, int index) {
            super(editingDomain, parent, child, index);
            assert (parent != null) : "Null parent in CompartmentAddCommand";
            assert (child != null) : "Null child in CompartmentAddCommand";
            this.parent = parent;
            this.child = child;
            this.index = index;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            View childView = (View)this.child.getAdapter(View.class);
            View parentView = (View)this.parent.getAdapter(View.class);
            if (parentView.getPersistedChildren().contains((Object)childView) && this.index != -1) {
                parentView.getPersistedChildren().move(this.index, (Object)childView);
            } else if (this.index == -1) {
                parentView.insertChild(childView);
            } else {
                parentView.insertChildAt(childView, this.index);
            }
            return CommandResult.newOKCommandResult();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RequestParameterKeys {
        RegionFeedbackIndex;

    }
}

