/*
 * Decompiled with CFR 0.152.
 */
package de.itemis.gmf.runtime.commons.decorators;

import de.itemis.gmf.runtime.commons.decorators.BaseDecorator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IPrimaryEditPart;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.Decoration;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoration;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;

public abstract class InteractiveDecorator
extends BaseDecorator {
    protected MouseListener decorationMouseListener = new MouseListener(){

        public void mousePressed(MouseEvent me) {
            InteractiveDecorator.this.mousePressed(InteractiveDecorator.this.getDecoration(), InteractiveDecorator.this.getSemanticElement());
        }

        public void mouseReleased(MouseEvent me) {
            InteractiveDecorator.this.mouseReleased(InteractiveDecorator.this.getDecoration(), InteractiveDecorator.this.getSemanticElement());
        }

        public void mouseDoubleClicked(MouseEvent me) {
            InteractiveDecorator.this.mouseDoubleClicked(InteractiveDecorator.this.getDecoration(), InteractiveDecorator.this.getSemanticElement());
        }
    };

    protected abstract IFigure getToolTipFigure(EObject var1);

    protected abstract Image getDecorationImage(EObject var1);

    protected abstract boolean shouldDecorate(EObject var1);

    public InteractiveDecorator(IDecoratorTarget decoratorTarget) {
        super(decoratorTarget);
    }

    protected abstract IDecoratorTarget.Direction getDecoratorPosition();

    public void refresh() {
        this.disposeDecoration();
        if (this.getDecoratorTarget().getAdapter(EditPart.class) instanceof IPrimaryEditPart) {
            EObject semanticElement = this.getSemanticElement();
            if (this.shouldDecorate(this.getSemanticElement())) {
                this.setDecoration((IDecoration)this.createDecoration(semanticElement));
            }
        }
    }

    protected Decoration createDecoration(EObject semanticElement) {
        Decoration decoration = (Decoration)this.getDecoratorTarget().addShapeDecoration(this.getDecorationImage(semanticElement), this.getDecoratorPosition(), -5, false);
        this.renderToolTip(decoration, semanticElement);
        decoration.addMouseListener(this.decorationMouseListener);
        return decoration;
    }

    public EObject getSemanticElement() {
        return (EObject)this.getDecoratorTarget().getAdapter(EObject.class);
    }

    protected void disposeDecoration() {
        if (this.getDecoration() != null) {
            this.getDecoration().removeMouseListener(this.decorationMouseListener);
        }
        this.removeDecoration();
    }

    protected Image resize(Image image, int width, int height) {
        Image scaled = new Image(image.getDevice(), width, height);
        GC gc = new GC((Drawable)scaled);
        gc.setAntialias(1);
        gc.setInterpolation(2);
        gc.drawImage(image, 0, 0, image.getBounds().width, image.getBounds().height, 0, 0, width, height);
        gc.dispose();
        image.dispose();
        return scaled;
    }

    protected void renderToolTip(final Decoration decoration, final EObject semanticElement) {
        decoration.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent me) {
            }

            public void mouseEntered(MouseEvent me) {
                IFigure toolTip = InteractiveDecorator.this.getToolTipFigure(semanticElement);
                if (toolTip != null) {
                    decoration.setToolTip(toolTip);
                }
            }

            public void mouseExited(MouseEvent me) {
            }

            public void mouseHover(MouseEvent me) {
            }

            public void mouseMoved(MouseEvent me) {
            }
        });
    }

    protected void mousePressed(Decoration decoration, EObject element) {
    }

    protected void mouseReleased(Decoration decoration, EObject element) {
    }

    protected void mouseDoubleClicked(Decoration decoration, EObject element) {
    }
}

