/*
 * Decompiled with CFR 0.152.
 */
package de.itemis.gmf.runtime.commons.decorators;

import de.itemis.gmf.runtime.commons.decorators.AbstractDecoratorProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gmf.runtime.common.ui.resources.FileChangeManager;
import org.eclipse.gmf.runtime.common.ui.resources.IFileObserver;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditDomain;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.AbstractDecorator;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecorator;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorProvider;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractMarkerBasedDecorationProvider
extends AbstractDecoratorProvider
implements IDecoratorProvider {
    private static MarkerObserver fileObserver;
    private static Map<String, List<IDecorator>> allDecorators;

    static {
        allDecorators = new HashMap<String, List<IDecorator>>();
    }

    protected abstract boolean shouldInstall(IEditorPart var1);

    protected abstract String getDecoratorKey();

    protected abstract StatusDecorator createStatusDecorator(IDecoratorTarget var1);

    public void createDecorators(IDecoratorTarget decoratorTarget) {
        EditPart editPart = (EditPart)decoratorTarget.getAdapter(EditPart.class);
        if (editPart instanceof GraphicalEditPart || editPart instanceof AbstractConnectionEditPart) {
            EditDomain ed = editPart.getViewer().getEditDomain();
            if (!(ed instanceof DiagramEditDomain)) {
                return;
            }
            if (this.shouldInstall(((DiagramEditDomain)ed).getEditorPart())) {
                decoratorTarget.installDecorator((Object)this.getDecoratorKey(), (IDecorator)this.createStatusDecorator(decoratorTarget));
            }
        }
    }

    protected static void refreshDecorators(String viewId, Diagram diagram) {
        List<IDecorator> decorators;
        List<IDecorator> list = decorators = viewId != null ? allDecorators.get(viewId) : null;
        if (decorators == null || decorators.isEmpty() || diagram == null) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            public void run() {
                for (IDecorator decorator : decorators) {
                    decorator.refresh();
                }
            }
        });
    }

    protected static class MarkerObserver
    implements IFileObserver {
        private final Diagram diagram;

        private MarkerObserver(Diagram diagram) {
            this.diagram = diagram;
        }

        public void handleFileRenamed(IFile oldFile, IFile file) {
        }

        public void handleFileMoved(IFile oldFile, IFile file) {
        }

        public void handleFileDeleted(IFile file) {
        }

        public void handleFileChanged(IFile file) {
        }

        public void handleMarkerAdded(IMarker marker) {
            if (marker.getAttribute("elementId", null) != null) {
                this.handleMarkerChanged(marker);
            }
        }

        public void handleMarkerDeleted(IMarker marker, Map attributes) {
            if (attributes == null) {
                return;
            }
            String viewId = (String)attributes.get("elementId");
            if (viewId == null) {
                return;
            }
            AbstractMarkerBasedDecorationProvider.refreshDecorators(viewId, this.diagram);
        }

        public void handleMarkerChanged(IMarker marker) {
            String viewId = marker.getAttribute("elementId", "");
            AbstractMarkerBasedDecorationProvider.refreshDecorators(viewId, this.diagram);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class StatusDecorator
    extends AbstractDecorator {
        private String viewId;

        protected abstract String getMarkerType();

        protected abstract void createDecorators(View var1, List<IMarker> var2);

        public StatusDecorator(IDecoratorTarget decoratorTarget) {
            super(decoratorTarget);
            try {
                final View view = (View)this.getDecoratorTarget().getAdapter(View.class);
                TransactionUtil.getEditingDomain((EObject)view).runExclusive(new Runnable(){

                    public void run() {
                        StatusDecorator.this.viewId = view != null ? ViewUtil.getIdStr((View)view) : null;
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void refresh() {
            this.removeDecoration();
            View view = (View)this.getDecoratorTarget().getAdapter(View.class);
            if (view == null || view.eResource() == null) {
                return;
            }
            EditPart editPart = (EditPart)this.getDecoratorTarget().getAdapter(EditPart.class);
            if (editPart == null || editPart.getViewer() == null) {
                return;
            }
            IFile resource = WorkspaceSynchronizer.getFile((Resource)view.eResource());
            if (resource == null || !resource.exists()) {
                return;
            }
            ArrayList<IMarker> markers = new ArrayList<IMarker>();
            try {
                markers.addAll(Arrays.asList(resource.findMarkers(this.getMarkerType(), true, 2)));
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            if (markers == null || markers.size() == 0) {
                return;
            }
            this.createDecorators(view, markers);
        }

        public void activate() {
            if (this.viewId == null) {
                return;
            }
            ArrayList<StatusDecorator> list = (ArrayList<StatusDecorator>)allDecorators.get(this.viewId);
            if (list == null) {
                list = new ArrayList<StatusDecorator>(2);
                list.add(this);
                allDecorators.put(this.viewId, list);
            } else if (!list.contains((Object)this)) {
                list.add(this);
            }
            View view = (View)this.getDecoratorTarget().getAdapter(View.class);
            if (view == null) {
                return;
            }
            Diagram diagramView = view.getDiagram();
            if (diagramView == null) {
                return;
            }
            if (fileObserver == null) {
                FileChangeManager fileChangeManager = FileChangeManager.getInstance();
                MarkerObserver markerObserver = new MarkerObserver(diagramView);
                fileObserver = markerObserver;
                fileChangeManager.addFileObserver((IFileObserver)markerObserver);
            }
        }

        public void deactivate() {
            if (this.viewId == null) {
                return;
            }
            List list = (List)allDecorators.get(this.viewId);
            if (list != null) {
                list.remove((Object)this);
                if (list.isEmpty()) {
                    allDecorators.remove(this.viewId);
                }
            }
            if (fileObserver != null && allDecorators.isEmpty()) {
                FileChangeManager.getInstance().removeFileObserver((IFileObserver)fileObserver);
                fileObserver = null;
            }
            super.deactivate();
        }
    }
}

