/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.composite.custom.locators;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.diagram.ui.figures.IBorderItemLocator;
import org.eclipse.papyrus.uml.diagram.composite.custom.locators.ExternalPortPositionLocator;
import org.eclipse.papyrus.uml.diagram.composite.custom.locators.InternalPortPositionLocator;
import org.eclipse.papyrus.uml.diagram.composite.custom.preferences.CustomDiagramPreferencePage;
import org.eclipse.papyrus.uml.diagram.composite.part.UMLDiagramEditorPlugin;

public class PortPositionLocator
implements IBorderItemLocator {
    protected org.eclipse.papyrus.uml.diagram.common.locator.PortPositionLocator currentLocator = null;
    protected IFigure parentFigure;
    protected int preferredSide;

    public PortPositionLocator(IFigure parentFigure, int preferredSide) {
        this.currentLocator = new ExternalPortPositionLocator(parentFigure, preferredSide);
        this.parentFigure = parentFigure;
        this.preferredSide = preferredSide;
    }

    public Rectangle getValidLocation(Rectangle proposedLocation, IFigure borderItem) {
        this.updateLocator();
        return this.currentLocator.getValidLocation(proposedLocation, borderItem);
    }

    public void setConstraint(Rectangle constraint) {
        this.updateLocator();
        this.currentLocator.setConstraint(constraint);
    }

    public int getCurrentSideOfParent() {
        this.updateLocator();
        return this.currentLocator.getCurrentSideOfParent();
    }

    public void relocate(IFigure target) {
        this.updateLocator();
        this.currentLocator.relocate(target);
    }

    public Rectangle getPreferredLocation(Rectangle proposedLocation) {
        return this.currentLocator.getPreferredLocation(proposedLocation);
    }

    public void setInternal() {
        if (this.currentLocator instanceof ExternalPortPositionLocator) {
            this.currentLocator = new InternalPortPositionLocator(this.parentFigure, this.preferredSide);
        }
    }

    public void setExternal() {
        if (this.currentLocator instanceof InternalPortPositionLocator) {
            this.currentLocator = new ExternalPortPositionLocator(this.parentFigure, this.preferredSide);
        }
    }

    protected void updateLocator() {
        boolean isInside = UMLDiagramEditorPlugin.getInstance().getPreferenceStore().getBoolean(CustomDiagramPreferencePage.IS_INSIDE_COMPOSITE_COMPOSITE_DIAGRAM);
        if (isInside) {
            this.setInternal();
        } else {
            this.setExternal();
        }
    }
}

