/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public abstract class DfsOutputStream
extends OutputStream {
    public int blockSize() {
        return 0;
    }

    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b});
    }

    public abstract void write(byte[] var1, int var2, int var3) throws IOException;

    public abstract int read(long var1, ByteBuffer var3) throws IOException;

    public InputStream openInputStream(long position) {
        return new ReadBackStream(position);
    }

    private class ReadBackStream
    extends InputStream {
        private final ByteBuffer buf;
        private long position;

        private ReadBackStream(long position) {
            int bs = DfsOutputStream.this.blockSize();
            this.position = position;
            this.buf = ByteBuffer.allocate(bs > 0 ? bs : 8192);
            this.buf.position(this.buf.limit());
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int cnt = 0;
            while (0 < len) {
                if (!this.buf.hasRemaining()) {
                    this.buf.rewind();
                    int nr = DfsOutputStream.this.read(this.position, this.buf);
                    if (nr < 0) {
                        this.buf.position(this.buf.limit());
                        break;
                    }
                    this.position += (long)nr;
                    this.buf.flip();
                }
                int n = Math.min(len, this.buf.remaining());
                this.buf.get(b, off, n);
                off += n;
                len -= n;
                cnt += n;
            }
            if (cnt == 0 && len > 0) {
                return -1;
            }
            return cnt;
        }

        public int read() throws IOException {
            byte[] b = new byte[1];
            int n = this.read(b);
            return n == 1 ? b[0] & 0xFF : -1;
        }
    }
}

