/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.gitrepo;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.FileChannel;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.SubmoduleAddCommand;
import org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.gitrepo.internal.RepoText;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.util.FileUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepoCommand
extends GitCommand<RevCommit> {
    private String path;
    private String uri;
    private String groups;
    private String branch;
    private PersonIdent author;
    private RemoteReader callback;
    private List<Project> bareProjects;
    private Git git;
    private ProgressMonitor monitor;

    public RepoCommand(Repository repo) {
        super(repo);
    }

    public RepoCommand setPath(String path) {
        this.path = path;
        return this;
    }

    public RepoCommand setURI(String uri) {
        this.uri = uri;
        return this;
    }

    public RepoCommand setGroups(String groups) {
        this.groups = groups;
        return this;
    }

    public RepoCommand setBranch(String branch) {
        this.branch = branch;
        return this;
    }

    public RepoCommand setProgressMonitor(ProgressMonitor monitor) {
        this.monitor = monitor;
        return this;
    }

    public RepoCommand setAuthor(PersonIdent author) {
        this.author = author;
        return this;
    }

    public RepoCommand setRemoteReader(RemoteReader callback) {
        this.callback = callback;
        return this;
    }

    @Override
    public RevCommit call() throws GitAPIException {
        this.checkCallable();
        if (this.path == null || this.path.length() == 0) {
            throw new IllegalArgumentException(JGitText.get().pathNotConfigured);
        }
        if (this.uri == null || this.uri.length() == 0) {
            throw new IllegalArgumentException(JGitText.get().uriNotConfigured);
        }
        if (this.repo.isBare()) {
            this.bareProjects = new ArrayList<Project>();
            if (this.author == null) {
                this.author = new PersonIdent(this.repo);
            }
            if (this.callback == null) {
                this.callback = new DefaultRemoteReader();
            }
        } else {
            this.git = new Git(this.repo);
        }
        XmlManifest manifest = new XmlManifest(this, this.path, this.uri, this.groups);
        try {
            manifest.read();
        }
        catch (IOException e) {
            throw new ManifestErrorException(e);
        }
        if (this.repo.isBare()) {
            DirCache index = DirCache.newInCore();
            DirCacheBuilder builder = index.builder();
            ObjectInserter inserter = this.repo.newObjectInserter();
            RevWalk rw = new RevWalk(this.repo);
            try {
                Config cfg = new Config();
                for (Project proj : this.bareProjects) {
                    String name = proj.path;
                    String uri = proj.name;
                    cfg.setString("submodule", name, "path", name);
                    cfg.setString("submodule", name, "url", uri);
                    DirCacheEntry dcEntry = new DirCacheEntry(name);
                    ObjectId objectId = ObjectId.isId(proj.revision) ? ObjectId.fromString(proj.revision) : this.callback.sha1(uri, proj.revision);
                    if (objectId == null) {
                        throw new RemoteUnavailableException(uri);
                    }
                    dcEntry.setObjectId(objectId);
                    dcEntry.setFileMode(FileMode.GITLINK);
                    builder.add(dcEntry);
                    for (CopyFile copyfile : proj.copyfiles) {
                        byte[] src = this.callback.readFile(uri, proj.revision, copyfile.src);
                        objectId = inserter.insert(3, src);
                        dcEntry = new DirCacheEntry(copyfile.dest);
                        dcEntry.setObjectId(objectId);
                        dcEntry.setFileMode(FileMode.REGULAR_FILE);
                        builder.add(dcEntry);
                    }
                }
                String content = cfg.toText();
                DirCacheEntry dcEntry = new DirCacheEntry(".gitmodules");
                ObjectId objectId = inserter.insert(3, content.getBytes("UTF-8"));
                dcEntry.setObjectId(objectId);
                dcEntry.setFileMode(FileMode.REGULAR_FILE);
                builder.add(dcEntry);
                builder.finish();
                ObjectId treeId = index.writeTree(inserter);
                ObjectId headId = this.repo.resolve("HEAD^{commit}");
                CommitBuilder commit = new CommitBuilder();
                commit.setTreeId(treeId);
                if (headId != null) {
                    commit.setParentIds(headId);
                }
                commit.setAuthor(this.author);
                commit.setCommitter(this.author);
                commit.setMessage(RepoText.get().repoCommitMessage);
                ObjectId commitId = inserter.insert(commit);
                inserter.flush();
                RefUpdate ru = this.repo.updateRef("HEAD");
                ru.setNewObjectId(commitId);
                ru.setExpectedOldObjectId(headId != null ? headId : ObjectId.zeroId());
                RefUpdate.Result rc = ru.update(rw);
                switch (rc) {
                    case NEW: 
                    case FORCED: 
                    case FAST_FORWARD: {
                        break;
                    }
                    case REJECTED: 
                    case LOCK_FAILURE: {
                        throw new ConcurrentRefUpdateException(JGitText.get().couldNotLockHEAD, ru.getRef(), rc);
                    }
                    default: {
                        throw new JGitInternalException(MessageFormat.format(JGitText.get().updatingRefFailed, new Object[]{"HEAD", commitId.name(), rc}));
                    }
                }
                RevCommit revCommit = rw.parseCommit(commitId);
                return revCommit;
            }
            catch (IOException e) {
                throw new ManifestErrorException(e);
            }
            finally {
                rw.release();
            }
        }
        return this.git.commit().setMessage(RepoText.get().repoCommitMessage).call();
    }

    private void addSubmodule(String url, String name, String revision, List<CopyFile> copyfiles) throws SAXException {
        if (this.repo.isBare()) {
            Project proj = new Project(url, name, revision, null);
            proj.copyfiles.addAll(copyfiles);
            this.bareProjects.add(proj);
        } else {
            SubmoduleAddCommand add = this.git.submoduleAdd().setPath(name).setURI(url);
            if (this.monitor != null) {
                add.setProgressMonitor(this.monitor);
            }
            try {
                Repository subRepo = add.call();
                if (revision != null) {
                    Git sub = new Git(subRepo);
                    sub.checkout().setName(RepoCommand.findRef(revision, subRepo)).call();
                    this.git.add().addFilepattern(name).call();
                }
                for (CopyFile copyfile : copyfiles) {
                    copyfile.copy();
                    this.git.add().addFilepattern(copyfile.dest).call();
                }
            }
            catch (GitAPIException e) {
                throw new SAXException(e);
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        }
    }

    private static String findRef(String ref, Repository repo) throws IOException {
        Ref r;
        if (!ObjectId.isId(ref) && (r = repo.getRef("origin/" + ref)) != null) {
            return r.getName();
        }
        return ref;
    }

    private static class CopyFile {
        final Repository repo;
        final String path;
        final String src;
        final String dest;

        CopyFile(Repository repo, String path, String src, String dest) {
            this.repo = repo;
            this.path = path;
            this.src = src;
            this.dest = dest;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void copy() throws IOException {
            File srcFile = new File(this.repo.getWorkTree(), this.path + "/" + this.src);
            File destFile = new File(this.repo.getWorkTree(), this.dest);
            FileInputStream input = new FileInputStream(srcFile);
            try {
                FileOutputStream output = new FileOutputStream(destFile);
                try {
                    FileChannel channel = input.getChannel();
                    output.getChannel().transferFrom(channel, 0L, channel.size());
                }
                finally {
                    output.close();
                }
            }
            finally {
                input.close();
            }
        }
    }

    public static class DefaultRemoteReader
    implements RemoteReader {
        public ObjectId sha1(String uri, String ref) throws GitAPIException {
            Object refs = Git.lsRemoteRepository().setRemote(uri).call();
            HashMap<String, Ref> map = new HashMap<String, Ref>(refs.size());
            Iterator i$ = refs.iterator();
            while (i$.hasNext()) {
                Ref r = (Ref)i$.next();
                map.put(r.getName(), r);
            }
            Ref r = RefDatabase.findRef(map, ref);
            return r != null ? r.getObjectId() : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] readFile(String uri, String ref, String path) throws GitAPIException, IOException {
            byte[] result;
            File dir = FileUtils.createTempDir("jgit_", ".git", null);
            Repository repo = Git.cloneRepository().setBare(true).setDirectory(dir).setURI(uri).call().getRepository();
            ObjectReader reader = repo.newObjectReader();
            try {
                ObjectId oid = repo.resolve(ref + ":" + path);
                result = reader.open(oid).getBytes(Integer.MAX_VALUE);
            }
            finally {
                reader.release();
                FileUtils.delete(dir, 1);
            }
            return result;
        }
    }

    private static class ManifestErrorException
    extends GitAPIException {
        ManifestErrorException(Throwable cause) {
            super(RepoText.get().invalidManifest, cause);
        }
    }

    private static class Project {
        final String name;
        final String path;
        final String revision;
        final Set<String> groups;
        final List<CopyFile> copyfiles;

        Project(String name, String path, String revision, String groups) {
            this.name = name;
            this.path = path;
            this.revision = revision;
            this.groups = new HashSet<String>();
            if (groups != null && groups.length() > 0) {
                this.groups.addAll(Arrays.asList(groups.split(",")));
            }
            this.copyfiles = new ArrayList<CopyFile>();
        }

        void addCopyFile(CopyFile copyfile) {
            this.copyfiles.add(copyfile);
        }
    }

    public static interface RemoteReader {
        public ObjectId sha1(String var1, String var2) throws GitAPIException;

        public byte[] readFile(String var1, String var2, String var3) throws GitAPIException, IOException;
    }

    private static class RemoteUnavailableException
    extends GitAPIException {
        RemoteUnavailableException(String uri) {
            super(MessageFormat.format(RepoText.get().errorRemoteUnavailable, uri));
        }
    }

    private static class XmlManifest
    extends DefaultHandler {
        private final RepoCommand command;
        private final String filename;
        private final String baseUrl;
        private final Map<String, String> remotes;
        private final List<Project> projects;
        private final Set<String> plusGroups;
        private final Set<String> minusGroups;
        private String defaultRemote;
        private String defaultRevision;
        private Project currentProject;

        XmlManifest(RepoCommand command, String filename, String baseUrl, String groups) {
            this.command = command;
            this.filename = filename;
            this.baseUrl = baseUrl;
            this.remotes = new HashMap<String, String>();
            this.projects = new ArrayList<Project>();
            this.plusGroups = new HashSet<String>();
            this.minusGroups = new HashSet<String>();
            if (groups == null || groups.length() == 0 || groups.equals("default")) {
                this.minusGroups.add("notdefault");
            } else {
                for (String group : groups.split(",")) {
                    if (group.startsWith("-")) {
                        this.minusGroups.add(group.substring(1));
                        continue;
                    }
                    this.plusGroups.add(group);
                }
            }
        }

        void read() throws IOException {
            XMLReader xr;
            try {
                xr = XMLReaderFactory.createXMLReader();
            }
            catch (SAXException e) {
                throw new IOException(JGitText.get().noXMLParserAvailable);
            }
            xr.setContentHandler(this);
            FileInputStream in = new FileInputStream(this.filename);
            try {
                xr.parse(new InputSource(in));
            }
            catch (SAXException e) {
                IOException error = new IOException(MessageFormat.format(RepoText.get().errorParsingManifestFile, this.filename));
                error.initCause(e);
                throw error;
            }
            finally {
                in.close();
            }
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("project".equals(qName)) {
                this.currentProject = new Project(attributes.getValue("name"), attributes.getValue("path"), attributes.getValue("revision"), attributes.getValue("groups"));
            } else if ("remote".equals(qName)) {
                this.remotes.put(attributes.getValue("name"), attributes.getValue("fetch"));
            } else if ("default".equals(qName)) {
                this.defaultRemote = attributes.getValue("remote");
                this.defaultRevision = attributes.getValue("revision");
                if (this.defaultRevision == null) {
                    this.defaultRevision = this.command.branch;
                }
            } else if ("copyfile".equals(qName)) {
                if (this.currentProject == null) {
                    throw new SAXException(RepoText.get().invalidManifest);
                }
                this.currentProject.addCopyFile(new CopyFile(this.command.repo, this.currentProject.path, attributes.getValue("src"), attributes.getValue("dest")));
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if ("project".equals(qName)) {
                this.projects.add(this.currentProject);
                this.currentProject = null;
            }
        }

        public void endDocument() throws SAXException {
            String remoteUrl;
            if (this.defaultRemote == null) {
                throw new SAXException(MessageFormat.format(RepoText.get().errorNoDefault, this.filename));
            }
            try {
                URI uri = new URI(String.format("%s/%s/", this.baseUrl, this.remotes.get(this.defaultRemote)));
                remoteUrl = uri.normalize().toString();
            }
            catch (URISyntaxException e) {
                throw new SAXException(e);
            }
            for (Project proj : this.projects) {
                if (!this.inGroups(proj)) continue;
                this.command.addSubmodule(remoteUrl + proj.name, proj.path, proj.revision == null ? this.defaultRevision : proj.revision, proj.copyfiles);
            }
        }

        boolean inGroups(Project proj) {
            for (String group : this.minusGroups) {
                if (!proj.groups.contains(group)) continue;
                return false;
            }
            if (this.plusGroups.isEmpty() || this.plusGroups.contains("all")) {
                return true;
            }
            for (String group : this.plusGroups) {
                if (!proj.groups.contains(group)) continue;
                return true;
            }
            return false;
        }
    }
}

